/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocCancelSaleOrderConfirmOrRefuseService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocCancelSaleOrderConfirmOrRefuseService"})
public class UocCancelSaleOrderConfirmOrRefuseServiceImpl
implements UocCancelSaleOrderConfirmOrRefuseService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private UocInitConfig uocInitConfig;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;

    @PostMapping(value={"cancelSaleOrderConfirmOrRefuse"})
    public UocCancelSaleOrderConfirmOrRefuseRspBo cancelSaleOrderConfirmOrRefuse(@RequestBody UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        this.validateArg(reqBo);
        Date now = new Date();
        this.iUocChngOrderModel.updateChngOrderMain(this.convertChngOrderDo(reqBo, now));
        this.iUocSaleOrderModel.modifySaleOrderMain(this.convertSaleOrderDo(reqBo, now));
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryAddBoList())) {
            this.iUocOrderModel.createOrderAccessory(this.convertSaleOrderAccessory(reqBo, now));
        }
        this.dealMap(reqBo, now);
        return UocRu.success(UocCancelSaleOrderConfirmOrRefuseRspBo.class);
    }

    private UocChngOrderDo convertChngOrderDo(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo, Date now) {
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            uocChngOrderDo.setChngOrderState("CHNG_XS_YQR");
        } else {
            uocChngOrderDo.setChngOrderState("CHNG_XS_YJJ");
        }
        uocChngOrderDo.setRejectReason(reqBo.getCancelReplyContent());
        uocChngOrderDo.setRejectTime(now);
        uocChngOrderDo.setUpdateOperName(reqBo.getName());
        uocChngOrderDo.setUpdateTime(now);
        uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        return uocChngOrderDo;
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getChngOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelReplyContent(reqBo.getCancelReplyContent());
        uocSaleOrderDo.setCancelReplyTime(now);
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            uocSaleOrderDo.setSaleOrderState("XS_QX_QX");
        } else {
            UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
            uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
            uocChngOrderObjQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocChngOrderObjQryBo.setChngOrderId(reqBo.getChngOrderId());
            List<UocChngOrderObj> chngOrderObj = this.iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
            if (CollectionUtils.isEmpty(chngOrderObj)) {
                throw new BaseBusinessException("101011", "\u67e5\u8be2\u53d8\u66f4\u5355\u5bf9\u8c61\u4e3a\u7a7a");
            }
            UocChngOrderObj uocChngOrderObj = chngOrderObj.get(0);
            uocSaleOrderDo.setSaleOrderState(uocChngOrderObj.getOtherChngValue());
        }
        return uocSaleOrderDo;
    }

    private void dealMap(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
            ArrayList<UocChngOrderMap> extParallelBoList = new ArrayList<UocChngOrderMap>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocChngOrderMap);
            });
            delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
            this.iUocChngOrderModel.updateInvalid(delChngOrderDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            UocChngOrderDo add = new UocChngOrderDo();
            UocChngOrderDo modify = new UocChngOrderDo();
            ArrayList<UocChngOrderMap> addList = new ArrayList<UocChngOrderMap>();
            ArrayList<UocChngOrderMap> modifyList = new ArrayList<UocChngOrderMap>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                    addShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                    updateShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setUocChngOrderMapList(addList);
                this.iUocChngOrderModel.addChngOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setUocChngOrderMapList(modifyList);
                this.iUocChngOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && !OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u64cd\u4f5c\u53ea\u80fd\u662f\u63a5\u53d7\u6216\u62d2\u7edd");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getChngOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && StringUtils.isBlank((CharSequence)reqBo.getCancelReplyContent())) {
            throw new BaseBusinessException("100001", "\u62d2\u7edd\u65f6\uff0c\u56de\u590d\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            });
        }
    }
}

