/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.domainservice.UocQryLogisticsInfoService;
import com.tydic.dyc.oc.service.domainservice.bo.OrderTrackInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQrderTrackSearchBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryLogisticsInfoServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryLogisticsInfoServiceRspBo;
import com.tydic.dyc.oc.utils.ESBParamUtil;
import com.tydic.dyc.oc.utils.SslClientUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocQryLogisticsInfoService"})
public class UocQryLogisticsInfoServiceImpl
implements UocQryLogisticsInfoService {
    private static final Logger log = LoggerFactory.getLogger(UocQryLogisticsInfoServiceImpl.class);
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Value(value="${logistics.track.url:https://poll.kuaidi100.com/poll/query.do}")
    private String trackUrl;
    public static final String HEAD_KEY = "Content-Type";
    public static final String HEAD_VALUE = "application/x-www-form-urlencoded";

    @PostMapping(value={"qryLogisticsDataList"})
    public UocQryLogisticsInfoServiceRspBo qryLogisticsDataList(@RequestBody UocQryLogisticsInfoServiceReqBo reqBo) {
        UocQryLogisticsInfoServiceRspBo rspBo = UocRu.success(UocQryLogisticsInfoServiceRspBo.class);
        this.validateParams(reqBo);
        log.info("\u67e5\u8be2\u7269\u6d41\u6570\u636e\u4fe1\u606f\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBo));
        rspBo = UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(reqBo.getType()) ? this.qryNonEsLogisData(reqBo, rspBo) : this.qryEsLogisData(reqBo, rspBo);
        return rspBo;
    }

    private UocQryLogisticsInfoServiceRspBo qryEsLogisData(UocQryLogisticsInfoServiceReqBo reqBo, UocQryLogisticsInfoServiceRspBo rspBo) {
        try {
            String reqStr = this.initEsPostStr(reqBo);
            String returnString = SslClientUtil.doPost(UocOrderPropertiesUtil.getProperty("ESB_QRY_ORDER_TRACK_URL"), reqStr);
            log.info("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587:{}", (Object)returnString);
            if (ObjectUtil.isEmpty((Object)returnString)) {
                throw new BaseBusinessException("101014", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            }
            rspBo = this.resolveEsRsp(returnString, rspBo);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38:{}", (Throwable)e);
            throw new BaseBusinessException("101013", "\u8c03\u7528ESB\u67e5\u8be2\u914d\u9001\u4fe1\u606f\u670d\u52a1\u63a5\u53e3\u5f02\u5e38");
        }
        return rspBo;
    }

    private UocQryLogisticsInfoServiceRspBo qryNonEsLogisData(UocQryLogisticsInfoServiceReqBo reqBo, UocQryLogisticsInfoServiceRspBo rspBo) {
        try {
            String reqBoStr = this.initNonEsPostStr(reqBo);
            String result = SslClientUtil.doPost(this.trackUrl, reqBoStr, HEAD_KEY, HEAD_VALUE);
            log.info("\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u5feb\u9012\u4fe1\u606f\u67e5\u8be2\u54cd\u5e94\u62a5\u6587:{}", (Object)result);
            if (ObjectUtil.isEmpty((Object)result)) {
                throw new BaseBusinessException("101014", "\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u5feb\u9012\u4fe1\u606f\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
            }
            rspBo = this.resolveNonEsRsp(rspBo, reqBo, result);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u5feb\u9012\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38:{}", (Throwable)e);
            throw new BaseBusinessException("101013", "\u8c03\u7528\u5feb\u9012100\u5b9e\u65f6\u5feb\u9012\u4fe1\u606f\u67e5\u8be2\u5f02\u5e38");
        }
        return rspBo;
    }

    private UocQryLogisticsInfoServiceRspBo resolveNonEsRsp(UocQryLogisticsInfoServiceRspBo rspBo, UocQryLogisticsInfoServiceReqBo reqBo, String result) {
        JSONObject rspObj;
        ArrayList<OrderTrackInfoBO> orderTrackList = new ArrayList<OrderTrackInfoBO>();
        if (ObjectUtil.isNotEmpty((Object)result) && (null != (rspObj = JSON.parseObject((String)result)).get((Object)"returnCode") && "200".equals(rspObj.get((Object)"returnCode").toString()) || null != rspObj.get((Object)"message") && "ok".equals(rspObj.get((Object)"message").toString()))) {
            rspBo.setOrderId(reqBo.getOrderId());
            if (ObjectUtil.isNotNull((Object)rspObj.get((Object)"nu"))) {
                rspBo.setDeliveryOrderId(rspObj.get((Object)"nu").toString());
            }
            if (ObjectUtil.isNotNull((Object)rspObj.get((Object)"com"))) {
                UocSysDictionaryQryBo qryBo = new UocSysDictionaryQryBo();
                qryBo.setPCode("UOC_ORD_LOGISTICS_COMPANY_CODE");
                qryBo.setCode(rspObj.get((Object)"com").toString());
                List<UocSysDictionaryDo> uocSysDictionaryDos = this.iUocSysDictionaryModel.qryDicList(qryBo);
                if (ObjectUtil.isNotEmpty(uocSysDictionaryDos)) {
                    rspBo.setCarrier(uocSysDictionaryDos.get(0).getDescrip());
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rspObj.get((Object)"data"))) {
                JSONArray data = JSON.parseArray((String)JSON.toJSONString((Object)rspObj.get((Object)"data")));
                for (int i = 0; i < data.size(); ++i) {
                    JSONObject obj = data.getJSONObject(i);
                    OrderTrackInfoBO trackInfoBO = new OrderTrackInfoBO();
                    if (ObjectUtil.isNotNull((Object)obj.get((Object)"time"))) {
                        trackInfoBO.setMsgTime(obj.get((Object)"time").toString());
                    }
                    if (ObjectUtil.isNotNull((Object)obj.get((Object)"status"))) {
                        trackInfoBO.setStatus(obj.get((Object)"status").toString());
                    }
                    if (ObjectUtil.isNotNull((Object)obj.get((Object)"context"))) {
                        StringBuilder sb = new StringBuilder(obj.get((Object)"context").toString());
                        if (ObjectUtil.isNotNull((Object)obj.get((Object)"location"))) {
                            sb.append("\u5f53\u524d\u5730\u70b9\uff1a" + obj.get((Object)"location").toString());
                        }
                        trackInfoBO.setContent(sb.toString());
                    }
                    orderTrackList.add(trackInfoBO);
                }
            }
        }
        rspBo.setOrderTrackList(orderTrackList);
        return rspBo;
    }

    private String initNonEsPostStr(UocQryLogisticsInfoServiceReqBo reqBo) {
        JSONObject reqObj = new JSONObject();
        JSONObject param = new JSONObject();
        reqObj.put("customer", (Object)"customer");
        reqObj.put("sign", (Object)"sign");
        param.put("com", (Object)"com");
        param.put("num", (Object)reqBo.getOrderId());
        param.put("resultv2", (Object)6);
        if (ObjectUtil.isNotNull((Object)reqBo.getSearchConditions())) {
            UocQrderTrackSearchBO searchConditions = reqBo.getSearchConditions();
            param.put("phone", (Object)searchConditions.getPhoneNumber());
            param.put("from", (Object)searchConditions.getSource());
            param.put("to", (Object)searchConditions.getTarget());
            param.put("show", (Object)searchConditions.getReturnFormat());
            param.put("order", (Object)searchConditions.getOrderBy());
        }
        reqObj.put("param", (Object)param);
        return reqObj.toJSONString();
    }

    private String initEsPostStr(UocQryLogisticsInfoServiceReqBo reqBo) {
        String hsn = UocOrderPropertiesUtil.getProperty("SUPPLIER_ID_" + reqBo.getSupplierId());
        String esbReqParam = ESBParamUtil.getEsbReqParam(reqBo, hsn, "BUSINESS_ORDER");
        log.info("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)esbReqParam);
        return esbReqParam;
    }

    private UocQryLogisticsInfoServiceRspBo resolveEsRsp(String returnString, UocQryLogisticsInfoServiceRspBo rspBo) {
        log.info("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u8fd4\u56de\u6570\u636e\uff1a{}", (Object)returnString);
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            if ("0000".equals(jsonObject.get((Object)"resultCode"))) {
                String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
                if (ObjectUtil.isNotEmpty((Object)jsonStr)) {
                    String waybillCode;
                    List orderTrackList;
                    JSONObject object = JSONObject.parseObject((String)jsonStr);
                    String orderTrack = JSONObject.toJSONString((Object)object.get((Object)"orderTrack"));
                    String orderId = (String)JSONObject.parseObject((String)jsonStr).get((Object)"orderId");
                    if (ObjectUtil.isNotEmpty((Object)orderTrack) && ObjectUtil.isNotEmpty((Object)(orderTrackList = JSON.parseArray((String)orderTrack, OrderTrackInfoBO.class)))) {
                        this.listSort(orderTrackList);
                        rspBo.setOrderTrackList(orderTrackList);
                    }
                    if ((waybillCode = object.getString("waybillCode")) != null) {
                        try {
                            JSONArray array = JSONArray.parseArray((String)waybillCode);
                            rspBo.setCarrier(array.getJSONObject(0).getString("carrier"));
                            rspBo.setDeliveryOrderId(array.getJSONObject(0).getString("deliveryOrderId"));
                        }
                        catch (Exception e) {
                            try {
                                JSONObject code = JSONObject.parseObject((String)waybillCode);
                                rspBo.setCarrier(code.getString("carrier"));
                                rspBo.setDeliveryOrderId(code.getString("deliveryOrderId"));
                            }
                            catch (Exception ignored) {
                                log.error("\u89e3\u6790\u5f02\u5e38:{}", (Object)ignored.getMessage());
                            }
                        }
                    }
                    rspBo.setOrderId(orderId);
                }
            } else {
                rspBo.setRespCode("101012");
                rspBo.setRespDesc("\u8c03\u7528\u914d\u9001\u4fe1\u606f\u67e5\u8be2ESB\u63a5\u53e3\u5931\u8d25" + jsonObject.get((Object)"resultMessage"));
            }
        }
        return rspBo;
    }

    private void listSort(List<OrderTrackInfoBO> list) {
        Collections.sort(list, new Comparator<OrderTrackInfoBO>(){

            @Override
            public int compare(OrderTrackInfoBO o1, OrderTrackInfoBO o2) {
                try {
                    Date dt1 = DelFormatHelper.fromSdfToDate((String)o1.getMsgTime());
                    Date dt2 = DelFormatHelper.fromSdfToDate((String)o2.getMsgTime());
                    if (dt1.getTime() < dt2.getTime()) {
                        return 1;
                    }
                    if (dt1.getTime() > dt2.getTime()) {
                        return -1;
                    }
                    return 0;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
    }

    private void validateParams(UocQryLogisticsInfoServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryLogisticsInfoServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBo.getType())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.equal((Object)reqBo.getType(), (Object)UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT) && ObjectUtil.isNull((Object)reqBo.getSupplierId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

