/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocQryOrderCreateResultService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryOrderCreateResultServiceRspProcessDataBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocQryOrderCreateResultService"})
public class UocQryOrderCreateResultServiceImpl
implements UocQryOrderCreateResultService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"qryOrderCreateResult"})
    public UocQryOrderCreateResultServiceRspBo qryOrderCreateResult(@RequestBody UocQryOrderCreateResultServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocQryOrderCreateResultServiceRspBo rspBo = UocRu.success(UocQryOrderCreateResultServiceRspBo.class);
        UocOrderDo qryOrderDo = new UocOrderDo();
        qryOrderDo.setOrderId(reqBo.getOrderId());
        UocOrderDo uocOrderDo = this.iUocOrderModel.qryOrderBy(qryOrderDo);
        if (ObjectUtil.isEmpty((Object)((Object)uocOrderDo))) {
            return rspBo;
        }
        rspBo.setOrderId(reqBo.getOrderId());
        rspBo.setOrderNo(uocOrderDo.getOrderNo());
        rspBo.setTotalSaleFee(uocOrderDo.getTotalSaleFee());
        boolean processResult = true;
        rspBo.setSuccessList(new ArrayList());
        rspBo.setFailedList(new ArrayList());
        UocSaleOrderDo qrySaleDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        List<UocSaleOrderDo> uocSaleOrderDos = this.iUocSaleOrderModel.qrySaleOrderList(qrySaleDo);
        for (UocSaleOrderDo uocSaleOrderDo : uocSaleOrderDos) {
            if (ObjectUtil.isEmpty((Object)uocSaleOrderDo.getSaleOrderState()) || "XS_CJ_CJ".equals(uocSaleOrderDo.getSaleOrderState())) {
                processResult = false;
            }
            UocQryOrderCreateResultServiceRspProcessDataBo resultDataBo = new UocQryOrderCreateResultServiceRspProcessDataBo();
            if (ObjectUtil.isNotEmpty((Object)uocSaleOrderDo.getCancelReason()) || "XS_QX_QX".equals(uocSaleOrderDo.getSaleOrderState())) {
                resultDataBo.setMsg(uocSaleOrderDo.getCancelReason());
                rspBo.getFailedList().add(resultDataBo);
            } else {
                rspBo.getSuccessList().add(resultDataBo);
            }
            resultDataBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
            resultDataBo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
            resultDataBo.setSupNo(uocSaleOrderDo.getStakeholder().getSupId());
            resultDataBo.setSupName(uocSaleOrderDo.getStakeholder().getSupName());
        }
        rspBo.setProcessResult(Boolean.valueOf(processResult));
        return rspBo;
    }

    private void validateArg(UocQryOrderCreateResultServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocQryOrderCreateResultServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010\u8ba2\u5355id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

