package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocCancelSaleOrderServiceImpl
 * 说明:销售单取消
 * 时间:2022/2/25 10:33
 * 作者:田坤林
 */

@HTServiceImpl
public class UocCancelSaleOrderServiceImpl implements UocCancelSaleOrderService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocCancelSaleOrderServiceRspBo cancelSaleOrder(UocCancelSaleOrderServiceReqBo reqBo) {

        //参数校验
        validateArg(reqBo);
        Date now = new Date();
        iUocSaleOrderModel.modifySaleOrderMain(convertSaleOrderDo(reqBo, now));
        //保存附件
        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryAddBoList())) {
            iUocOrderModel.createOrderAccessory(convertSaleOrderAccessory(reqBo, now));
        }
		dealMap(reqBo, now);
        return UocRu.success(UocCancelSaleOrderServiceRspBo.class);
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

	private UocSaleOrderDo convertSaleOrderDo(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
		UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
		uocSaleOrderDo.setUpdateTime(now);
		uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
		uocSaleOrderDo.setCancelTime(now);
		uocSaleOrderDo.setCancelReason(reqBo.getCancelReason());
		uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
		return uocSaleOrderDo;
	}

	/**
	 * 扩展属性处理
	 */
	private void dealMap(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
		if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
			UocSaleOrderDo delSaleOrderDo = new UocSaleOrderDo();
			List<UocSaleOrderMap> extParallelBoList = new ArrayList<>();
			reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
				UocSaleOrderMap uocSaleOrderMap = new UocSaleOrderMap();
				uocSaleOrderMap.setOrderId(reqBo.getOrderId());
				uocSaleOrderMap.setSaleOrderId(uocBaseExtParallelDeleteBo.getObjId());
				uocSaleOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
				uocSaleOrderMap.setUpdateOperId(reqBo.getUserId().toString());
				uocSaleOrderMap.setUpdateTime(now);
				extParallelBoList.add(uocSaleOrderMap);
			});
			delSaleOrderDo.setSaleOrderMapList(extParallelBoList);
			iUocSaleOrderModel.updateInvalid(delSaleOrderDo);
		}
		if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
			UocSaleOrderDo add = new UocSaleOrderDo();
			UocSaleOrderDo modify = new UocSaleOrderDo();
			List<UocSaleOrderMap> addList = new ArrayList<>();
			List<UocSaleOrderMap> modifyList = new ArrayList<>();
			reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
				if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
					UocSaleOrderMap addShipOrderMap = new UocSaleOrderMap();
					addShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
					addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
					addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
					addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
					addShipOrderMap.setOrderId(reqBo.getOrderId());
					addShipOrderMap.setId(IdUtil.nextId());
					addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
					addShipOrderMap.setCreateTime(now);
					addList.add(addShipOrderMap);
				} else {
					UocSaleOrderMap updateShipOrderMap = new UocSaleOrderMap();
					updateShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
					updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
					updateShipOrderMap.setOrderId(reqBo.getOrderId());
					updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
					updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
					updateShipOrderMap.setUpdateTime(now);
					modifyList.add(updateShipOrderMap);
				}
			});
			if (!CollectionUtils.isEmpty(addList)) {
				add.setSaleOrderMapList(addList);
				iUocSaleOrderModel.addSaleOrderMap(add);
			}
			if (!CollectionUtils.isEmpty(modifyList)) {
				modify.setSaleOrderMapList(modifyList);
				iUocSaleOrderModel.updateBatchValue(modify);
			}
		}
	}

	private void validateArg(UocCancelSaleOrderServiceReqBo reqBo) {
		if (reqBo == null) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCancelSaleOrderServiceReqBo]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单id]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getCancelReason())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取消原因]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getUserId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户ID]不能为空");
		}

		if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
			reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
				if (null == uocBaseExtParallelDeleteBo.getObjId()) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
				}
				if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
				}
			});
		}
		if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
			reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
				if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
				}
				if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
				}
				if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
					}
				}
				if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
					}
				}
			});
		}
	}
}
