package com.tydic.dyc.oc.model.payorder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderItemObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderMapQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderItemObj;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderMap;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderObj;
import com.tydic.dyc.oc.repository.UocPayOrderRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题:IUocPayOrderModel
 * 说明:支付单
 * 时间:2022/2/23 14:01
 * 作者:tkl
 */

@Service
public class IUocPayOrderModelImpl implements IUocPayOrderModel {

    @Autowired
    private UocPayOrderRepository uocPayOrderRepository;

    @Override
    public UocPayOrder getPayOrderMain(UocPayOrderQryBo uocPayOrderQryBo) {
        if (ObjectUtil.isNull(uocPayOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getPayOrderMain(uocPayOrderQryBo);
    }

    @Override
    public List<UocPayOrder> getListPayOrder(UocPayOrderQryBo uocPayOrderQryBo) {
        if (ObjectUtil.isNull(uocPayOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrder(uocPayOrderQryBo);
    }

    @Override
    public List<UocPayOrderObj> getListPayOrderObj(UocPayOrderObjQryBo uocPayOrderObjQryBo) {
        if (ObjectUtil.isNull(uocPayOrderObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrderObj(uocPayOrderObjQryBo);
    }

    @Override
    public List<UocPayOrderItemObj> getListPayOrderItemObj(UocPayOrderItemObjQryBo uocPayOrderItemObjQryBo) {
        if (ObjectUtil.isNull(uocPayOrderItemObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrderItemObj(uocPayOrderItemObjQryBo);
    }

    @Override
    public List<UocPayOrderMap> getListPayOrderMap(UocPayOrderMapQryBo uocPayOrderMapQryBo) {
        if (ObjectUtil.isNull(uocPayOrderMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocPayOrderRepository.getListPayOrderMap(uocPayOrderMapQryBo);
    }
}
