package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;

import java.util.List;

/**
 * 标题:UocChngOrderRepository
 * 说明:变更单
 * 时间:2022/3/8 18:05
 * 作者:罗有
 */

public interface UocChngOrderRepository {

	/**
	 * 创建变更单
	 *
	 * @param uocChngOrderDo
	 */
	void createChngOrder(UocChngOrderDo uocChngOrderDo);

	/**
	 * 修改变更单状态
	 *
	 * @param uocChngOrderDoList
	 */
	void modifyBatchChngOrderState(List<UocChngOrderDo> uocChngOrderDoList);

	/**
	 * 查询变更单明细对象列表
	 *
	 * @param uocChngOrderItemObjQryBo
	 * @return
	 */
	List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo);

	/**
	 * 查询变更单信息
	 *
	 * @param uocChngOrderQryBo
	 * @return
	 */
	List<UocChngOrderDo> getListChngOrder(UocChngOrderQryBo uocChngOrderQryBo);

	/**
	 * 更新变更单状态 和 环节编码
	 *
	 * @param uocChngOrderDo
	 */
	void updateChngStatusAndProCode(UocChngOrderDo uocChngOrderDo);

	/**
	 * 查询变更单信息
	 *
	 * @param uocChngOrderQryBo
	 * @return
	 */
	UocChngOrderDo getChngOrder(UocChngOrderQryBo uocChngOrderQryBo);

	/**
	 * 修改变更单主体信息
	 *
	 * @param uocChngOrderDo
	 */
	void updateChngOrderMain(UocChngOrderDo uocChngOrderDo);

	List<UocChngOrderObj> getListChngOrderObj(UocChngOrderObjQryBo uocChngOrderObjQryBo);

	/**
	 * 增加扩展字段
	 *
	 * @param uocChngOrderDo
	 */
	void addChngOrderMap(UocChngOrderDo uocChngOrderDo);

	/**
	 * 更新扩展字段
	 *
	 * @param uocChngOrderDo
	 */
	void updateBatchValue(UocChngOrderDo uocChngOrderDo);

	/**
	 * 更新扩展字段
	 *
	 * @param uocChngOrderDo
	 */
	void updateInvalid(UocChngOrderDo uocChngOrderDo);
}
