package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DelFormatHelper;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocThirdApiCommonConstant;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.ESBParamUtil;
import com.tydic.dyc.oc.utils.SslClientUtil;
import com.tydic.dyc.oc.utils.UocOrderPropertiesUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.net.URI;
import java.util.*;

/**
 * 标题:UocQryLogisticsInfoServiceImpl
 * 说明:查询物流信息服务
 * 时间:2022/3/10 16:26
 * 作者:tkl
 */
@HTServiceImpl
@Slf4j
public class UocQryLogisticsInfoServiceImpl implements UocQryLogisticsInfoService {

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Value("${logistics.track.url:https://poll.kuaidi100.com/poll/query.do}")
    private String trackUrl;
    public static final String HEAD_KEY = "Content-Type";
    public static final String HEAD_VALUE = "application/x-www-form-urlencoded";

    @Override
    public UocQryLogisticsInfoServiceRspBo qryLogisticsDataList(UocQryLogisticsInfoServiceReqBo reqBo) {
        UocQryLogisticsInfoServiceRspBo rspBo = UocRu.success(UocQryLogisticsInfoServiceRspBo.class);
        validateParams(reqBo);
        log.info("查询物流数据信息入参:{}", JSON.toJSONString(reqBo));
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(reqBo.getType())) {
            rspBo = qryNonEsLogisData(reqBo, rspBo);
        } else {
            rspBo = qryEsLogisData(reqBo, rspBo);
        }
        return rspBo;
    }

    /**
     * 查询电商物流信息
     *
     * @param reqBo
     * @param rspBo
     * @return UocQryLogisticsInfoServiceRspBo
     */
    private UocQryLogisticsInfoServiceRspBo qryEsLogisData(UocQryLogisticsInfoServiceReqBo reqBo, UocQryLogisticsInfoServiceRspBo rspBo) {
        try {
            // 请求报文
            String reqStr = initEsPostStr(reqBo);
            //下发
            String returnString = SslClientUtil.doPost(UocOrderPropertiesUtil.getProperty(UocThirdApiCommonConstant.ESB_QRY_ORDER_TRACK_URL), reqStr);
            log.info("调用ESB查询配送信息接口响应报文:{}", returnString);
            if (ObjectUtil.isEmpty(returnString)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_THREE_DATA_NULL, "调用ESB查询配送信息接口响应报文为空");
            }
            // 解析返回的报文
            rspBo = resolveEsRsp(returnString, rspBo);
        } catch (Exception e) {
            log.error("调用ESB查询配送信息服务接口异常:{}", e);
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CALL_THIRD_SERVICE, "调用ESB查询配送信息服务接口异常");
        }
        return rspBo;
    }

    /**
     * 查询非电商物流信息
     *
     * @param reqBo
     * @param rspBo
     * @return UocQryLogisticsInfoServiceRspBo
     */
    private UocQryLogisticsInfoServiceRspBo qryNonEsLogisData(UocQryLogisticsInfoServiceReqBo reqBo, UocQryLogisticsInfoServiceRspBo rspBo) {
        try {
            //组装入参
            String reqBoStr = initNonEsPostStr(reqBo);
            String result = SslClientUtil.doPost(trackUrl, reqBoStr, HEAD_KEY, HEAD_VALUE);
            log.info("调用快递100实时快递信息查询响应报文:{}", result);
            if (ObjectUtil.isEmpty(result)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_THREE_DATA_NULL, "调用快递100实时快递信息接口响应报文为空");
            }
            //解析出参
            rspBo = resolveNonEsRsp(rspBo, reqBo, result);
        } catch (Exception e) {
            log.error("调用快递100实时快递信息查询异常:{}", e);
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CALL_THIRD_SERVICE, "调用快递100实时快递信息查询异常");
        }
        return rspBo;
    }

    /**
     * 解析出参
     *
     * @param rspBo
     * @param reqBo
     * @param result
     */
    private UocQryLogisticsInfoServiceRspBo resolveNonEsRsp(UocQryLogisticsInfoServiceRspBo rspBo, UocQryLogisticsInfoServiceReqBo reqBo, String result) {
        List<OrderTrackInfoBO> orderTrackList = new ArrayList<>();
        if (ObjectUtil.isNotEmpty(result)) {
            JSONObject rspObj = JSON.parseObject(result);
            if ((null != rspObj.get(UocConstant.RESPONSE_PARAMS.RETURN_CODE)
                    && "200".equals(rspObj.get(UocConstant.RESPONSE_PARAMS.RETURN_CODE).toString()))
                    || (null != rspObj.get(UocConstant.RESPONSE_PARAMS.MESSAGE)
                    && "ok".equals(rspObj.get(UocConstant.RESPONSE_PARAMS.MESSAGE).toString()))) {
                //订单编号
                rspBo.setOrderId(reqBo.getOrderId());
                //运单号
                if (ObjectUtil.isNotNull(rspObj.get(UocConstant.RESPONSE_PARAMS.NU))) {
                    rspBo.setDeliveryOrderId(rspObj.get(UocConstant.RESPONSE_PARAMS.NU).toString());
                }
                //物流公司
                if (ObjectUtil.isNotNull(rspObj.get(UocConstant.RESPONSE_PARAMS.COM))) {
                    UocSysDictionaryQryBo qryBo = new UocSysDictionaryQryBo();
                    qryBo.setPCode(UocDicConstant.LOGISTICS_COMPANY_CODE.P_CODE);
                    qryBo.setCode(rspObj.get(UocConstant.RESPONSE_PARAMS.COM).toString());
                    List<UocSysDictionaryDo> uocSysDictionaryDos = iUocSysDictionaryModel.qryDicList(qryBo);
                    if (ObjectUtil.isNotEmpty(uocSysDictionaryDos)) {
                        rspBo.setCarrier(uocSysDictionaryDos.get(0).getDescrip());
                    }
                }
                //配送信息
                if (ObjectUtil.isNotEmpty(rspObj.get(UocConstant.RESPONSE_PARAMS.DATA))) {
                    JSONArray data = JSON.parseArray(JSON.toJSONString(rspObj.get(UocConstant.RESPONSE_PARAMS.DATA)));
                    for (int i = 0; i < data.size(); i++) {
                        JSONObject obj = data.getJSONObject(i);
                        OrderTrackInfoBO trackInfoBO = new OrderTrackInfoBO();
                        //时间
                        if (ObjectUtil.isNotNull(obj.get(UocConstant.RESPONSE_PARAMS.TIME))) {
                            trackInfoBO.setMsgTime(obj.get(UocConstant.RESPONSE_PARAMS.TIME).toString());
                        }
                        //状态
                        if (ObjectUtil.isNotNull(obj.get(UocConstant.RESPONSE_PARAMS.STATUS))) {
                            trackInfoBO.setStatus(obj.get(UocConstant.RESPONSE_PARAMS.STATUS).toString());
                        }
                        //配送信息内容
                        if (ObjectUtil.isNotNull(obj.get(UocConstant.RESPONSE_PARAMS.CONTEXT))) {
                            StringBuilder sb = new StringBuilder(obj.get(UocConstant.RESPONSE_PARAMS.CONTEXT).toString());
                            if (ObjectUtil.isNotNull(obj.get(UocConstant.RESPONSE_PARAMS.LOCATION))) {
                                sb.append("当前地点：" + obj.get(UocConstant.RESPONSE_PARAMS.LOCATION).toString());
                            }
                            trackInfoBO.setContent(sb.toString());
                        }
                        orderTrackList.add(trackInfoBO);
                    }
                }
            }
        }
        rspBo.setOrderTrackList(orderTrackList);
        return rspBo;
    }

    /**
     * 封装入参
     *
     * @param reqBo
     * @return java.lang.String
     */
    private String initNonEsPostStr(UocQryLogisticsInfoServiceReqBo reqBo) {
        //入参对象
        JSONObject reqObj = new JSONObject();
        //param对象
        JSONObject param = new JSONObject();
        //必填信息
        //授权码
        reqObj.put(UocConstant.REQUEST_PARAMS.CUSTOMER, "customer");
        //签名
        reqObj.put(UocConstant.REQUEST_PARAMS.SIGN, "sign");
        //公司编码
        param.put(UocConstant.REQUEST_PARAMS.COM, "com");
        //单号
        param.put(UocConstant.REQUEST_PARAMS.NUM, reqBo.getOrderId());
        //行政区域解析
        param.put(UocConstant.REQUEST_PARAMS.RESULT_V2, 6);
        //条件筛选
        if (ObjectUtil.isNotNull(reqBo.getSearchConditions())) {
            UocQrderTrackSearchBO searchConditions = reqBo.getSearchConditions();
            //手机号
            param.put(UocConstant.REQUEST_PARAMS.PHONE, searchConditions.getPhoneNumber());
            //出发地
            param.put(UocConstant.REQUEST_PARAMS.FROM, searchConditions.getSource());
            //目的地
            param.put(UocConstant.REQUEST_PARAMS.TO, searchConditions.getTarget());
            //返回格式
            param.put(UocConstant.REQUEST_PARAMS.SHOW, searchConditions.getReturnFormat());
            //排序
            param.put(UocConstant.REQUEST_PARAMS.ORDER, searchConditions.getOrderBy());
        }
        //param
        reqObj.put(UocConstant.REQUEST_PARAMS.PARAM, param);
        return reqObj.toJSONString();
    }


    /**
     * ESB接口入参组装
     *
     * @param reqBo 入参对象BO
     * @return String
     */
    private String initEsPostStr(UocQryLogisticsInfoServiceReqBo reqBo) {
        String esbReqParam;
        // 根据供应商ID查找HSN
        String hsn = UocOrderPropertiesUtil.getProperty(UocThirdApiCommonConstant.SUPPLIER_ID + reqBo.getSupplierId());
        esbReqParam = ESBParamUtil.getEsbReqParam(reqBo, hsn, UocThirdApiCommonConstant.BUSINESS_ORDER);
        log.info("调用配送信息查询ESB接口请求报文：{}", esbReqParam);
        return esbReqParam;
    }


    /**
     * ESB返回数据解析
     *
     * @param returnString ESB接口返回数据
     * @return UocQryLogisticsInfoServiceRspBo
     */
    private UocQryLogisticsInfoServiceRspBo resolveEsRsp(String returnString, UocQryLogisticsInfoServiceRspBo rspBo) {
        log.info("调用配送信息查询ESB接口返回数据：{}", returnString);
        JSONObject jsonObject = JSONObject.parseObject(returnString);
        if (jsonObject.getBoolean(UocThirdApiCommonConstant.ESB_SUCCESS)) {
            if (UocRspConstants.RSP_CODE_SUCCESS.equals(jsonObject.get(UocThirdApiCommonConstant.ESB_RESULT_CODE))) {
                String jsonStr = JSONObject.toJSONString(jsonObject.get("result"));
                if (ObjectUtil.isNotEmpty(jsonStr)) {
                    JSONObject object = JSONObject.parseObject(jsonStr);
                    String orderTrack = JSONObject.toJSONString(object.get(UocConstant.RESPONSE_PARAMS.ORDER_TRACK));
                    String orderId = (String) JSONObject.parseObject(jsonStr).get(UocConstant.RESPONSE_PARAMS.ORDER_ID);
                    if (ObjectUtil.isNotEmpty(orderTrack)) {
                        List<OrderTrackInfoBO> orderTrackList = JSON.parseArray(orderTrack, OrderTrackInfoBO.class);
                        if (ObjectUtil.isNotEmpty(orderTrackList)) {
                            listSort(orderTrackList);
                            rspBo.setOrderTrackList(orderTrackList);
                        }

                    }
                    String waybillCode = object.getString(UocConstant.RESPONSE_PARAMS.WAY_BILL_CODE);
                    if (waybillCode != null) {
                        try {
                            JSONArray array = JSONArray.parseArray(waybillCode);
                            rspBo.setCarrier(array.getJSONObject(0).getString(UocConstant.RESPONSE_PARAMS.CARRIER));
                            rspBo.setDeliveryOrderId(array.getJSONObject(0).getString(UocConstant.RESPONSE_PARAMS.DELIVERY_ORDER_ID));
                        } catch (Exception e) {
                            try {
                                JSONObject code = JSONObject.parseObject(waybillCode);
                                rspBo.setCarrier(code.getString(UocConstant.RESPONSE_PARAMS.CARRIER));
                                rspBo.setDeliveryOrderId(code.getString(UocConstant.RESPONSE_PARAMS.DELIVERY_ORDER_ID));
                            } catch (Exception ignored) {
                                log.error("解析异常:{}", ignored.getMessage());
                            }
                        }
                    }
                    rspBo.setOrderId(orderId);
                }
            } else {
                rspBo.setRespCode(UocRspConstants.RSP_ERROR_CODE_CALL_THIRD_SERVICE);
                rspBo.setRespDesc("调用配送信息查询ESB接口失败" + jsonObject.get("resultMessage"));
            }
        }
        return rspBo;
    }

    /**
     * 按时间排序
     *
     * @param list 需要排序的入参
     */
    private void listSort(List<OrderTrackInfoBO> list) {
        Collections.sort(list, new Comparator<OrderTrackInfoBO>() {
            @Override
            public int compare(OrderTrackInfoBO o1, OrderTrackInfoBO o2) {
                try {
                    Date dt1 = DelFormatHelper.fromSdfToDate(o1.getMsgTime());
                    Date dt2 = DelFormatHelper.fromSdfToDate(o2.getMsgTime());
                    if (dt1.getTime() < dt2.getTime()) {
                        return 1;
                    } else if (dt1.getTime() > dt2.getTime()) {
                        return -1;
                    } else {
                        return 0;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
                return 0;
            }
        });
    }

    /**
     * 入参校验
     *
     * @param reqBo
     */
    private void validateParams(UocQryLogisticsInfoServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocQryLogisticsInfoServiceReqBo]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单编号]不能为空");
        }
        if (ObjectUtil.isNull(reqBo.getType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[类型]不能为空");
        } else {
            if (ObjectUtil.equal(reqBo.getType(), UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT)) {
                if (ObjectUtil.isNull(reqBo.getSupplierId())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商ID]不能为空");
                }
            }
        }
    }

}


