package com.tydic.dyc.oc.components.virgo;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.utils.SslClientUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * 标题:UocGetRuleVirgoUtil
 * 说明:访问规则引擎
 * 时间:2022/3/7 11:01
 * 作者:罗有
 */

@Component
@Slf4j
public class UocGetRuleVirgoUtil {
    @Value("${virgo.trigger.url:http://39.96.39.0:8089/virgo/api/trigger}")
    private String triggerUrl;
    @Value("${virgo.rule.get.url:http://39.96.39.0:8089/virgo/api/getRuleInfos}")
    private String ruleGetUrl;

    /**
     * 根据服务编码查询规则信息
     */
    public UocVirgoRuleQryByCodeRspBo getRuleInfos(UocVirgoRuleQryByCodeReqBo reqBo) {
        log.debug("查询规则信息入参:{}", JSON.toJSONString(reqBo));
        String result = SslClientUtil.doPost(ruleGetUrl, JSON.toJSONString(reqBo));
        log.debug("查询规则信息出参:{}", result);
        return UocRu.jss(result, UocVirgoRuleQryByCodeRspBo.class);
    }

    /**
     * 查询规则ID
     */
    public String getRuleId(String serviceCode) {
        UocVirgoRuleQryByCodeReqBo uocVirgoRuleQryByCodeReqBo = new UocVirgoRuleQryByCodeReqBo();
        uocVirgoRuleQryByCodeReqBo.setServiceCode(serviceCode);
        UocVirgoRuleQryByCodeRspBo uocVirgoRuleQryByCodeRspBo = getRuleInfos(uocVirgoRuleQryByCodeReqBo);
        if (!UocRspConstants.RSP_CODE_SUCCESS.equals(uocVirgoRuleQryByCodeRspBo.getRespCode())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_VIRGO_ERROR, "获取规则失败");
        }
        if (CollectionUtils.isEmpty(uocVirgoRuleQryByCodeRspBo.getRuleInfos())
                || ObjectUtil.isEmpty(uocVirgoRuleQryByCodeRspBo.getRuleInfos().get(0))
                || ObjectUtil.isEmpty(uocVirgoRuleQryByCodeRspBo.getRuleInfos().get(0).getRuleId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_VIRGO_ERROR, "获取规则为空");
        }
        return uocVirgoRuleQryByCodeRspBo.getRuleInfos().get(0).getRuleId();
    }

    /**
     * 触发规则
     */
    public UocVirgoTriggerRspBo trigger(UocVirgoTriggerReqBo reqBo) {
        log.debug("触发规则入参:{}", JSON.toJSONString(reqBo));
        String result = SslClientUtil.doPost(triggerUrl, JSON.toJSONString(reqBo));
        log.debug("触发规则出参:{}", result);
        return UocRu.jss(result, UocVirgoTriggerRspBo.class);
    }


}
