package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;

import java.util.List;

/**
 * 标题:UocAuditOrderRepository
 * 说明:
 * 时间:2022/3/10 17:27
 * 作者:田桂银
 */
public interface UocAuditOrderRepository {


    /**
     * 描述:保存审批数据
     * @param orderDo 入参
     * @return com.tydic.dyc.oc.model.audit.UocAuditOrderDo
     * @author tgy
     * @date 2022/3/10 17:23
     */
    UocAuditOrderDo saveAudit(UocAuditOrderDo orderDo);


    /**
     * 描述:更新审批单数据
     * @param updateDo 入参
     * @return com.tydic.dyc.oc.model.audit.UocAuditOrderDo
     * @author tgy
     * @date 2022/3/10 19:52
     */
    UocAuditOrderDo updateApprove(UocAuditOrderDo updateDo);

    /**
     * 描述: 查询
     * @param obj 入参
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocApprovalObj>
     * @author tgy
     * @date 2022/3/10 21:18
     */
    List<UocApprovalObj> qryApprovealObj(UocApprovalObj obj);

    /**
     * 描述: 查询审批单列表
     * @param qryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     * @author tgy
     * @date 2022/3/10 21:18
     */
    List<UocAuditOrder > qryAuditOrderList(UocAuditOrderQryBo qryBo);

}


