package com.tydic.dyc.oc.utils;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述：出参对象工具类
 *
 * @author tgy
 * @date 2021/3/5 16:37
 */
public class UocRu {
    /**
     * 描述: 转换应用层入参对象为中心层入参对象
     *
     * @param reqBo 应用层入参对象实例
     * @param clazz 中心层入参对象Class类型
     * @return T
     * @author tgy
     * @date 2021/3/31 15:21
     */
    public static <T> T js(Object reqBo, Class<T> clazz) {
        return JSON.parseObject(JSON.toJSONString(reqBo), clazz);
    }

    /**
     * 描述:list对象互转
     *
     * @return java.util.List<T>
     * @author tgy
     * @date 2022/2/22 16:26
     */
    public static <T> List<T> jsl(List<?> reqBo, Class<T> clazz) {
        return JSON.parseArray(JSON.toJSONString(reqBo), clazz);
    }

    /**
     * JSON字符串转对象
     *
     * @param jsonStr
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T jss(String jsonStr, Class<T> clazz) {
        return JSON.parseObject(jsonStr, clazz);
    }
    /**
     * 描述:list对象互转
     *
     * @return java.util.List<T>
     * @author tgy
     * @date 2022/2/22 16:26
     */
    public static <T> List<T> jsl(Object reqBo, Class<T> clazz) {
        return JSON.parseArray(JSON.toJSONString(reqBo), clazz);
    }



    /**
     * 描述:生成一个继承于UocProBaseRspBo的对象
     *
     * @param code   code
     * @param desc   描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:43
     */
    private static <T extends BaseRspBo> T generate(String code, String desc, Class<T> tClass) {
        try {
            T t = tClass.newInstance();
            t.setRespCode(code);
            t.setRespDesc(desc);
            return t;
        } catch (Exception e) {
            throw new IllegalArgumentException("UocProRspBoUtil创建rsp对象异常：" + e.getMessage());
        }
    }

    /**
     * 描述:生成一个继承于UocProBaseRspBo的失败对象
     *
     * @param code   code
     * @param desc   描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:43
     */
    public static <T extends BaseRspBo> T failed(String code, String desc, Class<T> tClass) {
        return generate(code, desc, tClass);
    }


    /**
     * 描述:生成默认描述的成功对象
     *
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:40
     */
    public static <T extends BaseRspBo> T success(Class<T> tClass) {
        return success(BaseRspConstant.RSP_DESC_SUCCESS, tClass);
    }


    /**
     * 描述:生成一个指定成功描述的对象
     *
     * @param desc   成功描述
     * @param tClass Class对象
     * @return T
     * @author tgy
     * @date 2021/3/5 16:42
     */
    public static <T extends BaseRspBo> T success(String desc, Class<T> tClass) {
        return generate(BaseRspConstant.RSP_CODE_SUCCESS, desc, tClass);
    }

    /**
     * object转List
     *
     * @param obj   被转换的对象
     * @param clazz 转换出参类型T
     * @return List
     */
    public static <T> List<T> castList(Object obj, Class<T> clazz) {
        List<T> result = new ArrayList<>();
        if (obj instanceof List<?>) {
            for (Object o : (List<?>) obj) {
                result.add(clazz.cast(o));
            }
        }
        return result;
    }


    /**
     * to Long
     *
     * @param o
     * @return Long
     */
    public static Long parseLong(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return Long.parseLong((String) o);
        }
        if (o instanceof Long) {
            return (Long) o;
        }
        if (o instanceof Integer) {
            return ((Integer) o).longValue();
        }
        return null;
    }


    /**
     * to Integer
     *
     * @param o
     * @return Long
     */
    public static Integer parseInteger(Object o) {
        if (null == o) {
            return null;
        }
        if (o instanceof String) {
            return Integer.parseInt((String) o);
        }
        if (o instanceof Long) {
            return ((Long) o).intValue();
        }
        if (o instanceof Integer) {
            return (Integer) o;
        }
        return null;
    }


    /**
     * to Str
     *
     * @param o
     * @return String
     */
    public static String parseStr(Object o) {
        if (null == o) {
            return null;
        }
        return o.toString();
    }
}


