package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateReqBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：UocOrderRelUpdateServiceImpl
 * 说明：订单关联更新API
 * 时间：2022/4/1 14:57
 *
 * @author 文乐
 */
@HTServiceImpl
public class UocOrderRelUpdateServiceImpl implements UocOrderRelUpdateService{

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocOrderRelUpdateRspBo dealRelUpdate(UocOrderRelUpdateReqBo reqBo) {
        // 参数校验
        validateArg(reqBo);
        // 查询是否已存在
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setObjId(reqBo.getObjId());
        uocOrderRelQryBo.setObjType(reqBo.getObjType());
        uocOrderRelQryBo.setOrderId(reqBo.getOrderId());
        uocOrderRelQryBo.setRelType(reqBo.getRelType());
        UocOrderRel qryRelInfo = iUocOrderModel.qryRelInfo(uocOrderRelQryBo);

        if ( null != qryRelInfo ) {
            // 更新
            UocOrderRel uocOrderRel = new UocOrderRel();
            uocOrderRel.setId(qryRelInfo.getId());
            uocOrderRel.setRelStatus(reqBo.getRelState());
            if ( null != reqBo.getRelId() ) {
                uocOrderRel.setRelId(reqBo.getRelId());
            }
            iUocOrderModel.dealRelUpdate(uocOrderRel);
        } else {
            // 创建
            UocOrderRel uocOrderRel = UocRu.js(reqBo, UocOrderRel.class);
            uocOrderRel.setId(IdUtil.nextId());
            iUocOrderModel.createRelInfo(uocOrderRel);
        }

        return UocRu.success(UocOrderRelUpdateRspBo.class);
    }

    private void validateArg(UocOrderRelUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能不为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "orderId不能为空");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "ObjId不能为空");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "ObjType不能为空");
        }
        if (null == reqBo.getRelState()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "relState不能为空");
        }
        if (null == reqBo.getRelType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "relType不能为空");
        }
    }

}
