package com.tydic.dyc.oc.service.order;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.service.order.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;


/**
 * 标题:UocQryOrderTaskInstanceListServiceImpl
 * 说明:
 * 时间:2022/2/25 10:29
 * 作者:田坤林
 */
@HTServiceImpl
public class UocQryOrderTaskInstanceListServiceImpl implements UocQryOrderTaskInstanceListService {

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocQryOrderTaskInstanceListServiceRspBo qryOrderTaskInstanceList(UocQryOrderTaskInstanceListServiceReqBo reqBo) {
        validateParam(reqBo);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(UocRu.js(reqBo, UocOrderTaskInstQryBo.class));
        UocQryOrderTaskInstanceListServiceRspBo rspBo = UocRu.success(UocQryOrderTaskInstanceListServiceRspBo.class);
        rspBo.setDataList(ObjectUtil.isNotEmpty(uocOrderTaskInsts) ? UocRu.jsl(uocOrderTaskInsts, UocQryOrderTaskInstanceListServiceRspDataBo.class) : new ArrayList<>());
        return rspBo;
    }

    private void validateParam(UocQryOrderTaskInstanceListServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
    }
}


