package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;

import java.util.List;

/**
 * 标题:UocOrderRepository
 * 说明:订单
 * 时间:2022-02-21 13:53
 * 作者:罗有
 **/
public interface UocOrderRepository {

    /**
     * 描述:创建销售单
     * @param orderDo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/24 20:29
     */
    UocOrderDo saveUocOrder(UocOrderDo orderDo);

    /**
     * 描述:保存附件
     * @param uocOrderAccessoryList 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/22 15:10
     */
    UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList);

    /**
     * 描述:创建订单变更记录
     * @param uocOrderStateChgLog 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog
     * @author tkl
     * @date 2022/3/2 13:49
     */
    UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog);

    List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo);

    /**
     * 描述:查询订单任务实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst
     * @author tgy
     * @date 2022/2/24 20:29
     */
    List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo);

    /**
     * 描述:查询订单任务处理实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal
     * @author tgy
     * @date 2022/2/24 19:39
     */
    List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo);

    /**
     * 描述:查询订单流程实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/2/24 20:29
     */
    List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo);

    /**
     * 描述:查询单订单信息
     * @param uocOrderDo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/27 15:13
     */
    UocOrderDo qryOrderBy(UocOrderDo uocOrderDo);

    /**
     * 描述:查询订单明细信息
     * @param uocOrderItemQryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderItem></>
     * @author tgy
     * @date 2022/2/27 15:57
     */
    List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo);

    /**
     * 描述:查询收获地址信息
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela
     * @author tgy
     * @date 2022/2/27 15:57
     */
    UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo);

    /**
     * 描述:查询发票信息
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrdInvoice
     * @author tgy
     * @date 2022/2/27 15:57
     */
    UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo);

    /**
     * 描述:查询订单附件
     *
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderAccessory
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo);

    /**
     * 查询订单扩展
     *
     * @param qryBo
     * @return
     */
    List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo);

    /**
     * 更新订单结算关联信息
     * @author wenle
     * @date 2022-04-01 15:19:50
     * @param qryBo 入参
     */
    void dealRelUpdate(UocOrderRel qryBo);

    /**
     * 查询关联详情
     * @author wenle
     * @date 2022-04-01 16:36:42
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderRel
     */
    UocOrderRel qryRelInfo(UocOrderRelQryBo qryBo);

    /**
     * 查询外部系统单号关联信息
     * @author tkl
     * @date 2022-04-01 16:31:18
     * @param qryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex></>
     */
    List<UocOrderQueryIndex> qryOrderQueryIndexList(UocOrderQueryIndexQryBo qryBo);

    /**
     * 创建关联对象
     * @author wenle 
     * @date 2022-04-01 16:52:10 
     * @param uocOrderRel 入参
     */
    void createRelInfo(UocOrderRel uocOrderRel);

    /**
     * 查询对账状态
     * @author wenle
     * @date 2022-04-01 19:51:42
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount
     */
    UocOrderCheckAccount qryCheckInfo(UocOrderCheckAccountQryBo qryBo);

    /**
     * 创建对账状态
     * @author wenle
     * @date 2022-04-01 19:59:55
     * @param uocOrderCheckAccount 入参
     */
    void createCheckInfo(UocOrderCheckAccount uocOrderCheckAccount);

    /**
     * 更新对账状态
     * @author wenle
     * @date 2022-04-01 20:00:20
     * @param uocOrderCheckAccount 入参
     */
    void updateCheckInfo(UocOrderCheckAccount uocOrderCheckAccount);
}
