package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAdjustPriceOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocAdjustPriceOrderCreateServiceImpl
 * 说明:TODO
 * 时间:2022/4/6 15:54
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocAdjustPriceOrderCreateServiceImpl implements UocAdjustPriceOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Override
    public UocAdjustPriceOrderCreateRspBo createAdjustPriceOrder(UocAdjustPriceOrderCreateReqBo reqBo) {
        // 入参校验
        validateArg(reqBo);
        // 创建变更单
        UocChngOrderDo uocChngOrderDo = convertChngOrderDo(reqBo,new Date());
        iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        UocAdjustPriceOrderCreateRspBo uocAdjustPriceOrderCreateRspBo = UocRu.success(UocAdjustPriceOrderCreateRspBo.class);
        uocAdjustPriceOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        return uocAdjustPriceOrderCreateRspBo;
    }
    /**
     * 参数转换
     */
    private UocChngOrderDo convertChngOrderDo(UocAdjustPriceOrderCreateReqBo reqBo,Date newDate) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_RESP_GET_OBJ_NO_ERROR, "查询销售单为空");
        }
        // 设置变更单信息
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderNo(getChngOrderNo(uocSaleOrderDo));
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(newDate);
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        // 设置变更对象信息
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
        uocChngOrderObj.setCreateTime(newDate);
        uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderObjList.add(uocChngOrderObj);
        // 设置变更对象明细
        List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
        reqBo.getSaleItemList().forEach(itemBo -> {
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setSaleOrderItemId(itemBo.getSaleOrderItemId());
            uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
            uocChngOrderItemObj.setChngFee(itemBo.getAdjustPrice());
            uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
            uocChngOrderItemObj.setCreateTime(newDate);
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        // 设置附件信息
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(newDate);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);

            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        // 设置扩展信息
        if(!CollectionUtils.isEmpty(reqBo.getExtParallelBoList())){
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setId(IdUtil.nextId());
                uocChngOrderMap.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setCreateTime(newDate);
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        return uocChngOrderDo;
    }
    /**
     * 获取变更审批单编号
     */
    private String getChngOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }
    /**
     * 入参校验
     */
    private void validateArg(UocAdjustPriceOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if(CollectionUtils.isEmpty(reqBo.getSaleItemList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参调价信息为空");
        }
        reqBo.getSaleItemList().forEach(uocAdjustPriceOrderCreateReqItemBo -> {
            if(uocAdjustPriceOrderCreateReqItemBo.getSaleOrderItemId()==null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售明细ID为空");
            }
            if(uocAdjustPriceOrderCreateReqItemBo.getAdjustPrice()==null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参调价后金额为空");
            }
        });
    }
}
