package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocEsSyncAf
 * 说明:售后单
 * 时间:2022/3/1 14:08
 * 作者:tkl
 */
@Slf4j
@Component
public class UocEsSyncAf implements IUocEsSync {

    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return uocIndexConfig.getAfOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        //查询售后单主体
        UocAfOrder afOrderMain = getAfOrderMain(reqBo);
        if (ObjectUtil.isNull(afOrderMain)) {
            return rspBo;
        }
        //查询售后单扩展
        List<UocAfOrderMap> afOrderMapList = getAfOrderMapList(reqBo);
        //查询售后单对象
        List<UocAfOrderObj> afOrderObjList = getAfOrderObjList(reqBo);
        //查询售后单明细
        List<UocAfOrderItem> afOrderItemList = getAfOrderItemList(reqBo);
        //查询售后单明细扩展
        List<UocAfItemMap> afOrderItemMapList = getAfOrderItemMapList(reqBo);
        ConcurrentMap<Long, List<UocAfItemMap>> afItemMap = new ConcurrentHashMap<>();
        if (ObjectUtil.isNotEmpty(afOrderItemMapList)) {
            afItemMap = afOrderItemMapList.stream().collect(Collectors.groupingByConcurrent(UocAfItemMap::getAfOrderItemId));
        }
        //查询附件
        List<UocOrderAccessory> orderAccessoryList = getOrderAccessoryList(reqBo);

        //封装出参信息
        //售后单主体
        UocAfOrderDo uocAfOderDo = UocRu.js(afOrderMain, UocAfOrderDo.class);
        //主体翻译
        translateAfMain(uocAfOderDo);
        //售后单对象
        uocAfOderDo.setAfOrderObjList(afOrderObjList);
        //附件
        uocAfOderDo.setOrderAccessoryBoList(orderAccessoryList);
        //销售单主体
        UocSaleOrderDo saleOrderDo = getSaleOrderDo(uocAfOderDo);
        //销售单明细
        Map<Long, UocSaleOrderItem> saleItemMap = getSaleItem(uocAfOderDo);
        //发货单主体
        List<UocShipOrderDo> shipOrderDos = getShipOrderDo(uocAfOderDo);

        JSONObject afOrderObj = JSON.parseObject(JSON.toJSONString(uocAfOderDo));
        putShipOrderInfo(shipOrderDos, afOrderObj);
        putSaleOrderInfo(saleOrderDo, afOrderObj);

        //售后单扩展
        if (ObjectUtil.isNotEmpty(afOrderMapList)) {
            afOrderMapList.forEach(each -> afOrderObj.put(each.getFieldCode(), each.getFieldValue()));
        }
        //售后单明细
        JSONArray afItemArray = new JSONArray();
        if (ObjectUtil.isNotEmpty(afOrderItemList)) {
            //售后数量拉横
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.RETURN_COUNT, afOrderItemList.get(0).getReturnCount());
            for (UocAfOrderItem item : afOrderItemList) {
                translateAfItem(item);
                JSONObject afItemObj = JSON.parseObject(JSON.toJSONString(item));
                if (ObjectUtil.isNotEmpty(afItemMap) && afItemMap.containsKey(item.getAfOrderItemId())) {
                    //售后单明细扩展
                    afItemMap.get(item.getAfOrderItemId()).forEach(each -> afItemObj.put(each.getFieldCode(), each.getFieldValue()));
                }
                //销售单明细信息
                if (ObjectUtil.isNotEmpty(saleItemMap) && saleItemMap.containsKey(item.getOrderItemId())) {
                    putSaleItemInfo(afItemObj, saleItemMap.get(item.getOrderItemId()));
                }
                afItemArray.add(afItemObj);
            }
        }
        afOrderObj.put(UocConstant.ES_MAIN_OTHER.UOC_AF_ORDER_ITEM, afItemArray);

        rspBo.setJsonObj(afOrderObj);
        log.info("售后单ES数据：{}", afOrderObj.toJSONString());
        return rspBo;
    }

    private void putShipOrderInfo(List<UocShipOrderDo> shipOrderDos, JSONObject afOrderObj) {
        if (ObjectUtil.isNotEmpty(shipOrderDos)) {
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO, shipOrderDos.get(0).getShipOrderNo());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_STATE_STR, getDic().get(UocStateConstants.ShipOrder.P_CODE).get(shipOrderDos.get(0).getShipOrderState()));
        }
    }

    /**
     * 售后单主体信息拉横
     *
     * @param saleOrderDo
     * @param afOrderObj
     */
    private void putSaleOrderInfo(UocSaleOrderDo saleOrderDo, JSONObject afOrderObj) {
        if (ObjectUtil.isNotNull(saleOrderDo)) {
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.ORD_SOURCE, saleOrderDo.getOrderSource().toString());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.CREATE_OPER_NAME, saleOrderDo.getCreateOperName());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.CREATE_TIME, saleOrderDo.getCreateTime());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_NO, saleOrderDo.getSaleOrderNo());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE, saleOrderDo.getSaleOrderState());
            afOrderObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR, getDic().get(UocDicConstant.SALE_ORD_STATE.P_CODE).get(saleOrderDo.getSaleOrderState()));
            if (ObjectUtil.isNotNull(saleOrderDo.getStakeholder())) {
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.SUP_ID, saleOrderDo.getStakeholder().getSupId());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, saleOrderDo.getStakeholder().getPurOrgId());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.SUP_NO, saleOrderDo.getStakeholder().getSupNo());
                afOrderObj.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, saleOrderDo.getStakeholder().getSupName());
            }
        }
    }

    /**
     * 售后单明细翻译
     *
     * @param item
     */
    private void translateAfItem(UocAfOrderItem item) {
        Map<String, Map<String, String>> dicMap = getDic();
        if (ObjectUtil.isNotNull(item.getIshaspackage())) {
            //是否有包装
            item.setIshaspackageStr(dicMap.get(UocDicConstant.IS_HAS_PACKAGE.P_CODE).get(item.getIshaspackage().toString()));
        }
        if (ObjectUtil.isNotNull(item.getPackageDesc())) {
            //包装描述
            item.setPackageDescStr(dicMap.get(UocDicConstant.PACKAGE_DECRIP.P_CODE).get(item.getPackageDesc().toString()));
        }
    }

    /**
     * 售后单主体翻译
     *
     * @param uocAfOderDo
     */
    private void translateAfMain(UocAfOrderDo uocAfOderDo) {
        Map<String, Map<String, String>> dicMap = getDic();
        if (ObjectUtil.isNotEmpty(dicMap)) {
            if (ObjectUtil.isNotNull(uocAfOderDo.getServType())) {
                //服务类型
                uocAfOderDo.setServTypeStr(dicMap.get(UocDicConstant.SERVICE_TYPE.P_CODE).get(uocAfOderDo.getServType().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getServState())) {
                //服务单状态
                uocAfOderDo.setServStateStr(dicMap.get(UocDicConstant.SERVICE_STATE.P_CODE).get(uocAfOderDo.getServState().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getIsCancel())) {
                //是否可取消
                uocAfOderDo.setIsCancelStr(dicMap.get(UocDicConstant.IS_CANCEL.P_CODE).get(uocAfOderDo.getIsCancel().toString()));
            }
            //支付方式
            uocAfOderDo.setPayTypeStr(dicMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(uocAfOderDo.getPayType()));
            if (ObjectUtil.isNotNull(uocAfOderDo.getPayState())) {
                //支付状态
                uocAfOderDo.setPayStateStr(dicMap.get(UocDicConstant.PAY_STATE.P_CODE).get(uocAfOderDo.getPayState().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getPickwareType())) {
                //取货服务类型
                uocAfOderDo.setPickwareTypeStr(dicMap.get(UocDicConstant.PICKWARE_SERVE_TYPE.P_CODE).get(uocAfOderDo.getPickwareType().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getCancelFlag())) {
                //撤单标志
                uocAfOderDo.setCancelFlagStr(dicMap.get(UocDicConstant.CANCEL_FLAG.P_CODE).get(uocAfOderDo.getCancelFlag().toString()));
            }
            if (ObjectUtil.isNotNull(uocAfOderDo.getCancelType())) {
                //取消类型
                uocAfOderDo.setCancelTypeStr(dicMap.get(UocDicConstant.CANCEL_TYPE.P_CODE).get(uocAfOderDo.getCancelType().toString()));
            }
            //供应商售后服务环节编码
            uocAfOderDo.setServiceStepStr(dicMap.get(UocDicConstant.SERVICE_STEP.P_CODE).get(uocAfOderDo.getServiceStep()));
        }
    }

    /**
     * 查询订单附件
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderAccessory></>
     */
    private List<UocOrderAccessory> getOrderAccessoryList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(reqBo.getObjId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
        uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
        return iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
    }

    /**
     * 查询发货单主体
     *
     * @param uocAfOrderDo
     * @return com.tydic.dyc.oc.model.shiporder.UocShipOrderDo
     */
    private List<UocShipOrderDo> getShipOrderDo(UocAfOrderDo uocAfOrderDo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(uocAfOrderDo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(uocAfOrderDo.getSaleOrderId());
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    /**
     * 查询发货单明细列表
     *
     * @param reqBo
     * @return
     */
    private List<UocShipOrderItem> getListShipOrderItem(UocSaleOrderItem reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderItemQryBo.setSaleOrderItemId(reqBo.getSaleOrderItemId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        return ObjectUtil.isNotNull(uocShipOrderDo) ? uocShipOrderDo.getShipOrderItemBoList() : new ArrayList<>();
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        pCodes.add(UocDicConstant.SERVICE_STATE.P_CODE);
        pCodes.add(UocDicConstant.IS_CANCEL.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PAY_STATE.P_CODE);
        pCodes.add(UocDicConstant.CANCEL_FLAG.P_CODE);
        pCodes.add(UocDicConstant.CANCEL_TYPE.P_CODE);
        pCodes.add(UocDicConstant.PICKWARE_SERVE_TYPE.P_CODE);
        pCodes.add(UocDicConstant.SERVICE_STEP.P_CODE);
        pCodes.add(UocDicConstant.IS_HAS_PACKAGE.P_CODE);
        pCodes.add(UocDicConstant.PACKAGE_DECRIP.P_CODE);
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    /**
     * 封装销售单明细信息
     */
    private void putSaleItemInfo(JSONObject afItemObj, UocSaleOrderItem uocSaleOrderItem) {
        afItemObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_ID, uocSaleOrderItem.getCommodityId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.COMMODITY_NAME, uocSaleOrderItem.getCommodityName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_NAME, uocSaleOrderItem.getSkuName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_ID, uocSaleOrderItem.getSkuId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_EXT_SKU_ID, uocSaleOrderItem.getSkuExtSkuId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_ID, uocSaleOrderItem.getSkuMaterialId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MAIN_PIC_URL, uocSaleOrderItem.getSkuMainPicUrl());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_NAME, uocSaleOrderItem.getSkuMaterialName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_ID, uocSaleOrderItem.getSkuMaterialTypeId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_NAME, uocSaleOrderItem.getSkuMaterialTypeName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.UNIT_NAME, uocSaleOrderItem.getUnitName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.MODEL, uocSaleOrderItem.getModel());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SPEC, uocSaleOrderItem.getSpec());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.TAX, uocSaleOrderItem.getTax());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.TAX_ID, uocSaleOrderItem.getTaxId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.TAX_PRICE, uocSaleOrderItem.getTaxPrice());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_BRAND_ID, uocSaleOrderItem.getSkuBrandId());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SKU_BRAND_NAME, uocSaleOrderItem.getSkuBrandName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG, uocSaleOrderItem.getL1Catalog());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG_NAME, uocSaleOrderItem.getL1CatalogName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG, uocSaleOrderItem.getL2Catalog());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG_NAME, uocSaleOrderItem.getL2CatalogName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG, uocSaleOrderItem.getL3Catalog());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG_NAME, uocSaleOrderItem.getL3CatalogName());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.SALE_PRICE, uocSaleOrderItem.getSalePrice());
        //发货单明细
        List<UocShipOrderItem> shipOrderItemList = getListShipOrderItem(uocSaleOrderItem);
        if (ObjectUtil.isNotEmpty(shipOrderItemList)) {
            afItemObj.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, uocSaleOrderItem.getSalePrice().multiply(shipOrderItemList.get(0).getSendCount()));
            afItemObj.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, uocSaleOrderItem.getPurchasePrice().multiply(shipOrderItemList.get(0).getSendCount()));
        }
        afItemObj.put(UocConstant.ES_MAIN_OTHER.PUR_PRICE, uocSaleOrderItem.getPurchasePrice());
        afItemObj.put(UocConstant.ES_MAIN_OTHER.PUR_COUNT, uocSaleOrderItem.getPurchaseCount());
    }

    /**
     * 查询销售单明细
     *
     * @param uocAfOderDo
     * @return java.util.Map<java.lang.Long, com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem></>
     */
    private Map<Long, UocSaleOrderItem> getSaleItem(UocAfOrderDo uocAfOderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocAfOderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocAfOderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getOrderItemId, o -> o, (k1, k2) -> k2));
        }
        return new HashMap<>();
    }

    /**
     * 查询销售单主体
     *
     * @param uocAfOderDo
     * @return com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo
     */
    private UocSaleOrderDo getSaleOrderDo(UocAfOrderDo uocAfOderDo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(uocAfOderDo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(uocAfOderDo.getOrderId());
        List<UocSaleOrderDo> uocSaleOrderDos = iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
        return ObjectUtil.isNotEmpty(uocSaleOrderDos) ? uocSaleOrderDos.get(0) : new UocSaleOrderDo();
    }

    /**
     * 查询售后单扩展
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj></>
     */
    private List<UocAfOrderObj> getAfOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderObjQryBo uocAfOrderObjQryBo = new UocAfOrderObjQryBo();
        uocAfOrderObjQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderObjQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    /**
     * 查询售后单明细
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem></>
     */
    private List<UocAfOrderItem> getAfOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderItemQryBo uocAfOrderItemQryBo = new UocAfOrderItemQryBo();
        uocAfOrderItemQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    /**
     * 查询售后单明细扩展
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfItemMap></>
     */
    private List<UocAfItemMap> getAfOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfItemMapQryBo uocAfItemMapQryBo = new UocAfItemMapQryBo();
        uocAfItemMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfItemMapQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    /**
     * 查询售后单扩展
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap></>
     */
    private List<UocAfOrderMap> getAfOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderMapQryBo uocAfOrderMapQryBo = new UocAfOrderMapQryBo();
        uocAfOrderMapQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderMapQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    /**
     * 查询售后单主体
     *
     * @param reqBo
     * @return com.tydic.dyc.oc.model.aforder.sub.UocAfOrder
     */
    private UocAfOrder getAfOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getObjId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }
}
