package com.tydic.dyc.oc.config.mq.consumer;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.datasync.event.bo.ChannelEvent;
import com.tydic.dyc.base.events.Event;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.components.event.EventConsumer;
import com.tydic.dyc.oc.components.event.EventConsumerManger;
import com.tydic.dyc.oc.components.event.IUocEsSyncQryEventReqBo;
import com.tydic.dyc.oc.constants.UocRspConstants;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;

/**
 * 描述：专区下单消息处理
 *
 * @author liao xing jun
 * @date 2019/11/11
 **/

@Slf4j
public class UocSaleOrderSyncConsumer extends DefaultProxyMessageConfig implements ProxyMessageConsumer {
    private Logger logger = LoggerFactory.getLogger(UocSaleOrderSyncConsumer.class);

    @Autowired
    private UocEsSyncManager SyncManager;

    @Autowired
    private EventConsumerManger eventConsumerManger;

    @Override
    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("es消费者收到，数据内容如下");
        log.info(content);
        try {
            if (ObjectUtil.isNotEmpty(content)) {
                ChannelEvent eventList = JSON.parseObject(content, ChannelEvent.class);
                List<Event> events = eventList.getTraceEventList();
                if (ObjectUtil.isNotEmpty(events)) {
                    for (Event event : events) {
                        String eventCode = event.getCode();
                        Map<String, Object> paramMap = event.getParamMap();

                        EventConsumer eventConsumer = eventConsumerManger.getEventConsumer(eventCode);
                        List<IUocEsSyncQryEventReqBo> eventReqBos = eventConsumer.parseMap(paramMap);
                        validateArg(eventReqBos);
                        if (ObjectUtil.isNotEmpty(eventReqBos)) {
                            for (IUocEsSyncQryEventReqBo eventReqBo : eventReqBos) {
                                String indexName = eventReqBo.getIndexName();
                                List<IUocEsSyncQryReqBo> dataList = eventReqBo.getDataList();
                                for (IUocEsSyncQryReqBo syncQryReqBo : dataList) {
                                    if (syncQryReqBo.getDelFlag()) {
                                        UocEsSyncManagerSaveDataReqBo saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                                        saveDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                                        saveDataReqBo.setObjId(syncQryReqBo.getObjId());
                                        saveDataReqBo.setIndexName(indexName);
                                        log.info("同步数据删除参数入参:" + JSON.toJSONString(saveDataReqBo));
                                        SyncManager.deleteData(saveDataReqBo);
                                    }
                                }
                                for (IUocEsSyncQryReqBo syncQryReqBo : dataList) {
                                    if (!syncQryReqBo.getDelFlag()) {
                                        UocEsSyncManagerSaveDataReqBo saveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
                                        saveDataReqBo.setOrderId(syncQryReqBo.getOrderId());
                                        saveDataReqBo.setObjId(syncQryReqBo.getObjId());
                                        saveDataReqBo.setIndexName(indexName);
                                        log.info("同步数据保存参数入参:" + JSON.toJSONString(saveDataReqBo));
                                        SyncManager.saveData(saveDataReqBo);
                                    }
                                }
                            }
                        }

                    }
                }
            }
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        } catch (Exception e) {
            log.error("数据同步消费者异常：" + e.getMessage(), e);
//            e.printStackTrace();
//            return ProxyConsumerStatus.CONSUME_SUCCESS;
            return ProxyConsumerStatus.RECONSUME_LATER;
        }

    }

    private void validateArg(List<IUocEsSyncQryEventReqBo> reqBo) {
        if (ObjectUtil.isNotEmpty(reqBo)) {
            if (reqBo == null) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "事件数据解析返回数据不能为空");
            }
        }

        for (IUocEsSyncQryEventReqBo eventReqBo : reqBo) {
            validateEventRsp(eventReqBo);
        }


    }

    private void validateEventRsp(IUocEsSyncQryEventReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[IUocEsSyncQryEventReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getIndexName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[索引名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getDataList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[数据列表]不能为空");
        }

        for (IUocEsSyncQryReqBo syncQryReqBo : reqBo.getDataList()) {
            validateSync(syncQryReqBo);
        }

    }

    private void validateSync(IUocEsSyncQryReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[IUocEsSyncQryReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单编号]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getObjId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[对象id]不能为空");
        }
    }
}
