package com.tydic.dyc.oc.model.aforder;

import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;

import java.util.List;

/**
 * 标题:IUocAfOrderModel
 * 说明:售后单
 * 时间:2022/2/23 14:01
 * 作者:罗有
 */

public interface IUocAfOrderModel {

    /**
     * 查询售后单明细
     *
     * @param uocAfOrderItemQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem></>
     */
    List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo);

    /**
     * 根据售后单ID查询售后单信息
     *
     * @param uocAfOrderQryBo
     * @return @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrder></>
     */
    UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo);

    /**
     * 售后单列表查询
     *
     * @param uocAfOrderQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrder></>
     */
    List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo);

    /**
     * 售后单对象列表查询
     *
     * @param uocAfOrderObjQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderObj></>
     */
    List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo);

    /**
     * 售后单扩展查询
     *
     * @param uocAfOrderMapQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderMap></>
     */
    List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo);

    /**
     * 售后单明细扩展查询
     *
     * @param uocAfItemMapQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfItemMap></>
     */
    List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo);

    /**
     * 售后运单信息查询
     *
     * @param uocAfOrderWaybillQryBo
     * @return java.util.List<com.tydic.dyc.oc.model.aforder.sub.UocAfOrderWaybill></>
     */
    List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo);

    /***
     * 创建售后服务申请
     * @param afOrderDo
     * @return
     */
    UocAfOrderDo dealPebTheZoneAfterApplication(UocAfOrderDo afOrderDo);



    /**
     * 获取售后服务单编码
     *
     * @param afOrderDo
     * @return
     */
    UocAfOrderDo getAfterOrderNo(UocAfOrderDo afOrderDo);

}
