package com.tydic.dyc.oc.model.audit;

import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocApproveDo
 * 说明:
 * 时间:2022/3/10 17:17
 * 作者:田桂银
 */
@Data
public class UocAuditOrderDo implements Serializable {

    private static final long serialVersionUID = 6728238596960592469L;

    @DocField(value = "审批单id")
    private Long auditOrderId;

    @DocField(value = "订单ID")
    private Long orderId;

    @DocField(value = "审批单状态")
    private String auditOrderStatus;

    @DocField(value = "业务编码")
    private String busiCode;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "创建人名称")
    private String createOperName;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "撤单时间")
    private Date cancelTime;

    @DocField(value = "撤单工号")
    private String cancelOperId;

    @DocField(value = "撤单原因")
    private String cancelReason;

    @DocField(value = "撤单标志:1 已撤单 0 未撤单")
    private Integer cancelFlag;

    @DocField(value = "竣工时间")
    private Date finishTime;

	@DocField(value = "最终审批结果 1通过 0驳回")
	private Integer finalResult;

	@DocField(value = "逾期时间")
	private Date expTime;

	@DocField("审批对象")
	private List<UocApprovalObj> approvalObjs;

	@DocField("审批日志")
	private UocApprovalLog approvalLog;

}


