package com.tydic.dyc.oc.model.shouldpayorder.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.shouldpayorder.IUocOrderShouldPayModel;
import com.tydic.dyc.oc.model.shouldpayorder.UocOrderShouldPayDo;
import com.tydic.dyc.oc.repository.UocOrderShouldPayRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题：UocOrderShouldPayModelImpl
 * 说明：订单应付单
 * 时间：2022/4/2 14:07
 * 作者： 周中贤
 */
@Service
public class UocOrderShouldPayModelImpl implements IUocOrderShouldPayModel {

    @Autowired
    private UocOrderShouldPayRepository uocOrderShouldPayRepository;

    /**
     * 根据条件获取一条应付单数据
     *
     * @param uocOrderShouldPayDo 查询条件
     * @return 一条应付单数据
     */
    @Override
    public UocOrderShouldPayDo getOrderShouldPay(UocOrderShouldPayDo uocOrderShouldPayDo) {
        if (null == uocOrderShouldPayDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocOrderShouldPayRepository.getOrderShouldPay(uocOrderShouldPayDo);
    }

    /**
     * 查询多条应付单数据
     *
     * @param uocOrderShouldPayDo 查询条件
     * @return 多条应付单数据
     */
    @Override
    public List<UocOrderShouldPayDo> getListOrderShouldPay(UocOrderShouldPayDo uocOrderShouldPayDo) {
        if (null == uocOrderShouldPayDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocOrderShouldPayRepository.getListOrderShouldPay(uocOrderShouldPayDo);
    }

    /**
     * 订单应付单主体数据更新
     *
     * @param set
     * @param where
     */
    @Override
    public void modifyOrderShouldPayMain(UocOrderShouldPayDo set, UocOrderShouldPayDo where) {
        if (set == null || where == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        uocOrderShouldPayRepository.modifyOrderShouldPayMain(set, where);
    }
}
