package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.payorder.UocPayOrderDo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderItemObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderMapQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderObjQryBo;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderItemObj;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderMap;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrderObj;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;

import java.util.List;

/**
 * 标题:UocPayOrderRepository
 * 说明:支付单
 * 时间:2022-02-21 14:35
 * 作者:罗有
 **/
public interface UocPayOrderRepository {

    /**
     * 查询支付单主体
     *
     * @param uocPayOrderQryBo
     * @return
     */
    UocPayOrder getPayOrderMain(UocPayOrderQryBo uocPayOrderQryBo);

    /**
     * 查询支付单列表
     *
     * @param uocPayOrderQryBo
     * @return
     */
    List<UocPayOrder> getListPayOrder(UocPayOrderQryBo uocPayOrderQryBo);

    /**
     * 查询支付单对象列表
     *
     * @param uocPayOrderObjQryBo
     * @return
     */
    List<UocPayOrderObj> getListPayOrderObj(UocPayOrderObjQryBo uocPayOrderObjQryBo);

    /**
     * 查询支付单明细对象列表
     *
     * @param uocPayOrderItemObjQryBo
     * @return
     */
    List<UocPayOrderItemObj> getListPayOrderItemObj(UocPayOrderItemObjQryBo uocPayOrderItemObjQryBo);

    /**
     * 查询支付单扩展列表
     *
     * @param uocPayOrderMapQryBo
     * @return
     */
    List<UocPayOrderMap> getListPayOrderMap(UocPayOrderMapQryBo uocPayOrderMapQryBo);

    /**
     * 支付单主体数据更新
     * @param set
     * @param where
     */
    void modifyPayOrderMain(UocPayOrderQryBo set,UocPayOrderQryBo where);
}
