package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.conforder.qrybo.UocConfTabOrdStateQryBo;
import com.tydic.dyc.oc.model.conforder.sub.UocConfTabOrdState;
import com.tydic.dyc.oc.model.order.sub.*;

import java.util.List;

/**
 * 标题:UocCommonRepository
 * 说明:通用
 * 时间:2022/2/25 19:36
 * 作者:罗有
 */

public interface UocCommonRepository {
    /**
     * 添加附件
     *
     * @param uocOrderAccessoryList
     */
    void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList);

    /**
     * 描述:置为已办
     * @param uocOrderTaskInstList 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst
     * @author tgy
     * @date 2022/2/27 9:30
     */
    void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList);

    /**
     * 描述:保存销售单任务实例
     * @param saveTaskList 入参
     * @return void
     * @author tgy
     * @date 2022/2/27 12:45
     */
    void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList);

    /**
     * 描述:保存流程实例数据
     * @param inst 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/2/27 21:33
     */
    UocOrderProcInst createProInst(UocOrderProcInst inst);

    /**
     * 描述:查询流程实例列表
     * @param inst 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderProcInst>
     * @author tgy
     * @date 2022/2/27 21:37
     */
    List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst);


    /**
     * 描述:保存任务处理对象数据
     * @param dealList 入参
     * @return void
     * @author tgy
     * @date 2022/3/1 18:24
     */
    void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList);

    /**
     * 描述:创建状态变更日志
     * @param uocOrderStateChgLog 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog
     * @author tgy
     * @date 2022/3/3 17:40
     */
    UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog);


    /**
     * 描述:任务列表查询
     * @param taskInst 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst>
     * @author tgy
     * @date 2022/3/9 13:23
     */
    List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst);


    /**
     * 描述:更新流程实例数据
     * @param inst 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/3/10 19:39
     */
    UocOrderProcInst updateProInst(UocOrderProcInst inst);

    /**
     * 描述:保存业务操作数据
     * @param recordList 入参
     * @return void
     * @author tgy
     * @date 2022/3/10 20:16
     */
    void saveOperRecord(List<UocOrderBusiOperRecord> recordList);

    /**
     * 描述:查询页面订单状态映射规则配置
     *
     * @param qryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.conforder.sub.UocConfTabOrdState>
     */
    List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo);

    String getOrderNoSingle(String code);

    void updateTaskInst(UocOrderTaskInst inst);
}
