package com.tydic.dyc.oc.repository;

import com.tydic.dyc.oc.model.shouldpayorder.UocOrderShouldPayDo;

import java.util.List;

/**
 * 标题：UocOrderShouldPayRepository
 * 说明：订单应付单
 * 时间：2022/4/2 10:06
 * 作者： 周中贤
 */
public interface UocOrderShouldPayRepository {

    /**
     * 根据条件获取一条应付单数据
     * @param uocOrderShouldPayDo 查询条件
     * @return 一条应付单数据
     */
    UocOrderShouldPayDo getOrderShouldPay(UocOrderShouldPayDo uocOrderShouldPayDo);

    /**
     * 查询多条应付单数据
     *
     * @param uocOrderShouldPayDo 查询条件
     * @return 多条应付单数据
     */
    List<UocOrderShouldPayDo> getListOrderShouldPay(UocOrderShouldPayDo uocOrderShouldPayDo);

    /**
     * 订单应付单主体数据更新
     * @param set
     * @param where
     */
    void modifyOrderShouldPayMain(UocOrderShouldPayDo set,UocOrderShouldPayDo where);
}
