/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocEsSyncChng
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncChng.class);
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getChngOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocChngOrderDo chngOrder = this.getUocChngOrderDo(reqBo);
        if (null == chngOrder) {
            return iUocEsSyncQryRspBo;
        }
        Map<String, Map<String, String>> dicMap = this.getDic();
        List<UocChngOrderObj> chngOrderObjList = this.getChngOrderObjList(reqBo);
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            List<UocChngOrderObj> filterChngOrderObjs;
            if (ObjectUtil.isNotEmpty(dicMap.get("CHNG_ORDER_TYPE")) && ObjectUtil.isNotNull((Object)chngOrderObjList.get(0).getChngType())) {
                chngOrder.setChngTypeStr(dicMap.get("CHNG_ORDER_TYPE").get(chngOrderObjList.get(0).getChngType().toString()));
            }
            if (ObjectUtil.isNotEmpty(filterChngOrderObjs = chngOrderObjList.stream().filter(each -> ObjectUtil.isNotNull((Object)each.getShipOrderId())).collect(Collectors.toList())) && ObjectUtil.isNotNull((Object)(uocShipOrderDo = this.getUocShipOrderDo(filterChngOrderObjs)))) {
                chngOrder.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
                chngOrder.setShipOrderState(uocShipOrderDo.getShipOrderState());
                chngOrder.setInspTime(uocShipOrderDo.getInspTime());
                chngOrder.setInspOperName(uocShipOrderDo.getInspOperName());
                if (ObjectUtil.isNotEmpty(dicMap.get("SHIP_ORDER_STATE"))) {
                    chngOrder.setShipOrderStateStr(dicMap.get("SHIP_ORDER_STATE").get(uocShipOrderDo.getShipOrderState()));
                }
                uocShipOrderDo.setShipOrderItemBoList(this.getShipOrderItem(uocShipOrderDo).getShipOrderItemBoList());
            }
        }
        chngOrder.setUocChngOrderObjList(chngOrderObjList);
        Map<Object, Object> chngOrderState = new HashMap();
        chngOrderState = ObjectUtil.equal((Object)chngOrder.getBusiType(), (Object)UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL) ? dicMap.get("CHNG_ORDER_STATE_SALE_ORDER_CANCEL") : dicMap.get("CHNG_ORDER_STATE");
        log.info("dicMap:{}", (Object)JSON.toJSONString(dicMap));
        log.info(JSON.toJSONString((Object)chngOrder));
        chngOrder.setChngOrderStateStr((String)chngOrderState.get(chngOrder.getChngOrderState()));
        JSONObject chngOrderJson = JSON.parseObject((String)JSON.toJSONString((Object)chngOrder, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            UocSaleOrderDo saleOrder = this.getSaleOrder(chngOrderObjList.get(0));
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            if (null != saleOrder) {
                List<UocOrderAgreement> agreementOrderList;
                Map<String, String> saleOrderState = dicMap.get("UOC_SALE_ORDER_STATE");
                saleOrder.setSaleOrderStateStr(saleOrderState.get(saleOrder.getSaleOrderState()));
                saleOrder.setPayType(saleOrderState.get(saleOrder.getSaleOrderState()));
                List<UocSaleOrderItem> uocSaleOrderItemList = this.getListSaleOrderItem(chngOrderObjList.get(0));
                if (ObjectUtil.isNotEmpty(uocSaleOrderItemList) && ObjectUtil.isNotNull((Object)uocShipOrderDo) && ObjectUtil.isNotEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                    BigDecimal sendCount = uocShipOrderDo.getShipOrderItemBoList().get(0).getSendCount();
                    chngOrderJson.put("saleFee", (Object)uocSaleOrderItemList.get(0).getSalePrice().multiply(sendCount));
                    chngOrderJson.put("purFee", (Object)uocSaleOrderItemList.get(0).getPurchasePrice().multiply(sendCount));
                }
                saleOrder.setSaleOrderItems(uocSaleOrderItemList);
                List<UocSaleOrderPayConf> saleOrderPayConfList = this.getUocSaleOrderPayConf(saleOrder);
                if (!CollectionUtils.isEmpty(saleOrderPayConfList)) {
                    Map<String, String> payType = dicMap.get("UOC_SALE_ORDER_PAY_TYPE");
                    saleOrder.setSaleOrderPayConfList(saleOrderPayConfList);
                    for (UocSaleOrderPayConf uocSaleOrderPayConf : saleOrderPayConfList) {
                        if (!UocDicConstant.USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType())) continue;
                        chngOrderJson.put("payType", (Object)payType.get(uocSaleOrderPayConf.getPayType().toString()));
                    }
                }
                chngOrderJson.put("saleOrderItems", (Object)JSON.parseArray((String)JSON.toJSONString(saleOrder.getSaleOrderItems())));
                if (ObjectUtil.isNotEmpty((Object)saleOrder.getStakeholder())) {
                    chngOrderJson.put("supName", (Object)saleOrder.getStakeholder().getSupName());
                    chngOrderJson.put("purOrgId", (Object)saleOrder.getStakeholder().getPurOrgId());
                    chngOrderJson.put("purOrgName", (Object)saleOrder.getStakeholder().getPurOrgName());
                }
                busiProcInst = this.getProcInst(saleOrder, false);
                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrder.getOrderSource()) && ObjectUtil.isNotEmpty(agreementOrderList = this.getAgreementOrderList(reqBo))) {
                    this.putAgreementInfo(agreementOrderList, chngOrderJson);
                }
            }
            chngOrderJson.put("saleOrderInfo", (Object)saleOrder);
            chngOrderJson.put("busiProcInstId", (Object)(ObjectUtil.isNotEmpty((Object)busiProcInst.getProcInstId()) ? busiProcInst.getProcInstId() : ""));
            chngOrderJson.put("busiTaskList", (Object)(ObjectUtil.isNotEmpty((Object)busiProcInst.getTaskList()) ? busiProcInst.getTaskList() : new ArrayList()));
        }
        if (!CollectionUtils.isEmpty(chngOrder.getUocChngOrderMapList())) {
            chngOrder.getUocChngOrderMapList().forEach(uocChngOrderMap -> chngOrderJson.put(uocChngOrderMap.getFieldCode(), (Object)uocChngOrderMap.getFieldValue()));
        }
        iUocEsSyncQryRspBo.setJsonObj(chngOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private UocChngOrderDo getUocChngOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setChngOrderId(reqBo.getObjId());
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
    }

    private List<UocOrderAgreement> getAgreementOrderList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
        uocOrderAgreementQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        saleOrderObj.put("agreementCode", (Object)agreement.getAgreementCode());
        saleOrderObj.put("plaAgreementCode", (Object)agreement.getPlaAgreementCode());
        saleOrderObj.put("agreementName", (Object)agreement.getAgreementName());
    }

    private UocShipOrderDo getUocShipOrderDo(List<UocChngOrderObj> chngOrderObjList) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(chngOrderObjList.get(0).getOrderId());
        uocShipOrderQryBo.setShipOrderId(chngOrderObjList.get(0).getShipOrderId());
        UocShipOrderDo shipOrderDo = this.iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        return shipOrderDo;
    }

    private UocShipOrderDo getShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    private List<UocChngOrderObj> getChngOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderObjQryBo.setChngOrderId(reqBo.getObjId());
        return this.iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("SHIP_ORDER_STATE");
        pCodes.add("UOC_SALE_ORDER_STATE");
        pCodes.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodes.add("CHNG_ORDER_STATE_SALE_ORDER_CANCEL");
        pCodes.add("CHNG_ORDER_STATE");
        pCodes.add("CHNG_ORDER_TYPE");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private List<UocSaleOrderPayConf> getUocSaleOrderPayConf(UocSaleOrderDo saleOrder) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrder.getSaleOrderId());
        return this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocSaleOrderDo reqBo, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getSaleOrderId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }
}

