/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleStakeholderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UocEsSyncTransaction
implements IUocEsSync {
    @Autowired
    private UocIndexConfig uocIndexConfig;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    private static final String CHARGE_MONTH_SERVICE = "1";
    private static final String SALE = "1";
    private static final String INSP = "2";

    @Override
    public String indexName() {
        return this.uocIndexConfig.getTransactionIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        Long orderId = reqBo.getOrderId();
        JSONObject supplierSignInfo = reqBo.getJsonObj();
        String supplierId = supplierSignInfo.getString("supplierId");
        String monthServiceFee = supplierSignInfo.getString("monthServiceFee");
        String monthReceiveNode = supplierSignInfo.getString("monthReceiveNode");
        JSONArray salesBOS = supplierSignInfo.getJSONArray("salesBOS");
        HashMap<String, String> serviceFeeRateMap = new HashMap<String, String>(salesBOS.size());
        for (int i = 0; i < salesBOS.size(); ++i) {
            JSONObject itemCat = salesBOS.getJSONObject(i);
            serviceFeeRateMap.put(supplierId + itemCat.getString("itemCatId"), itemCat.getString("serviceFeeRate"));
        }
        if (UocDicConstant.OBJ_TYPE.SALE.equals(reqBo.getObjType())) {
            if ("1".equals(monthReceiveNode)) {
                this.syncSaleTransaction(reqBo, rspBo, orderId, serviceFeeRateMap, monthServiceFee);
            } else {
                rspBo.setSyncFlag(false);
            }
        } else if (UocDicConstant.OBJ_TYPE.INSPECTION.equals(reqBo.getObjType())) {
            Long inspOrderId = reqBo.getObjId();
            UocInspOrderDo inspOrderMain = this.getUocInspOrderDo(orderId, inspOrderId);
            UocSaleOrderDo saleOrderMain = this.getUocSaleOrderDo(orderId, inspOrderMain.getSaleOrderId());
            UocOrderRel uocOrderRel = this.getUocOrderRel(orderId, saleOrderMain.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
            if (null == uocOrderRel) {
                this.syncInspTransaction(reqBo, rspBo, orderId, serviceFeeRateMap, monthServiceFee, inspOrderMain, saleOrderMain);
            } else {
                rspBo.setSyncFlag(false);
            }
        }
        return rspBo;
    }

    private void syncInspTransaction(IUocEsSyncQryReqBo reqBo, IUocEsSyncQryRspBo rspBo, Long orderId, Map<String, String> serviceFeeRateMap, String monthServiceFee, UocInspOrderDo inspOrderMain, UocSaleOrderDo saleOrderMain) {
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocSaleStakeholder stakeholder = this.getStakeholder(saleOrderMain.getStakeholderId());
        UocOrderRel uocOrderRel = this.getUocOrderRel(orderId, inspOrderMain.getInspOrderId(), UocDicConstant.OBJ_TYPE.INSPECTION);
        List<UocInspOrderItem> uocInspOrderItemList = this.getUocInspOrderItems(orderId, inspOrderMain);
        JSONObject jsonObj = JSON.parseObject((String)JSON.toJSONString((Object)saleOrderMain));
        jsonObj.putAll(BeanUtil.beanToMap((Object)stakeholder, (boolean)false, (boolean)true));
        jsonObj.put("inspOrderId", (Object)inspOrderMain.getInspOrderId());
        jsonObj.put("inspOrderNo", (Object)inspOrderMain.getInspOrderNo());
        JSONArray inspOrderItems = JSONArray.parseArray((String)JSON.toJSONString(uocInspOrderItemList));
        BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
        for (int i = 0; i < inspOrderItems.size(); ++i) {
            JSONObject inspItem = inspOrderItems.getJSONObject(i);
            UocSaleOrderItem uocSaleOrderItem = saleOrderItemMap.get(inspItem.getLong("saleOrderItemId"));
            inspItem.put("skuName", (Object)uocSaleOrderItem.getSkuName());
            inspItem.put("skuId", (Object)uocSaleOrderItem.getSkuId());
            inspItem.put("spec", (Object)uocSaleOrderItem.getSpec());
            inspItem.put("model", (Object)uocSaleOrderItem.getModel());
            inspItem.put("commodityTypeId", (Object)uocSaleOrderItem.getCommodityTypeId());
            inspItem.put("unitName", (Object)uocSaleOrderItem.getUnitName());
            inspItem.put("itemCount", inspItem.get((Object)"inspCount"));
            inspItem.put("salePrice", (Object)uocSaleOrderItem.getSalePrice());
            inspItem.put("purPrice", (Object)uocSaleOrderItem.getPurchasePrice());
            String serviceFeeRate = serviceFeeRateMap.get(jsonObj.getString("supId") + inspItem.getString("commodityTypeId"));
            BigDecimal serPriceMoney = new BigDecimal(inspItem.getString("itemCount")).multiply(new BigDecimal(inspItem.getString("salePrice"))).multiply(new BigDecimal(serviceFeeRate)).divide(new BigDecimal(100), RoundingMode.CEILING);
            inspItem.put("serPriceMoney", (Object)serPriceMoney);
            inspItem.put("serviceFeeRate", "1".equals(monthServiceFee) ? serviceFeeRate : BigDecimal.ZERO);
            totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
        }
        jsonObj.put("orderItem", (Object)inspOrderItems);
        jsonObj.put("monthServiceFee", (Object)monthServiceFee);
        jsonObj.put("serPriceMoney", (Object)("1".equals(monthServiceFee) ? totalSerPriceMoney : BigDecimal.ZERO));
        jsonObj.put("supNoRule", (Object)(jsonObj.getString("supId") + INSP));
        jsonObj.put("objType", (Object)UocDicConstant.OBJ_TYPE.INSPECTION);
        if (null != uocOrderRel) {
            jsonObj.put("relType", (Object)uocOrderRel.getRelType());
            jsonObj.put("relStatus", (Object)uocOrderRel.getRelStatus());
            jsonObj.put("relInfo", (Object)(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType()));
            jsonObj.put("relId", (Object)uocOrderRel.getRelId());
        } else {
            jsonObj.put("relType", (Object)UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put("relStatus", (Object)UocDicConstant.REL_STATUS.UN_SUBMITTED);
            jsonObj.put("relInfo", (Object)(UocDicConstant.REL_STATUS.UN_SUBMITTED + "," + UocDicConstant.REL_TYPE.SERVICE_CHARGE));
        }
        rspBo.setJsonObj(jsonObj);
    }

    private void syncSaleTransaction(IUocEsSyncQryReqBo reqBo, IUocEsSyncQryRspBo rspBo, Long orderId, Map<String, String> serviceFeeRateMap, String monthServiceFee) {
        Long saleOrderId = reqBo.getObjId();
        UocSaleOrderDo saleOrderMain = this.getUocSaleOrderDo(orderId, saleOrderId);
        UocSaleStakeholder stakeholder = this.getStakeholder(saleOrderMain.getStakeholderId());
        UocOrderRel uocOrderRel = this.getUocOrderRel(orderId, saleOrderId, UocDicConstant.OBJ_TYPE.SALE);
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        JSONObject jsonObj = JSON.parseObject((String)JSON.toJSONString((Object)saleOrderMain));
        jsonObj.putAll(BeanUtil.beanToMap((Object)stakeholder, (boolean)false, (boolean)true));
        JSONArray saleOrderItems = JSONArray.parseArray((String)JSON.toJSONString(saleOrderItemList));
        BigDecimal totalSerPriceMoney = BigDecimal.ZERO;
        for (int i = 0; i < saleOrderItems.size(); ++i) {
            JSONObject saleItem = saleOrderItems.getJSONObject(i);
            saleItem.put("itemCount", saleItem.get((Object)"purchaseCount"));
            String serviceFeeRate = serviceFeeRateMap.get(jsonObj.getString("supId") + saleItem.getString("commodityTypeId"));
            BigDecimal serPriceMoney = new BigDecimal(saleItem.getString("totalSaleFee")).multiply(new BigDecimal(serviceFeeRate)).divide(new BigDecimal(100), RoundingMode.CEILING);
            saleItem.put("serPriceMoney", (Object)("1".equals(monthServiceFee) ? serPriceMoney : BigDecimal.ZERO));
            saleItem.put("serviceFeeRate", (Object)serviceFeeRate);
            totalSerPriceMoney = totalSerPriceMoney.add(serPriceMoney);
        }
        jsonObj.put("orderItem", (Object)saleOrderItems);
        jsonObj.put("monthServiceFee", (Object)monthServiceFee);
        jsonObj.put("serPriceMoney", (Object)("1".equals(monthServiceFee) ? totalSerPriceMoney : BigDecimal.ZERO));
        jsonObj.put("supNoRule", (Object)(jsonObj.getString("supId") + "1"));
        jsonObj.put("objType", (Object)UocDicConstant.OBJ_TYPE.SALE);
        if (null != uocOrderRel) {
            jsonObj.put("relType", (Object)uocOrderRel.getRelType());
            jsonObj.put("relStatus", (Object)uocOrderRel.getRelStatus());
            jsonObj.put("relInfo", (Object)(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType()));
            jsonObj.put("relId", (Object)uocOrderRel.getRelId());
        } else {
            jsonObj.put("relType", (Object)UocDicConstant.REL_TYPE.SERVICE_CHARGE);
            jsonObj.put("relStatus", (Object)UocDicConstant.REL_STATUS.UN_SUBMITTED);
            jsonObj.put("relInfo", (Object)(UocDicConstant.REL_STATUS.UN_SUBMITTED + "," + UocDicConstant.REL_TYPE.SERVICE_CHARGE));
        }
        rspBo.setJsonObj(jsonObj);
    }

    private List<UocInspOrderItem> getUocInspOrderItems(Long orderId, UocInspOrderDo inspOrderMain) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setOrderId(orderId);
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        UocInspOrderDo inspOrderItem = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        return inspOrderItem.getUocInspOrderItemList();
    }

    private UocInspOrderDo getUocInspOrderDo(Long orderId, Long inspOrderId) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(orderId);
        uocInspOrderQryBo.setInspOrderId(inspOrderId);
        return this.iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    private UocOrderRel getUocOrderRel(Long orderId, Long objId, Integer objType) {
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setRelType(UocDicConstant.REL_TYPE.SERVICE_CHARGE);
        uocOrderRelQryBo.setOrderId(orderId);
        uocOrderRelQryBo.setObjId(objId);
        uocOrderRelQryBo.setObjType(objType);
        return this.iUocOrderModel.qryRelInfo(uocOrderRelQryBo);
    }

    private UocSaleOrderDo getUocSaleOrderDo(Long orderId, Long saleOrderId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(orderId);
        uocSaleOrderDo.setSaleOrderId(saleOrderId);
        return this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getObjId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private UocSaleStakeholder getStakeholder(Long stakeholderId) {
        UocSaleStakeholderQryBo uocSaleStakeholderQryBo = new UocSaleStakeholderQryBo();
        uocSaleStakeholderQryBo.setStakeholderId(stakeholderId);
        List<UocSaleStakeholder> uocSaleStakeholders = this.iUocSaleOrderModel.qrySaleOrderStakeholder(uocSaleStakeholderQryBo);
        return uocSaleStakeholders.get(0);
    }
}

