/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.order.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEvaluateQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdInvoiceQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderCheckAccountQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderItemQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEvaluate;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderItemEw;
import com.tydic.dyc.oc.model.order.sub.UocOrderItemMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.repository.UocOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrderModelmpl
implements IUocOrderModel {
    private static final Logger log = LoggerFactory.getLogger(OrderModelmpl.class);
    @Autowired
    private UocOrderRepository uocOrderRepository;

    @Override
    public UocOrderDo createOrder(UocOrderDo orderDo) {
        this.validateCreateOrderArg(orderDo);
        orderDo.setOrderId(IdUtil.nextId());
        orderDo.setCreateTime(new Date());
        this.setAddressInfo(orderDo);
        this.setOrderInfo(orderDo);
        UocOrdInvoice uocOrdInvoice = orderDo.getUocOrdInvoice();
        if (ObjectUtil.isNotEmpty((Object)uocOrdInvoice)) {
            uocOrdInvoice.setId(IdUtil.nextId());
            uocOrdInvoice.setOrderId(orderDo.getOrderId());
            uocOrdInvoice.setContactId(orderDo.getInvoiceAddress().getContactId());
            uocOrdInvoice.setCreateOperId(orderDo.getCreateOperId());
            uocOrdInvoice.setCreateTime(orderDo.getCreateTime());
        }
        List<UocOrderAccessory> accessoryList = orderDo.getAccessoryList();
        for (UocOrderAccessory uocOrderAccessory : accessoryList) {
            uocOrderAccessory.setId(IdUtil.nextId());
            uocOrderAccessory.setOrderId(orderDo.getOrderId());
            uocOrderAccessory.setCreateTime(orderDo.getCreateTime());
            uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
            uocOrderAccessory.setObjId(orderDo.getOrderId());
            uocOrderAccessory.setAttachmentType(UocDicConstant.ACCESSORY_TYPE.CREATE_ORDER);
        }
        this.setOrderItemInfo(orderDo);
        this.setOrderExtInfo(orderDo);
        return this.uocOrderRepository.saveUocOrder(orderDo);
    }

    private void setOrderExtInfo(UocOrderDo orderDo) {
        List<UocOrderMap> orderExt = orderDo.getOrderExt();
        if (ObjectUtil.isNotEmpty(orderExt)) {
            for (UocOrderMap uocOrderMap : orderExt) {
                uocOrderMap.setId(IdUtil.nextId());
                uocOrderMap.setCreateTime(orderDo.getCreateTime());
                uocOrderMap.setOrderId(uocOrderMap.getOrderId());
            }
        }
    }

    private void validateCreateOrderArg(UocOrderDo orderDo) {
        if (ObjectUtil.isEmpty((Object)((Object)orderDo))) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<UocOrderItem> orderItems = orderDo.getOrderItems();
        if (ObjectUtil.isEmpty(orderItems)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1\u5217\u8868]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (ObjectUtil.isEmpty(uocOrderAccessoryList)) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.createOrderAccessory(uocOrderAccessoryList);
    }

    private void setOrderItemInfo(UocOrderDo orderDo) {
        List<UocOrderItem> orderItems = orderDo.getOrderItems();
        for (UocOrderItem orderItem : orderItems) {
            List<UocOrderItemEw> ewList;
            orderItem.setOrderItemId(IdUtil.nextId());
            orderItem.setOrderId(orderDo.getOrderId());
            orderItem.setCreateTime(orderDo.getCreateTime());
            orderItem.setCreateOperId(orderDo.getCreateOperId());
            List<UocOrderItemMap> itemMapList = orderItem.getItemMapList();
            if (ObjectUtil.isNotEmpty(itemMapList)) {
                for (UocOrderItemMap uocOrderItemMap : itemMapList) {
                    uocOrderItemMap.setId(IdUtil.nextId());
                    uocOrderItemMap.setOrderItemId(orderItem.getOrderItemId());
                    uocOrderItemMap.setOrderId(orderDo.getOrderId());
                    uocOrderItemMap.setCreateTime(orderDo.getCreateTime());
                    uocOrderItemMap.setCreateOperId(orderDo.getCreateOperId());
                }
            }
            if (ObjectUtil.isNotEmpty(ewList = orderItem.getEwList())) {
                for (UocOrderItemEw ew : ewList) {
                    ew.setId(IdUtil.nextId());
                    ew.setOrderItemId(orderItem.getOrderItemId());
                    ew.setOrderId(orderDo.getOrderId());
                    ew.setCreateOperId(orderDo.getCreateOperId());
                    ew.setCreateTime(orderDo.getCreateTime());
                    ew.setSkuId(orderItem.getSkuId());
                }
            }
            if (!ObjectUtil.isNotEmpty((Object)orderItem.getAgreementId())) continue;
            UocOrderAgreement uocOrderAgreement = orderItem.getAgrBo();
            uocOrderAgreement.setOrderId(orderDo.getOrderId());
            uocOrderAgreement.setId(IdUtil.nextId());
        }
    }

    private void setOrderInfo(UocOrderDo orderDo) {
        if (ObjectUtil.isNotEmpty((Object)orderDo.getUocOrdInvoice())) {
            orderDo.setNeedInvoiceTag(UocDicConstant.NEED_INVOICED.NEED_INVOICED_Y);
        } else {
            orderDo.setNeedInvoiceTag(UocDicConstant.NEED_INVOICED.NEED_INVOICED_N);
        }
        orderDo.setContactId(orderDo.getReceiverAddress() != null ? orderDo.getReceiverAddress().getContactId() : null);
        if (ObjectUtil.isNotEmpty(orderDo.getOrderExt())) {
            List<UocOrderMap> orderExt = orderDo.getOrderExt();
            for (UocOrderMap map : orderExt) {
                map.setOrderId(orderDo.getOrderId());
                map.setCreateOperId(orderDo.getCreateOperId());
                map.setId(IdUtil.nextId());
                map.setCreateTime(orderDo.getCreateTime());
            }
        }
    }

    private void setAddressInfo(UocOrderDo orderDo) {
        UocOrdLogisticsRela receiverAddress;
        UocOrdLogisticsRela invoiceAddress = orderDo.getInvoiceAddress();
        if (invoiceAddress != null) {
            invoiceAddress.setOrderId(orderDo.getOrderId());
            invoiceAddress.setContactId(IdUtil.nextId());
            invoiceAddress.setCreateOperId(orderDo.getCreateOperId());
            invoiceAddress.setCreateTime(orderDo.getCreateTime());
        }
        if ((receiverAddress = orderDo.getReceiverAddress()) != null) {
            receiverAddress.setOrderId(orderDo.getOrderId());
            receiverAddress.setContactId(IdUtil.nextId());
            receiverAddress.setCreateOperId(orderDo.getCreateOperId());
            receiverAddress.setCreateTime(orderDo.getCreateTime());
        }
    }

    @Override
    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (null == uocOrderStateChgLog) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.createOrderStateChangeLog(uocOrderStateChgLog);
    }

    @Override
    public List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo) {
        return this.uocOrderRepository.qryStakeholderList(qryBo);
    }

    @Override
    public List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderTaskInstList(qryBo);
    }

    @Override
    public List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderTaskDealList(qryBo);
    }

    @Override
    public List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderProcInstList(qryBo);
    }

    @Override
    public UocOrderDo qryOrderBy(UocOrderDo uocOrderDo) {
        if (null == uocOrderDo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderBy(uocOrderDo);
    }

    @Override
    public List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo) {
        if (null == uocOrderItemQryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderItemList(uocOrderItemQryBo);
    }

    @Override
    public UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderLogisticsRela(qryBo);
    }

    @Override
    public UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderInvoice(qryBo);
    }

    @Override
    public List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.getOrderAccessoryList(qryBo);
    }

    @Override
    public List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderMapList(qryBo);
    }

    @Override
    public void dealRelUpdate(UocOrderRel qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocOrderRepository.dealRelUpdate(qryBo);
    }

    @Override
    public List<UocOrderQueryIndex> qryOrderQueryIndexList(UocOrderQueryIndexQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryOrderQueryIndexList(qryBo);
    }

    @Override
    public UocOrderRel qryRelInfo(UocOrderRelQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryRelInfo(qryBo);
    }

    @Override
    public void createRelInfo(UocOrderRel uocOrderRel) {
        if (null == uocOrderRel) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocOrderRepository.createRelInfo(uocOrderRel);
    }

    @Override
    public UocOrderCheckAccount qryCheckInfo(UocOrderCheckAccountQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.uocOrderRepository.qryCheckInfo(qryBo);
    }

    @Override
    public void createCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        if (null == uocOrderCheckAccount) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocOrderRepository.createCheckInfo(uocOrderCheckAccount);
    }

    @Override
    public void updateCheckInfo(UocOrderCheckAccount uocOrderCheckAccount) {
        if (null == uocOrderCheckAccount) {
            throw new BaseBusinessException("102001", "\u65b9\u6cd5\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.uocOrderRepository.updateCheckInfo(uocOrderCheckAccount);
    }

    @Override
    public void modifySalePrice(UocOrderDo uocOrderDo) {
        UocOrderDo uocOrderDo1 = new UocOrderDo();
        uocOrderDo1.setOrderItems(uocOrderDo.getOrderItems());
        uocOrderDo1.setOrderId(uocOrderDo.getOrderId());
        this.uocOrderRepository.modifyBatchItemSalePrice(uocOrderDo1);
        UocOrderDo uocOrderDo2 = new UocOrderDo();
        uocOrderDo2.setOrderId(uocOrderDo.getOrderId());
        UocOrderDo uocOrderDo4 = this.uocOrderRepository.getOrderItemTotalSalePrice(uocOrderDo2);
        UocOrderDo uocOrderDo3 = new UocOrderDo();
        uocOrderDo3.setOrderId(uocOrderDo.getOrderId());
        uocOrderDo3.setTotalSaleFee(uocOrderDo4.getTotalSaleFee());
        uocOrderDo3.setUpdateOperId(uocOrderDo.getUpdateOperId());
        uocOrderDo3.setUpdateTime(uocOrderDo.getUpdateTime());
        this.uocOrderRepository.modifyOrderMain(uocOrderDo3);
    }

    @Override
    public BasePageRspBo<UocConfEvaluate> qryListPageConfEvaluate(UocConfEvaluateQryBo uocConfEvaluateQryBo) {
        return this.uocOrderRepository.qryListPageConfEvaluate(uocConfEvaluateQryBo);
    }

    @Override
    public void addConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        this.uocOrderRepository.addConfEvaluate(uocConfEvaluate);
    }

    @Override
    public void modifyConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        this.uocOrderRepository.modifyConfEvaluate(uocConfEvaluate);
    }

    @Override
    public void deleteConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        this.uocOrderRepository.deleteConfEvaluate(uocConfEvaluate);
    }

    @Override
    public UocConfEvaluate getConfEvaluateById(Long id) {
        return null;
    }

    @Override
    public int getCheckConfEvaluate(UocConfEvaluate uocConfEvaluate) {
        return this.uocOrderRepository.getCheckConfEvaluate(uocConfEvaluate);
    }
}

