/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderItemQryBo;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrderItem;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocAfterOrderCancelService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAfterOrderCancelRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocAfterOrderCancelService"})
public class UocAfterOrderCancelServiceImpl
implements UocAfterOrderCancelService {
    @Autowired
    private IUocAfOrderModel afOrderModel;
    @Autowired
    private IUocInspOrderModel inspOrderModel;
    @Autowired
    private IUocSaleOrderModel saleOrderModel;

    @PostMapping(value={"cancelAfterOrder"})
    public UocAfterOrderCancelRspBo cancelAfterOrder(@RequestBody UocAfterOrderCancelReqBo reqBo) {
        List<UocAfOrderItem> afOrderItemList;
        UocAfterOrderCancelRspBo rspBo = UocRu.success(UocAfterOrderCancelRspBo.class);
        this.validateArg(reqBo);
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        UocAfOrder uocAfOrder = this.afOrderModel.getAfOrderById(uocAfOrderQryBo);
        if (ObjectUtil.isEmpty((Object)uocAfOrder)) {
            throw new BaseBusinessException("100001", "\u67e5\u8be2\u552e\u540e\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        Integer servType = uocAfOrder.getServType();
        if (UocConstant.AFTERORDER_SERVTYPE.RETURN.equals(servType) && CollectionUtil.isNotEmpty(afOrderItemList = this.afOrderModel.getAfOrderItemList(UocRu.js(reqBo, UocAfOrderItemQryBo.class)))) {
            for (UocAfOrderItem uocAfOrderItem : afOrderItemList) {
                this.updateItemAndInspection(uocAfOrderItem, reqBo, rspBo);
            }
        }
        rspBo.setSaleOrderId(uocAfOrder.getSaleOrderId());
        return rspBo;
    }

    private void updateItemAndInspection(UocAfOrderItem uocAfOrderItem, UocAfterOrderCancelReqBo reqBo, UocAfterOrderCancelRspBo rspBo) {
        Long inspItemId = uocAfOrderItem.getInspItemId();
        Long orderItemId = uocAfOrderItem.getOrderItemId();
        if (ObjectUtil.isNotEmpty((Object)orderItemId)) {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocSaleOrderItem.setSaleOrderItemId(orderItemId);
            uocSaleOrderItem.setReturnCount(BigDecimal.ZERO);
            uocSaleOrderItem.setUpdateTime(new Date());
            uocSaleOrderItem.setUpdateOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            this.saleOrderModel.modifySaleOrderItemReturningCount(uocSaleOrderItem);
        }
        if (ObjectUtil.isNotEmpty((Object)inspItemId)) {
            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
            uocInspOrderItem.setOrderId(uocAfOrderItem.getOrderId());
            uocInspOrderItem.setSaleOrderItemId(orderItemId);
            uocInspOrderItem.setReturnCount(BigDecimal.ZERO);
            uocInspOrderItem.setUpdateTime(new Date());
            uocInspOrderItem.setUpdateOperId(ObjectUtil.isEmpty((Object)reqBo.getUserId()) ? null : String.valueOf(reqBo.getUserId()));
            this.inspOrderModel.modifySaleOrderItemReturningCount(uocInspOrderItem);
            if (ObjectUtil.isEmpty((Object)rspBo.getInspOrderId())) {
                UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
                UocInspOrderDo listInspOrderItem = this.inspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
                rspBo.setInspOrderId(listInspOrderItem.getInspOrderId());
            }
        }
    }

    private void validateArg(UocAfterOrderCancelReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocAfterOrderCancelReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8ba2\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAfOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u552e\u540e\u5355ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

