/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderOperating;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.domainservice.UocCreateOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqCommodityBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqInvoiceBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqPayConfSupBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceReqProfessionalBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateOrderServiceRspSaleOrderItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocCreateOrderService"})
public class UocCreateOrderServiceImpl
implements UocCreateOrderService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"createOrder"})
    public UocCreateOrderServiceRspBo createOrder(@RequestBody UocCreateOrderServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocCreateOrderServiceRspBo rspBo = UocRu.success(UocCreateOrderServiceRspBo.class);
        UocOrderDo createDo = this.convertOrderDo(reqBo);
        UocOrderDo createOrderRet = this.iUocOrderModel.createOrder(createDo);
        rspBo.setTotalSaleFee(createDo.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(createDo.getTotalPurchaseFee());
        rspBo.setSaleOrderList(new ArrayList());
        JSONObject supSignInfo = reqBo.getJsonObj();
        if (reqBo.getCreateSaleOrder().booleanValue()) {
            List<UocSaleOrderItem> uocSaleOrderDos = this.orderDo2SaleDo(createOrderRet, reqBo);
            List<UocSaleOrderDo> saleOrderList = this.splitOrder(createOrderRet, reqBo);
            for (UocSaleOrderDo saleOrderDo : saleOrderList) {
                JSONObject supSignInfoJSONObject = supSignInfo.getJSONObject(saleOrderDo.getStakeholder().getSupId());
                if ("1".equals(supSignInfoJSONObject.getString("monthReceiveNode"))) {
                    saleOrderDo.setIsCreateServiceFee(true);
                }
                UocSaleOrderDo saleOrderRet = this.iUocSaleOrderModel.createSaleOrder(saleOrderDo);
                UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
                BeanUtils.copyProperties((Object)saleOrderRet, (Object)orderItemRspData);
                BeanUtils.copyProperties((Object)saleOrderRet.getStakeholder(), (Object)orderItemRspData);
                orderItemRspData.setSaleOrderId(saleOrderRet.getSaleOrderId());
                List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrderRet.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
                orderItemRspData.setItemBoList(itemList);
                orderItemRspData.setSaleOrderNo(saleOrderRet.getSaleOrderNo());
                orderItemRspData.setOrderSource(saleOrderRet.getOrderSource());
                rspBo.getSaleOrderList().add(orderItemRspData);
            }
        }
        rspBo.setOrderId(createDo.getOrderId());
        return rspBo;
    }

    private List<UocSaleOrderItem> orderDo2SaleDo(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo) {
        ArrayList<UocSaleOrderItem> saleOrderItemList = new ArrayList<UocSaleOrderItem>();
        UocOrderStakeholderQryBo qryStakeholderList = new UocOrderStakeholderQryBo();
        qryStakeholderList.setOrderId(createOrderRet.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = this.iUocOrderModel.qryStakeholderList(qryStakeholderList);
        Map<String, List<UocOrderStakeholderQryBo>> supStakeMap = uocOrderStakeholderQryBos.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
        List<UocOrderItem> orderItems = createOrderRet.getOrderItems();
        for (UocOrderItem orderItem : orderItems) {
            UocSaleOrderItem saleItemDo = UocRu.js(orderItem, UocSaleOrderItem.class);
            saleOrderItemList.add(saleItemDo);
        }
        return saleOrderItemList;
    }

    private List<UocSaleOrderDo> splitOrder(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo) {
        ArrayList<UocSaleOrderDo> saleOrderDoList = new ArrayList<UocSaleOrderDo>();
        UocOrderStakeholderQryBo qryStakeholderList = new UocOrderStakeholderQryBo();
        qryStakeholderList.setOrderId(createOrderRet.getOrderId());
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = this.iUocOrderModel.qryStakeholderList(qryStakeholderList);
        Map<String, List<UocOrderStakeholderQryBo>> supStakeMap = uocOrderStakeholderQryBos.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));
        Map<Integer, List<UocOrderItem>> orderItemMap = createOrderRet.getOrderItems().stream().collect(Collectors.groupingBy(UocOrderItem::getSkuSource));
        List<UocOrderItem> uocOrderItems = orderItemMap.get(UocConstant.SkuSource.SELF);
        ArrayList<List<Object>> splitOrderItemList = new ArrayList<List<Object>>();
        Map<String, List<UocOrderItem>> supMap = uocOrderItems.stream().collect(Collectors.groupingBy(UocOrderItem::getSupplierId));
        for (String supId : supMap.keySet()) {
            List noPlanList = supMap.get(supId).stream().filter(item -> item.getPlanId() == null).collect(Collectors.toList());
            List list = supMap.get(supId).stream().filter(item -> item.getPlanId() != null).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(noPlanList)) {
                splitOrderItemList.add(noPlanList);
            }
            if (!ObjectUtil.isNotEmpty(list)) continue;
            splitOrderItemList.addAll(list.stream().collect(Collectors.groupingBy(UocOrderItem::getPlanNo)).values());
        }
        List payConfigList = reqBo.getPayConfigList();
        Map<String, List<UocCreateOrderServiceReqPayConfSupBo>> payConfMap = payConfigList.stream().collect(Collectors.groupingBy(UocCreateOrderServiceReqPayConfSupBo::getSupId));
        for (List list : splitOrderItemList) {
            String supplierId = ((UocOrderItem)list.get(0)).getSupplierId();
            UocSaleOrderDo saleOrderDo = UocRu.js((Object)createOrderRet, UocSaleOrderDo.class);
            saleOrderDo.setOrderSource(((UocOrderItem)list.get(0)).getSkuSource());
            saleOrderDoList.add(saleOrderDo);
            saleOrderDo.setOrderId(createOrderRet.getOrderId());
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());
            saleOrderDo.setStakeholderId(supStakeMap.get(supplierId).get(0).getStakeholderId());
            saleOrderDo.setStakeholder(UocRu.js(supStakeMap.get(supplierId).get(0), UocSaleStakeholder.class));
            saleOrderDo.setOrderSource(((UocOrderItem)list.get(0)).getSkuSource());
            saleOrderDo.setTotalSaleFee(this.getTotalSaleFee(list));
            saleOrderDo.setTotalPurchaseFee(this.getTotalPurchaseFee(list));
            saleOrderDo.setSendTime(createOrderRet.getSendTime());
            saleOrderDo.setModelSettle(payConfMap.get(supplierId).get(0).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());
            saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(payConfMap.get(supplierId).get(0).getConfBos(), UocSaleOrderPayConf.class));
            saleOrderDo.setSaleOrderItems(UocRu.jsl(list, UocSaleOrderItem.class));
        }
        return saleOrderDoList;
    }

    private BigDecimal getTotalPurchaseFee(List<UocOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal getTotalSaleFee(List<UocOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getSalePrice()));
        }
        return saleFee;
    }

    private UocOrderDo convertOrderDo(UocCreateOrderServiceReqBo reqBo) {
        UocOrderDo orderDo = UocRu.js(reqBo, UocOrderDo.class);
        orderDo.setCreateOperId(reqBo.getUserId().toString());
        if (ObjectUtil.isNotEmpty((Object)reqBo.getOrderParallelExtList())) {
            orderDo.setOrderExt(UocRu.jsl(reqBo.getOrderParallelExtList(), UocOrderMap.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceBO())) {
            orderDo.setUocOrdInvoice(UocRu.js(reqBo.getInvoiceBO(), UocOrdInvoice.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAddressBo())) {
            orderDo.setReceiverAddress(UocRu.js(reqBo.getAddressBo(), UocOrdLogisticsRela.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceAddressBo())) {
            orderDo.setInvoiceAddress(UocRu.js(reqBo.getInvoiceAddressBo(), UocOrdLogisticsRela.class));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryList())) {
            orderDo.setAccessoryList(UocRu.jsl(reqBo.getAccessoryList(), UocOrderAccessory.class));
        }
        orderDo.setOperating(UocRu.js(reqBo.getProfessionalBo(), UocOrderOperating.class));
        this.setOrderItems(reqBo, orderDo);
        return orderDo;
    }

    private void setOrderItems(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderDo) {
        List commodityBos = reqBo.getCommodityBos();
        orderDo.setOrderItems(new ArrayList<UocOrderItem>(commodityBos.size()));
        for (UocCreateOrderServiceReqCommodityBo commodityBo : commodityBos) {
            UocOrderItem orderItem = UocRu.js(commodityBo, UocOrderItem.class);
            orderItem.setSupplierId(commodityBo.getSupId());
            orderItem.setSupplierName(commodityBo.getSupName());
            orderItem.setItemType(UocDicConstant.ORDER_ITEM_TYPE.SKU);
            orderDo.getOrderItems().add(orderItem);
        }
    }

    private void validateArg(UocCreateOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u7528\u6237id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTotalSaleFee())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u603b\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getTotalPurchaseFee())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u603b\u91d1\u989d]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPurAccount())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u65b9\u8d26\u5957id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPurAccountName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u65b9\u8d26\u5957\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCommodityBos())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProfessionalBo())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd0\u8425\u65b9\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAddressBo())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UocCreateOrderServiceReqCommodityBo commodityBo : reqBo.getCommodityBos()) {
            this.validateCommodityBo(commodityBo);
        }
        this.validateUocCreateOrderServiceReqProfessionalBo(reqBo.getProfessionalBo());
        this.validateUocCreateOrderServiceReqAddressBo(reqBo.getAddressBo());
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceAddressBo())) {
            this.validateUocCreateOrderServiceReqAddressBo(reqBo.getInvoiceAddressBo());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getInvoiceBO())) {
            this.validateUocCreateOrderServiceReqInvoiceBo(reqBo.getInvoiceBO());
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryList())) {
            for (UocCreateOrderServiceReqAccessoryBo uocCreateOrderServiceReqAccessoryBo : reqBo.getAccessoryList()) {
                this.validateUocCreateOrderServiceReqAccessoryBo(uocCreateOrderServiceReqAccessoryBo);
            }
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getOrderParallelExtList())) {
            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getOrderParallelExtList()) {
                this.validateUocBaseExtParallelBo(uocBaseExtParallelBo);
            }
        }
    }

    private void validateUocCreateOrderServiceReqAccessoryBo(UocCreateOrderServiceReqAccessoryBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqAccessoryBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAccessoryName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9644\u4ef6\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAccessoryUrl())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9644\u4ef6url]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocCreateOrderServiceReqInvoiceBo(UocCreateOrderServiceReqInvoiceBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqInvoiceBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocCreateOrderServiceReqAddressBo(UocCreateOrderServiceReqAddressBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqAddressBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactProvinceId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactProvinceName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u7701\u4efd\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCityId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCityName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u5730\u5e02\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCountyId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactCountyName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u533a\u53bf\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactAddress())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u6536\u8d27\u4eba\u5730\u5740]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactEmail())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u90ae\u4ef6]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getContactMobile())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8054\u7cfb\u4eba\u624b\u673a]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateUocCreateOrderServiceReqProfessionalBo(UocCreateOrderServiceReqProfessionalBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqProfessionalBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd0\u8425\u5355\u4f4d\u673a\u6784id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd0\u8425\u673a\u6784\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getProOrgPath())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u8fd0\u8425\u673a\u6784\u673a\u6784\u6811\u8def\u5f84]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void validateCommodityBo(UocCreateOrderServiceReqCommodityBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocCreateOrderServiceReqCommodityBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5355\u54c1ID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5355\u54c1\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCommodityId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getCommodityName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSupId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546id]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSupName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u4f9b\u5e94\u5546\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSupplierShopId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5e97\u94faID]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPurchasePrice())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u5355\u4ef7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSalePrice())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u9500\u552e\u5355\u4ef7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getPurchaseCount())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u91c7\u8d2d\u6570\u91cf]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSkuSource())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5546\u54c1\u6765\u6e90]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!ObjectUtil.isEmpty((Object)reqBo.getAgreementId()) && ObjectUtil.isEmpty((Object)reqBo.getAgrBo())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u534f\u8bae\u5bf9\u8c61]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getSaleItemParallelExtList())) {
            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getSaleItemParallelExtList()) {
                this.validateUocBaseExtParallelBo(uocBaseExtParallelBo);
            }
        }
    }

    private void validateUocBaseExtParallelBo(UocBaseExtParallelBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[UocBaseExtParallelBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFieldCode())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5b57\u6bb5\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getFieldValue())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[\u5b57\u6bb5\u503c]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

