/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.service.order.UocOrderRelUpdateService;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateReqBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.order.UocOrderRelUpdateService"})
public class UocOrderRelUpdateServiceImpl
implements UocOrderRelUpdateService {
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"dealRelUpdate"})
    public UocOrderRelUpdateRspBo dealRelUpdate(@RequestBody UocOrderRelUpdateReqBo reqBo) {
        this.validateArg(reqBo);
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setObjId(reqBo.getObjId());
        uocOrderRelQryBo.setObjType(reqBo.getObjType());
        uocOrderRelQryBo.setOrderId(reqBo.getOrderId());
        uocOrderRelQryBo.setRelType(reqBo.getRelType());
        UocOrderRel qryRelInfo = this.iUocOrderModel.qryRelInfo(uocOrderRelQryBo);
        if (null != qryRelInfo) {
            UocOrderRel uocOrderRel = new UocOrderRel();
            uocOrderRel.setId(qryRelInfo.getId());
            uocOrderRel.setRelStatus(reqBo.getRelState());
            if (null != reqBo.getRelId()) {
                uocOrderRel.setRelId(reqBo.getRelId());
            }
            this.iUocOrderModel.dealRelUpdate(uocOrderRel);
        } else {
            UocOrderRel uocOrderRel = UocRu.js(reqBo, UocOrderRel.class);
            uocOrderRel.setId(IdUtil.nextId());
            this.iUocOrderModel.createRelInfo(uocOrderRel);
        }
        return UocRu.success(UocOrderRelUpdateRspBo.class);
    }

    private void validateArg(UocOrderRelUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e0d\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "orderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException("100001", "ObjId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException("100001", "ObjType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getRelState()) {
            throw new BaseBusinessException("100001", "relState\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getRelType()) {
            throw new BaseBusinessException("100001", "relType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

