package com.tydic.dyc.oc.model.conforder.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.conforder.IUocConfOrderModel;
import com.tydic.dyc.oc.model.conforder.qrybo.UocConfButtonQryBo;
import com.tydic.dyc.oc.model.conforder.qrybo.UocConfTabOrdStateQryBo;
import com.tydic.dyc.oc.model.conforder.sub.UocConfButton;
import com.tydic.dyc.oc.model.conforder.sub.UocConfTabOrdState;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题:IUocConfTabOrdStateOrderModel
 * 说明:页签配置状态映射规则方法实现
 * 时间:2022/3/11 9:40
 * 作者:tkl
 */

@Service
public class IUocConfOrderModelImpl implements IUocConfOrderModel {

    @Autowired
    private UocCommonRepository uocCommonRepository;

    @Override
    public List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocCommonRepository.qryConfTabOrdStateList(qryBo);
    }

    @Override
    public UocConfButton updateConfButton(UocConfButton confButton) {
        if (null == confButton) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        if (null == confButton.getId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象属性值【ID】不能为空");
        }
        return uocCommonRepository.updateConfButton(confButton);
    }

    @Override
    public List<UocConfButton> qryConfButtonList(UocConfButtonQryBo qryBo) {
        if (null == qryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocCommonRepository.qryConfButtonList(qryBo);
    }
}
