package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.implorder.UocImplOrderDo;
import com.tydic.dyc.oc.model.implorder.qrybo.UocImplOrderItemQryBo;
import com.tydic.dyc.oc.model.implorder.sub.UocImplOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocNumChngOrderCreateServiceImpl
 * 说明:数量变更申请
 * 时间:2022/3/8 18:02
 * 作者:罗有
 */

@HTServiceImpl
public class UocNumChngOrderCreateServiceImpl implements UocNumChngOrderCreateService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    //    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Override
    public UocNumChngOrderCreateRspBo createNumChng(UocNumChngOrderCreateReqBo reqBo) {
        validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocShipOrderItem> shipOrderItemList = getShipOrderItemList(reqBo);
        checkChngingCount(reqBo, shipOrderItemList);
//        List<UocImplOrderItem> implOrderItemList = getImplOrderItemList(shipOrderItemList);
//        UocChngOrderDo uocChngOrderDo = convertChngOrderDo(reqBo, operId, now, shipOrderItemList, implOrderItemList);
//        iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        iUocShipOrderModel.modifyShipOrderItemChngingCount(convertShipOrderDo(reqBo, operId, now));
//        iUocImplOrderModel.modifyBatchItemChngingCount(convertImplOrderDo(reqBo, shipOrderItemList, operId, now));
        UocNumChngOrderCreateRspBo uocNumChngOrderCreateRspBo = UocRu.success(UocNumChngOrderCreateRspBo.class);
//        uocNumChngOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        return uocNumChngOrderCreateRspBo;
    }

    /**
     * 检查执行单下是否已有在途异常变更
     * @param reqBo
     * @param shipOrderItemList
     */
    private void checkChngingCount(UocNumChngOrderCreateReqBo reqBo, List<UocShipOrderItem> shipOrderItemList) {
        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
        uocImplOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocImplOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
//        uocImplOrderItemQryBo.setImplOrderId(reqBo.getImplOrderId());
//        UocImplOrderDo uocImplOrderDo = iUocImplOrderModel.getCollectCountImplOrderItem(uocImplOrderItemQryBo);
//        if(CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())){
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询执行单汇总数量为空");
//        }
//        UocImplOrderItem uocImplOrderItem = uocImplOrderDo.getUocImplOrderItemList().get(0);
//        if(uocImplOrderItem.getChngingCount().compareTo(BigDecimal.ZERO) != 0){
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "执行单下存在异常变更在途数量，请待变更完结后再发起");
//        }
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            if (uocNumChngOrderCreateReqItemBo.getChngCount().add(uocShipOrderItem.getReturnCount())
                    .compareTo(uocShipOrderItem.getInspCount()) > 0) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "可变更数量不足，请重新填写");
            }
        });
    }

    /**
     * 组装执行单信息
     */
    private UocImplOrderDo convertImplOrderDo(UocNumChngOrderCreateReqBo reqBo, List<UocShipOrderItem> shipOrderItemList, String operId, Date now) {
        UocImplOrderDo uocImplOrderDo = new UocImplOrderDo();
//        uocImplOrderDo.setImplOrderId(reqBo.getImplOrderId());
        uocImplOrderDo.setOrderId(reqBo.getOrderId());
        uocImplOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocImplOrderDo.setUpdateTime(now);
        uocImplOrderDo.setUpdateOperId(operId);
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        Map<Long, UocImplOrderItem> uocImplOrderItemMap = new HashMap<>();
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            UocImplOrderItem uocImplOrderItem = uocImplOrderItemMap.get(uocShipOrderItem.getImplOrderItemId());
            if (null == uocImplOrderItem) {
                uocImplOrderItem = new UocImplOrderItem();
                uocImplOrderItem.setImplOrderItemId(uocShipOrderItem.getImplOrderItemId());
                uocImplOrderItem.setChngingCount(uocNumChngOrderCreateReqItemBo.getChngCount());
            } else {
                uocImplOrderItem.setChngingCount(uocImplOrderItem.getChngingCount().add(uocNumChngOrderCreateReqItemBo.getChngCount()));
            }
            uocImplOrderItemMap.put(uocShipOrderItem.getImplOrderItemId(), uocImplOrderItem);
        });
        uocImplOrderDo.setUocImplOrderItemList(new ArrayList<>(uocImplOrderItemMap.values()));
        return uocImplOrderDo;
    }

    /**
     * 组装发货单信息
     */
    private UocShipOrderDo convertShipOrderDo(UocNumChngOrderCreateReqBo reqBo, String operId, Date now) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setShipOrderId(reqBo.getShipOrderId());
//        uocShipOrderDo.setImplOrderId(reqBo.getImplOrderId());
        uocShipOrderDo.setUpdateOperId(operId);
        uocShipOrderDo.setUpdateTime(now);
        List<UocShipOrderItem> uocShipOrderItemList = new ArrayList<>();
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
            uocShipOrderItem.setShipOrderItemId(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            uocShipOrderItem.setChngingCount(uocNumChngOrderCreateReqItemBo.getChngCount());
            uocShipOrderItemList.add(uocShipOrderItem);
        });
        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
        return uocShipOrderDo;
    }

    /**
     * 转换变更单do
     */
    private UocChngOrderDo convertChngOrderDo(UocNumChngOrderCreateReqBo reqBo, String operId, Date now, List<UocShipOrderItem> shipOrderItemList, List<UocImplOrderItem> implOrderItemList) {
        Map<Long, UocShipOrderItem> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        Map<Long, UocImplOrderItem> implOrderItemMap = implOrderItemList.stream().collect(Collectors.toMap(UocImplOrderItem::getImplOrderItemId, o -> o));
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QRZ);
        uocChngOrderDo.setCreateOperId(operId);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setChngOrderNo(getChngOrderNo(reqBo));
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
        uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocChngOrderObj.setOrderId(reqBo.getOrderId());
        uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
//        uocChngOrderObj.setImplOrderId(reqBo.getImplOrderId());
        uocChngOrderObj.setShipOrderId(reqBo.getShipOrderId());
        uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
        uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderObj.setCreateOperId(operId);
        uocChngOrderObj.setCreateTime(now);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
        uocChngOrderObj.setChngNum(BigDecimal.ZERO);
        uocChngOrderObj.setChngFee(BigDecimal.ZERO);
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            UocShipOrderItem uocShipOrderItem = shipOrderItemMap.get(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            UocImplOrderItem uocImplOrderItem = implOrderItemMap.get(uocShipOrderItem.getImplOrderItemId());
            UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
            uocChngOrderItemObj.setChngNum(uocNumChngOrderCreateReqItemBo.getChngCount());
            uocChngOrderItemObj.setChngFee(uocNumChngOrderCreateReqItemBo.getChngCount().multiply(uocImplOrderItem.getSalePrice()));
            uocChngOrderItemObj.setChngOrderId(uocChngOrderObj.getChngOrderId());
            uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
            uocChngOrderItemObj.setShipOrderItemId(uocNumChngOrderCreateReqItemBo.getShipOrderItemId());
            uocChngOrderItemObj.setImplOrderItemId(uocShipOrderItem.getImplOrderItemId());
            uocChngOrderItemObj.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
            uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.NUM);
            uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
            uocChngOrderItemObj.setId(IdUtil.nextId());
            uocChngOrderItemObj.setCreateOperId(operId);
            uocChngOrderItemObj.setCreateTime(now);
            uocChngOrderItemObjList.add(uocChngOrderItemObj);
            uocChngOrderObj.setChngNum(uocChngOrderObj.getChngNum().add(uocNumChngOrderCreateReqItemBo.getChngCount()));
            uocChngOrderObj.setChngFee(uocChngOrderObj.getChngNum().multiply(uocImplOrderItem.getSalePrice()));
        });
        uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
        uocChngOrderObjList.add(uocChngOrderObj);
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty(reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setOrderId(uocChngOrderDo.getOrderId());
                uocChngOrderMap.setCreateOperId(operId);
                uocChngOrderMap.setCreateTime(now);
                uocChngOrderMap.setId(IdUtil.nextId());
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }

        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
            });
            uocChngOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        return uocChngOrderDo;
    }

    private String getChngOrderNo(UocNumChngOrderCreateReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "查询验收单为空");
        }

        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    /**
     * 获取发货单明细数据
     */
    private List<UocShipOrderItem> getShipOrderItemList(UocNumChngOrderCreateReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(reqBo.getChngItemList().stream().map(UocNumChngOrderCreateReqItemBo::getShipOrderItemId).collect(Collectors.toList()));
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
//        uocShipOrderItemQryBo.setImplOrderId(reqBo.getImplOrderId());
        uocShipOrderItemQryBo.setShipOrderId(reqBo.getShipOrderId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询发货单明细列表为空");
        }
        return uocShipOrderDo.getShipOrderItemBoList();
    }

    /**
     * 获取执行单明细
     */
//    private List<UocImplOrderItem> getImplOrderItemList(List<UocShipOrderItem> uocShipOrderItemList) {
//        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
//        uocImplOrderItemQryBo.setImplOrderItemIdList(uocShipOrderItemList.stream().map(UocShipOrderItem::getImplOrderItemId).distinct().collect(Collectors.toList()));
//        uocImplOrderItemQryBo.setOrderId(uocShipOrderItemList.get(0).getOrderId());
//        UocImplOrderDo uocImplOrderDo = iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
//        if (CollectionUtils.isEmpty(uocImplOrderDo.getUocImplOrderItemList())) {
//            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询执行单明细列表为空");
//        }
//        return uocImplOrderDo.getUocImplOrderItemList();
//    }
    private void validateArg(UocNumChngOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if (null == reqBo.getShipOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货单ID为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表为空");
        }
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            if (null == uocNumChngOrderCreateReqItemBo.getShipOrderItemId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参发货明细ID为空");
            }
            if (null == uocNumChngOrderCreateReqItemBo.getChngCount()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更数量为空");
            }
        });
    }
}
