package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.conforder.IUocConfOrderModel;
import com.tydic.dyc.oc.model.conforder.qrybo.UocConfButtonQryBo;
import com.tydic.dyc.oc.model.conforder.sub.UocConfButton;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题：UocProOrderButtonSettingsServiceImpl
 * 说明：订单按钮配置类相关API
 * 时间：2021/4/2 14:39
 *
 * @author tkl
 */

@HTServiceImpl
public class UocProOrderButtonSettingsServiceImpl implements UocProOrderButtonSettingsService {

    @Autowired
    private IUocConfOrderModel iUocConfOrderModel;

    @Override
    public UocProQueryOrderButtonSettingsRspBo queryOrderButtonSettings(UocProQueryOrderButtonSettingsReqBo reqBo) {
        UocProQueryOrderButtonSettingsRspBo rspBo = UocRu.success(UocProQueryOrderButtonSettingsRspBo.class);
        UocConfButtonQryBo qryBo = new UocConfButtonQryBo();
        List<UocConfButton> uocConfButtons = iUocConfOrderModel.qryConfButtonList(qryBo);
        rspBo.setRows(ObjectUtil.isNotEmpty(uocConfButtons) ? UocRu.jsl(uocConfButtons, UocProConfButtonBO.class) : new ArrayList<>());
        return rspBo;
    }

    @Override
    public UocProEditOrderButtonSettingsRspBo editOrderButtonSettings(UocProEditOrderButtonSettingsReqBo reqBo) {
        UocConfButton confButton = UocRu.js(reqBo, UocConfButton.class);
        confButton.setOperId(reqBo.getUsername());
        confButton.setOperTime(new Date());
        iUocConfOrderModel.updateConfButton(confButton);
        return UocRu.success(UocProEditOrderButtonSettingsRspBo.class);
    }

}
