package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:IUocEsSyncImplShip
 * 说明:验收单
 * 时间:2022/3/1 14:08
 * 作者:罗有
 */

@Slf4j
@Component
public class UocEsSyncInsp implements IUocEsSync {

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

//    @Autowired
//    private IUocImplOrderModel iUocImplOrderModel;

    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    private static final String ES_INSP_ORDER_ITEM_KEY = "uocInspOrderItemList";
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return uocIndexConfig.getInspOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocInspOrderDo inspOrderMain = getInspOrderMain(reqBo);
        if (null == inspOrderMain) {
            return iUocEsSyncQryRspBo;
        }
        JSONObject inspOrderJson = JSON.parseObject(JSON.toJSONString(inspOrderMain));
        if (!CollectionUtils.isEmpty(inspOrderMain.getExtParallelBoList())) {
            inspOrderMain.getExtParallelBoList().forEach(uocInspOrderMap -> inspOrderJson.put(uocInspOrderMap.getFieldCode(), uocInspOrderMap.getFieldValue()));
        }
        UocInspOrderDo inspOderItem = getInspOderItem(inspOrderMain);
        if (!CollectionUtils.isEmpty(inspOderItem.getUocInspOrderItemList())) {
            Map<Long, UocSaleOrderItem> saleItemMap = getSaleItem(inspOrderMain);
//            UocImplOrderDo implOrderItem = getListImplOrderItem(inspOderItem);
            Map<Long, UocShipOrderItem> shipOrderItemMap = getListShipOrderItem(inspOderItem);
//            Map<Long, UocImplOrderItem> uocImplOrderItemMap = implOrderItem.getUocImplOrderItemList().stream().collect(Collectors.toMap(UocImplOrderItem::getImplOrderItemId, o -> o));

            JSONArray inspOrdeItemArray = new JSONArray();
            inspOderItem.getUocInspOrderItemList().forEach(uocInspOrderItem -> {
                JSONObject inspOrderItemJson = JSON.parseObject(JSON.toJSONString(uocInspOrderItem));
                if (!CollectionUtils.isEmpty(uocInspOrderItem.getItemExtParallelBoList())) {
                    uocInspOrderItem.getItemExtParallelBoList().forEach(uocInspItemMap -> inspOrderItemJson.put(uocInspItemMap.getFieldCode(), uocInspItemMap.getFieldValue()));
                }
                putSaleItem(inspOrderItemJson, saleItemMap.get(uocInspOrderItem.getSaleOrderItemId()));
                putShipItem(inspOrderItemJson, shipOrderItemMap.get(uocInspOrderItem.getShipOrderItemId()));
                inspOrdeItemArray.add(inspOrderItemJson);
//                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_PRICE, uocImplOrderItemMap.get(uocInspOrderItem.getImplOrderItemId()).getPurchasePrice());
//                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_PRICE, uocImplOrderItemMap.get(uocInspOrderItem.getImplOrderItemId()).getSalePrice());
            });
            inspOrderJson.put(ES_INSP_ORDER_ITEM_KEY, inspOrdeItemArray);
        }
        putSaleOrder(inspOrderMain, inspOrderJson);
//        UocImplOrderDo implOrderMain = getImplOrderMain(inspOrderMain);
//        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.IMPL_ORDER_NO, null == implOrderMain ? "" : implOrderMain.getImplOrderNo());
        putShipOrder(inspOrderMain, inspOrderJson);
        putOrderRel(reqBo, inspOrderJson);
        putStr(inspOrderJson, inspOrderMain);
        iUocEsSyncQryRspBo.setJsonObj(inspOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private void putSaleOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        UocSaleOrderDo saleOrder = getSaleOrder(inspOrderMain);
        if (null != saleOrder) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_NO, saleOrder.getSaleOrderNo());
            if (null != saleOrder.getModelSettle()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.MODEL_SETTLE_STR, getDic().get(UocDicConstant.MODEL_SETTLE.P_CODE).get(saleOrder.getModelSettle().toString()));
            }
            putSaleStakeholder(saleOrder, inspOrderJson);
        }
    }

    private void putOrderRel(IUocEsSyncQryReqBo reqBo, JSONObject inspOrderJson) {
        UocOrderRel relInfo = getUocRelInfo(reqBo);
        if (null != relInfo) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_ID, relInfo.getRelId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.OBJ_ID, relInfo.getObjId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.OBJ_TYPE, relInfo.getObjType());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_TYPE, relInfo.getRelType());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_STATUS, relInfo.getRelStatus());
            if (null != relInfo.getObjType()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.OBJ_TYPE_STR, getDic().get(UocDicConstant.OBJ_TYPE.P_CODE).get(relInfo.getObjType().toString()));
            }
            if (null != relInfo.getRelType()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_TYPE_STR, getDic().get(UocDicConstant.REL_TYPE.P_CODE).get(relInfo.getRelType().toString()));
            }
            if (null != relInfo.getRelStatus()) {
                inspOrderJson.put(UocConstant.ES_MAIN_OTHER.REL_STATUS_STR, getDic().get(UocDicConstant.REL_STATUS.P_CODE).get(relInfo.getRelStatus().toString()));
            }
        }
    }

    private UocOrderRel getUocRelInfo(IUocEsSyncQryReqBo reqBo) {
        UocOrderRelQryBo qryBo = new UocOrderRelQryBo();
        qryBo.setOrderId(reqBo.getOrderId());
        qryBo.setObjId(reqBo.getObjId());
        qryBo.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        return iUocOrderModel.qryRelInfo(qryBo);
    }

    private void putStr(JSONObject inspOrderJson, UocInspOrderDo inspOrderMain) {
        Map<String, Map<String, String>> dicMap = getDic();
        Map<String, String> stateMap = dicMap.get(UocStateConstants.InspOrder.P_CODE);
        Map<String, String> checkStateMap = dicMap.get(UocDicConstant.CHECK_STATE.P_CODE);
        Map<String, String> invoiceTagMap = dicMap.get(UocDicConstant.INVOICE_TAG.P_CODE);
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INSP_ORDER_STATE_STR,
                ObjectUtil.isNotEmpty(stateMap) ? stateMap.get(inspOrderMain.getInspOrderState()) : "");
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.CHECK_STATE_STR,
                ObjectUtil.isNotEmpty(checkStateMap) ? checkStateMap.get(inspOrderMain.getCheckState()) : "");
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.INVOICE_TAG_STR,
                ObjectUtil.isNotEmpty(invoiceTagMap) ? invoiceTagMap.get(inspOrderMain.getInvoiceTag()) : "");
        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_ID,
                ObjectUtil.isNotEmpty(inspOrderJson.get(UocConstant.ES_MAIN_OTHER.SALE_ORD_ID)) ? inspOrderMain.getSaleOrderId().toString() : "");
//        inspOrderJson.put(UocConstant.ES_MAIN_OTHER.IMPL_ORDER_ID,
//                ObjectUtil.isNotEmpty(inspOrderJson.get(UocConstant.ES_MAIN_OTHER.IMPL_ORDER_ID)) ? inspOrderMain.getImplOrderId().toString() : "");
    }

    private void putShipItem(JSONObject inspOrderItemJson, UocShipOrderItem uocShipOrderItem) {
        if (null != uocShipOrderItem) {
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SEND_COUNT, uocShipOrderItem.getSendCount());
        }
    }

    private void putSaleStakeholder(UocSaleOrderDo saleOrder, JSONObject inspOrderJson) {
        UocSaleStakeholder uocSaleStakeholder = saleOrder.getStakeholder();
        if (null != uocSaleStakeholder) {
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NO, uocSaleStakeholder.getSupNo());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_ID, uocSaleStakeholder.getSupId());
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, uocSaleStakeholder.getSupName());
        }
    }

    private void putShipOrder(UocInspOrderDo inspOrderMain, JSONObject inspOrderJson) {
        List<UocShipOrderDo> uocShipOrderDoList = getListShipOrder(inspOrderMain);
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            List<String> shipOrderNoList = new ArrayList<>();
            List<String> shipOrderIdList = new ArrayList<>();
            uocShipOrderDoList.forEach(uocShipOrderDo -> {
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
            });
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_NO, shipOrderNoList.get(0));
            inspOrderJson.put(UocConstant.ES_MAIN_OTHER.SHIP_ORDER_ID, shipOrderIdList.get(0));
        }
    }

    private List<UocShipOrderDo> getListShipOrder(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setShipOrderIdList(uocInspOrderDo.getUocShipInspRelList().stream().map(UocShipInspRel::getShipOrderId).collect(Collectors.toList()));
        return iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private Map<Long, UocShipOrderItem> getListShipOrderItem(UocInspOrderDo uocInspOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getShipOrderItemId).collect(Collectors.toList()));
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
            return uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        }
        return new HashMap<>();
    }

    private Map<Long, UocSaleOrderItem> getSaleItem(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            return saleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        }
        return new HashMap<>();
    }

    private void putSaleItem(JSONObject inspOrderItemJson, UocSaleOrderItem uocSaleOrderItem) {
        if (null != uocSaleOrderItem) {
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_ID, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.COMMODITY_NAME, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_NAME, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_ID, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MAIN_PIC_URL, uocSaleOrderItem.getSkuName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_NAME, uocSaleOrderItem.getSkuMaterialName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_ID, uocSaleOrderItem.getSkuMaterialTypeId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SKU_MATERIAL_TYPE_NAME, uocSaleOrderItem.getSkuMaterialTypeName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.MODEL, uocSaleOrderItem.getModel());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SPEC, uocSaleOrderItem.getSpec());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX, uocSaleOrderItem.getTax());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX_ID, uocSaleOrderItem.getTaxId());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.TAX_PRICE, uocSaleOrderItem.getTaxPrice());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG, uocSaleOrderItem.getL1Catalog());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L1_CATALOG_NAME, uocSaleOrderItem.getL1CatalogName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG, uocSaleOrderItem.getL2Catalog());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L2_CATALOG_NAME, uocSaleOrderItem.getL2CatalogName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG, uocSaleOrderItem.getL3Catalog());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.L3_CATALOG_NAME, uocSaleOrderItem.getL3CatalogName());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SALE_PRICE, uocSaleOrderItem.getSalePrice());
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.PURCHASE_COUNT, uocSaleOrderItem.getPurchaseCount());
            if (null != uocSaleOrderItem.getSalePrice() && null != uocSaleOrderItem.getPurchaseCount()) {
                inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.INSP_SALE_MONEY, uocSaleOrderItem.getSalePrice().multiply(uocSaleOrderItem.getPurchaseCount()));
            }
            inspOrderItemJson.put(UocConstant.ES_MAIN_OTHER.SETTLE_UNIT, uocSaleOrderItem.getSettleUnit());
        }
    }

    private UocInspOrderDo getInspOderItem(UocInspOrderDo inspOrderMain) {
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderId(inspOrderMain.getInspOrderId());
        uocInspOrderItemQryBo.setOrderId(inspOrderMain.getOrderId());
        return iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
    }

    private UocInspOrderDo getInspOrderMain(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setInspOrderId(reqBo.getObjId());
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
    }

    /**
     * 查询执行单主体
     */
//    private UocImplOrderDo getImplOrderMain(UocInspOrderDo uocInspOrderDo) {
//        UocImplOrderQryBo uocImplOrderQryBo = new UocImplOrderQryBo();
//        uocImplOrderQryBo.setImplOrderId(uocInspOrderDo.getImplOrderId());
//        uocImplOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
//        return iUocImplOrderModel.getImplOrderMain(uocImplOrderQryBo);
//    }
//
//    private UocImplOrderDo getListImplOrderItem(UocInspOrderDo uocInspOrderDo) {
//        UocImplOrderItemQryBo uocImplOrderItemQryBo = new UocImplOrderItemQryBo();
//        uocImplOrderItemQryBo.setImplOrderItemIdList(uocInspOrderDo.getUocInspOrderItemList().stream().map(UocInspOrderItem::getImplOrderItemId).filter(Objects::nonNull).collect(Collectors.toList()));
//        uocImplOrderItemQryBo.setOrderId(uocInspOrderDo.getOrderId());
//        return iUocImplOrderModel.getListImplOrderItem(uocImplOrderItemQryBo);
//    }

    /**
     * 查询销售单主体
     */
    private UocSaleOrderDo getSaleOrder(UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocInspOrderDo.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    /**
     * 查询字典
     */
    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.InspOrder.P_CODE);
        pCodes.add(UocDicConstant.CHECK_STATE.P_CODE);
        pCodes.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        pCodes.add(UocDicConstant.OBJ_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REL_TYPE.P_CODE);
        pCodes.add(UocDicConstant.REL_STATUS.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }
}
