package com.tydic.dyc.oc.model.order;

import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;

import java.util.List;

/**
 * 描述 订单领域方法服务
 *
 * @author tgy
 * @date 2022/2/13 17:30
 */
public interface IUocOrderModel {

    /**
     * 描述:保存订单信息
     * @param orderDo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/22 15:10
     */
    UocOrderDo createOrder(UocOrderDo orderDo);

    /**
     * 描述:保存附件
     * @param uocOrderAccessoryList 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/22 15:10
     */
    UocOrderDo createOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList);

    /**
     * 描述:保存订单变更记录信息
     * @param uocOrderStateChgLog 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog
     * @author tkl
     * @date 2022/3/2 13:49
     */
    UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog);

    /**
     * 描述:查询
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo
     * @author tgy
     * @date 2022/2/24 19:39
     */
    List<UocOrderStakeholderQryBo> qryStakeholderList(UocOrderStakeholderQryBo qryBo);

    /**
     * 描述:查询订单任务实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst
     * @author tgy
     * @date 2022/2/24 19:39
     */
    List<UocOrderTaskInst> qryOrderTaskInstList(UocOrderTaskInstQryBo qryBo);

    /**
     * 描述:查询订单任务处理实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal
     * @author tgy
     * @date 2022/2/24 19:39
     */
    List<UocOrderTaskDeal> qryOrderTaskDealList(UocOrderTaskDealQryBo qryBo);

    /**
     * 描述:查询流程任务实例
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderProcInst
     * @author tgy
     * @date 2022/2/24 19:39
     */
    List<UocOrderProcInst> qryOrderProcInstList(UocOrderProcInstQryBo qryBo);

    /**
     * 描述:查询订单信息
     * @param uocOrderDo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/27 15:57
     */
    UocOrderDo qryOrderBy(UocOrderDo uocOrderDo);

    /**
     * 描述:查询订单明细信息
     * @param uocOrderItemQryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderItem></>
     * @author tgy
     * @date 2022/2/27 15:57
     */
    List<UocOrderItem> qryOrderItemList(UocOrderItemQryBo uocOrderItemQryBo);

    /**
     * 描述:查询收获地址信息
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela
     * @author tgy
     * @date 2022/2/27 15:57
     */
    UocOrdLogisticsRela qryOrderLogisticsRela(UocOrdLogisticsRelaQryBo qryBo);

    /**
     * 描述:查询发票信息
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrdInvoice
     * @author tgy
     * @date 2022/2/27 15:57
     */
    UocOrdInvoice qryOrderInvoice(UocOrdInvoiceQryBo qryBo);

    /**
     * 描述:查询订单附件
     *
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderAccessory
     * @author tkl
     * @date 2022/2/25 10:35
     */
    List<UocOrderAccessory> getOrderAccessoryList(UocOrderAccessoryQryBo qryBo);

    /**
     * 订单扩展查询
     *
     * @param qryBo
     * @return
     */
    List<UocOrderMap> qryOrderMapList(UocOrderMapQryBo qryBo);

    /**
     * 更新订单关联状态
     * @author wenle
     * @date 2022-04-01 15:16:26
     * @param uocOrderRel 入参
     */
    void dealRelUpdate(UocOrderRel uocOrderRel);

    /**
     * 查询关联状态
     * @author wenle
     * @date 2022-04-01 16:31:18
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderRel
     */
    UocOrderRel qryRelInfo(UocOrderRelQryBo qryBo);

    /**
     * 查询外部系统单号关联信息
     * @author tkl
     * @date 2022-04-01 16:31:18
     * @param qryBo 入参
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex></>
     */
    List<UocOrderQueryIndex> qryOrderQueryIndexList(UocOrderQueryIndexQryBo qryBo);

    /**
     * 创建关联状态
     * @author wenle
     * @date 2022-04-01 16:31:18
     * @param uocOrderRel 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderRel
     */
    void createRelInfo(UocOrderRel uocOrderRel);

    /**
     * 查询对账状态
     * @author wenle
     * @date 2022-04-01 19:50:33
     * @param qryBo 入参
     * @return com.tydic.dyc.oc.model.order.sub.UocOrderCheckAccount
     */
    UocOrderCheckAccount qryCheckInfo(UocOrderCheckAccountQryBo qryBo);

    /**
     * 新增对账状态
     * @author wenle
     * @date 2022-04-01 19:50:33
     * @param uocOrderCheckAccount 入参
     */
    void createCheckInfo(UocOrderCheckAccount uocOrderCheckAccount);

    /**
     * 更新对账状态
     * @author wenle
     * @date 2022-04-01 19:50:33
     * @param uocOrderCheckAccount 入参
     */
    void updateCheckInfo(UocOrderCheckAccount uocOrderCheckAccount);

    /**
     * 描述：修改订单及订单明细销售价
     *
     * @author: daiyuanyuan
     * @date: 2022-04-02 15:45
     */
    void modifySalePrice(UocOrderDo uocOrderDo);

    /**
     * 查询评价配置
     */
    BasePageRspBo<UocConfEvaluate> qryListPageConfEvaluate(UocConfEvaluateQryBo uocConfEvaluateQryBo);

    /**
     * 新增评价配置
     */
    void addConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 修改评价配置
     */
    void modifyConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 删除评价配置
     */
    void deleteConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 根据ID查询评价配置
     *
     * @param id
     * @return
     */
    UocConfEvaluate getConfEvaluateById(Long id);

    /**
     * 调价计算评价配置数量
     *
     * @param uocConfEvaluate
     * @return
     */
    int getCheckConfEvaluate(UocConfEvaluate uocConfEvaluate);

    /**
     * 查询页签状态列表
     *
     * @param qryBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocConfTabOrdState></>
     */
    List<UocConfTabOrdState> qryConfTabOrdStateList(UocConfTabOrdStateQryBo qryBo);

    /**
     * 订单按钮配置类查询
     *
     * @param qryBo
     * @return java.util.List<com.tydic.dyc.oc.model.order.sub.UocConfButton></>
     */
    List<UocConfButton> qryConfButtonList(UocConfButtonQryBo qryBo);

    /**
     * 订单按钮配置类更新
     *
     * @param confButton
     * @return com.tydic.dyc.oc.model.order.sub.UocConfButton
     */
    UocConfButton updateConfButton(UocConfButton confButton);

    /***
     *  删除供应商下单限额配置
     * @param confSupplierPO
     * @return
     */
    int deleteConfSupplierBy(ConfSupplierPO confSupplierPO);

    /***
     * 更新供应商下单限额配置
     * @param confSupplierPO
     * @return
     */
    int updateConfSupplierById(ConfSupplierPO confSupplierPO);

    /***
     * 查询
     * @param supNo
     * @return
     */
    ConfSupplierPO getConfSupplierModelById(long supNo);

    /***
     * 查询
     * @param confSupplierPO
     * @return
     */
    ConfSupplierPO getConfSupplierModelBy(ConfSupplierPO confSupplierPO);


    /***
     * 新增配置
     * @param confSupplierPO
     * @return
     */
    int addConfSupplier(ConfSupplierPO confSupplierPO);


}
