package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocDistSaleOrderServiceImpl
 * 说明:TODO
 * 时间:2022/4/6 10:33
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocDistSaleOrderServiceImpl implements UocDistSaleOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Override
    public UocDistSaleOrderRspBo distSaleOrder(UocDistSaleOrderReqBo reqBo) {
        // 入参校验
        validateArg(reqBo);
        // 1 查询销售单三方Id
        UocSaleOrderDo uocSaleOrderReqDo = new UocSaleOrderDo();
        uocSaleOrderReqDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderReqDo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderRspDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderReqDo);
        if (null == uocSaleOrderRspDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_RESP_GET_OBJ_NO_ERROR, "该销售单不存在");
        }
        // 2 更新协议经办人信息到三方表
        UocSaleOrderDo uocSaleOrderUpdateDo = new UocSaleOrderDo();
        UocSaleStakeholder stakeholder = new UocSaleStakeholder();
        stakeholder.setOrderId(reqBo.getOrderId());
        stakeholder.setStakeholderId(uocSaleOrderRspDo.getStakeholderId());
        stakeholder.setProDeliveryId(reqBo.getProDeliveryId());
        stakeholder.setProDeliveryName(reqBo.getProDeliveryName());
        uocSaleOrderUpdateDo.setStakeholder(stakeholder);
        iUocSaleOrderModel.modifySaleOrderStakeholder(uocSaleOrderUpdateDo);
        // 3 保存附件信息
        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryAddBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(each -> {
                each.setId(IdUtil.nextId());
                each.setObjId(reqBo.getSaleOrderId());
                each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                each.setOrderId(reqBo.getOrderId());
                each.setCreateTime(new Date());
                each.setCreateOperId(reqBo.getUserId().toString());
            });
            iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
        }
       // 4 保存扩展信息 TODO
        return UocRu.success(UocDistSaleOrderRspBo.class);
    }
    /**
     * 入参校验
     */
    private void validateArg(UocDistSaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[uocDistSaleOrderReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【userId】不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getProDeliveryId())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【proDeliveryId】不能为空");
        }
        if(StringUtils.isEmpty(reqBo.getProDeliveryName())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【proDeliveryName】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【orderId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性【saleOrderId】不能为空");
        }
    }
}
