package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocEsSyncChng
 * 说明:变更单
 * 时间:2022/3/10 14:52
 * 作者:罗有
 */

@Slf4j
@Service
public class UocEsSyncChng implements IUocEsSync {

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;

    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public String indexName() {
        return uocIndexConfig.getChngOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        IUocEsSyncQryRspBo iUocEsSyncQryRspBo = new IUocEsSyncQryRspBo();
        iUocEsSyncQryRspBo.setObjId(reqBo.getObjId());
        UocChngOrderDo chngOrder = getUocChngOrderDo(reqBo);
        if (null == chngOrder) {
            return iUocEsSyncQryRspBo;
        }
        Map<String, Map<String, String>> dicMap = getDic();
        List<UocChngOrderObj> chngOrderObjList = getChngOrderObjList(reqBo);
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            if (ObjectUtil.isNotEmpty(dicMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE)) && ObjectUtil.isNotNull(chngOrderObjList.get(0).getChngType())) {
                chngOrder.setChngTypeStr(dicMap.get(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE).get(chngOrderObjList.get(0).getChngType().toString()));
            }
            List<UocChngOrderObj> filterChngOrderObjs = chngOrderObjList.stream().filter(each -> ObjectUtil.isNotNull(each.getShipOrderId())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(filterChngOrderObjs)) {
                uocShipOrderDo = getUocShipOrderDo(filterChngOrderObjs);
                if (ObjectUtil.isNotNull(uocShipOrderDo)) {
                    chngOrder.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
                    chngOrder.setShipOrderState(uocShipOrderDo.getShipOrderState());
                    chngOrder.setInspTime(uocShipOrderDo.getInspTime());
                    chngOrder.setInspOperName(uocShipOrderDo.getInspOperName());
                    if (ObjectUtil.isNotEmpty(dicMap.get(UocStateConstants.ShipOrder.P_CODE))) {
                        chngOrder.setShipOrderStateStr(dicMap.get(UocStateConstants.ShipOrder.P_CODE).get(uocShipOrderDo.getShipOrderState()));
                    }
                    //查询发货单明细
                    uocShipOrderDo.setShipOrderItemBoList(getShipOrderItem(uocShipOrderDo).getShipOrderItemBoList());
                }
            }
        }

        chngOrder.setUocChngOrderObjList(chngOrderObjList);
        Map<String, String> chngOrderState = new HashMap<>();
        if (ObjectUtil.equal(chngOrder.getBusiType(), UocConstant.BUSI_TYPE.SALE_ORDER_CANCEL)) {
            chngOrderState = dicMap.get(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
        } else {
            chngOrderState = dicMap.get(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
        }
        log.info("dicMap:{}", JSON.toJSONString(dicMap));
        log.info(JSON.toJSONString(chngOrder));
        chngOrder.setChngOrderStateStr(chngOrderState.get(chngOrder.getChngOrderState()));
        JSONObject chngOrderJson = JSON.parseObject(JSON.toJSONString(chngOrder, SerializerFeature.WriteMapNullValue));
        if (!CollectionUtils.isEmpty(chngOrderObjList)) {
            UocSaleOrderDo saleOrder = getSaleOrder(chngOrderObjList.get(0));
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = new UocGetSaleOrderDetailServiceRspPorcBo();
            if (null != saleOrder) {
                Map<String, String> saleOrderState = dicMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE);
                saleOrder.setSaleOrderStateStr(saleOrderState.get(saleOrder.getSaleOrderState()));
                saleOrder.setPayType(saleOrderState.get(saleOrder.getSaleOrderState()));
                List<UocSaleOrderItem> uocSaleOrderItemList = getListSaleOrderItem(chngOrderObjList.get(0));
                if (ObjectUtil.isNotEmpty(uocSaleOrderItemList)
                        && ObjectUtil.isNotNull(uocShipOrderDo)
                        && ObjectUtil.isNotEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                    BigDecimal sendCount = uocShipOrderDo.getShipOrderItemBoList().get(0).getSendCount();
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_FEE, uocSaleOrderItemList.get(0).getSalePrice().multiply(sendCount));
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_FEE, uocSaleOrderItemList.get(0).getPurchasePrice().multiply(sendCount));
                }
                saleOrder.setSaleOrderItems(uocSaleOrderItemList);

                List<UocSaleOrderPayConf> saleOrderPayConfList = getUocSaleOrderPayConf(saleOrder);
                if (!CollectionUtils.isEmpty(saleOrderPayConfList)) {
                    Map<String, String> payType = dicMap.get(UocDicConstant.PAY_TYPE.P_CODE);
                    saleOrder.setSaleOrderPayConfList(saleOrderPayConfList);
                    for (UocSaleOrderPayConf uocSaleOrderPayConf : saleOrderPayConfList) {
                        if (UocDicConstant.USE_TYPE.PUR.equals(uocSaleOrderPayConf.getUserType())) {
                            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PAY_TYPE, payType.get(uocSaleOrderPayConf.getPayType().toString()));
                        }
                    }
                }
                chngOrderJson.put(UocConstant.ES_MAIN_OTHER.UOC_SALE_ORDER_ITEM, JSON.parseArray(JSON.toJSONString(saleOrder.getSaleOrderItems())));
                if (ObjectUtil.isNotEmpty(saleOrder.getStakeholder())) {
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SUP_NAME, saleOrder.getStakeholder().getSupName());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_ID, saleOrder.getStakeholder().getPurOrgId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_ORG_NAME, saleOrder.getStakeholder().getPurOrgName());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PRO_ID, saleOrder.getStakeholder().getProId());
                    chngOrderJson.put(UocConstant.ES_MAIN_OTHER.PUR_USER_ID, saleOrder.getStakeholder().getPurUserId());
                }
                //查询业务流程实例
                busiProcInst = getProcInst(saleOrder, false);

                //协议信息
                //拉横协议信息
                if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrder.getOrderSource())) {
                    //查询协议信息
                    List<UocOrderAgreement> agreementOrderList = getAgreementOrderList(reqBo);
                    //协议信息
                    if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                        putAgreementInfo(agreementOrderList, chngOrderJson);
                    }
                }
            }

            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.SALE_ORDER_INFO, saleOrder);
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_PROC_INST, ObjectUtil.isNotEmpty(busiProcInst.getProcInstId()) ? busiProcInst.getProcInstId() : "");
            chngOrderJson.put(UocConstant.ES_MAIN_OTHER.BUSI_TASK_INST, ObjectUtil.isNotEmpty(busiProcInst.getTaskList()) ? busiProcInst.getTaskList() : new ArrayList<>());
        }
        if (!CollectionUtils.isEmpty(chngOrder.getUocChngOrderMapList())) {
            chngOrder.getUocChngOrderMapList().forEach(uocChngOrderMap -> chngOrderJson.put(uocChngOrderMap.getFieldCode(), uocChngOrderMap.getFieldValue()));
        }

        iUocEsSyncQryRspBo.setJsonObj(chngOrderJson);
        return iUocEsSyncQryRspBo;
    }

    private UocChngOrderDo getUocChngOrderDo(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setChngOrderId(reqBo.getObjId());
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
        return iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
    }
    /**
     * 协议单列表查询
     *
     * @param reqBo
     * @return java.util.List<com.tydic.dyc.oc.model.saleorder.sub.UocOrderAgreement></>
     */
    private List<UocOrderAgreement> getAgreementOrderList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
        uocOrderAgreementQryBo.setSaleOrderId(reqBo.getObjId());
        return iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    /**
     * 拉横协议信息
     *
     * @param agreementOrderList
     * @param saleOrderObj
     */
    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        //协议模式
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_CODE, agreement.getAgreementCode());
        //平台协议编号
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.PLA_AGR_CODE, agreement.getPlaAgreementCode());
        //协议名称
        saleOrderObj.put(UocConstant.ES_MAIN_OTHER.AGR_NAME, agreement.getAgreementName());
    }
    private UocShipOrderDo getUocShipOrderDo(List<UocChngOrderObj> chngOrderObjList) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(chngOrderObjList.get(0).getOrderId());
        uocShipOrderQryBo.setShipOrderId(chngOrderObjList.get(0).getShipOrderId());
        UocShipOrderDo shipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
        return shipOrderDo;
    }

    private UocShipOrderDo getShipOrderItem(UocShipOrderDo uocShipOrderDo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocShipOrderItemQryBo.setOrderId(uocShipOrderDo.getOrderId());
        return iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
    }

    private List<UocChngOrderObj> getChngOrderObjList(IUocEsSyncQryReqBo reqBo) {
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderObjQryBo.setChngOrderId(reqBo.getObjId());
        return iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
    }

    private UocSaleOrderDo getSaleOrder(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderItem> getListSaleOrderItem(UocChngOrderObj uocChngOrderObj) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(uocChngOrderObj.getOrderId());
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.ShipOrder.P_CODE);
        pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        pCodes.add(UocDicConstant.PAY_TYPE.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.CHNG_ORDER_STATE.P_CODE);
        pCodes.add(UocStateConstants.ChngOrder.CHNG_TYPE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private List<UocSaleOrderPayConf> getUocSaleOrderPayConf(UocSaleOrderDo saleOrder) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(saleOrder.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(saleOrder.getSaleOrderId());
        return iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    /**
     * 查询流程任务实例
     *
     * @param reqBo
     * @param isAudit
     * @return UocGetSaleOrderDetailServiceRspPorcBo
     */
    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocSaleOrderDo reqBo, Boolean isAudit) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getSaleOrderId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            List<Integer> finishTagList = new ArrayList<>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }
}
