package com.tydic.dyc.oc.model.chngorder.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocChngOrderObjQryBo
 * 说明:变更单对象
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocChngOrderObj implements Serializable {
	private static final long serialVersionUID = 8095105689913380024L;

	@DocField(value = "变更单对象id")
	private Long chngOrderObjId;

	@DocField(value = "变更单id")
	private Long chngOrderId;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售单id")
	private Long saleOrderId;


	@DocField(value = "发货单id")
	private Long shipOrderId;

	@DocField(value = "验收单id")
	private Long inspOrderId;

	@DocField(value = "变更类型 1:状态变更 2:采购价变更 3:销售价变更 4:加价率变更")
	private Integer chngType;

	@DocField(value = "变更类型翻译")
	private String chngTypeStr;

	@DocField(value = "变更数量")
	private BigDecimal chngNum;

	@DocField(value = "变更金额")
	private BigDecimal chngFee;

	@DocField(value = "其他变更")
	private String otherChngValue;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "变更对象明细")
	private List<UocChngOrderItemObj> uocChngOrderItemObjList;
}
