package com.tydic.dyc.oc.model.common.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import org.springframework.beans.factory.annotation.Autowired;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 标题:UocCommonModelImpl
 * 说明:公共model 实现
 * 时间:2022/4/1 10:22
 * 作者:罗有
 */

@Service
public class UocCommonModelImpl implements IUocCommonModel {

    @Autowired
    private UocCommonRepository uocCommonRepository;

    /*
     * @Author lsl
     * @Description //TODO 查询供应商配置
     * @Date 18:18 2022/4/7
     * @Param [goodsSupplierNo]
     * @return com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo
     */
    @Override
    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        return uocCommonRepository.qryConfSupplier(goodsSupplierNo);
    }

    @Override
    public UocCommonDo uploadFile(UocCommonDo uocCommonDo) {
        if (null == uocCommonDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == uocCommonDo.getUocFile()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象uocFile不能为空");
        }
        if (null == uocCommonDo.getUocFile().getFilename()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[filename]不能为空");
        }
        if (null == uocCommonDo.getUocFile().getPath()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[path]不能为空");
        }
        if (null == uocCommonDo.getUocFile().getInputStream()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[inputStream]不能为空");
        }
        if (null == uocCommonDo.getUocFile().getFileType()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[fileType]不能为空");
        }
        UocFile uocFile = uocCommonRepository.uploadFile(uocCommonDo.getUocFile());
        UocCommonDo commonDo = new UocCommonDo();
        commonDo.setUocFile(uocFile);
        return commonDo;
    }
}
