package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocShouldPayCreateRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 标题：UocShouldPayCreateServiceImpl
 * 说明：订单应付单创建
 * 时间：2022/4/8 14:56
 * 作者： 周中贤
 */
@HTServiceImpl
public class UocShouldPayCreateServiceImpl implements UocShouldPayCreateService {

    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;

    /**
     * 订单应付单创建
     */
    @Override
    public UocShouldPayCreateRspBO create(UocShouldPayCreateReqBO reqBO) {
        if(reqBO == null || CollectionUtils.isEmpty(reqBO.getUocShouldPayCreateBoList())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        for (UocShouldPayCreateBo item: reqBO.getUocShouldPayCreateBoList()) {
            iUocPayOrderModel.createShouldPayOrder(UocRu.js(item, UocOrderShouldPay.class));
        }
        return UocRu.success(UocShouldPayCreateRspBO.class);
    }
}
