package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspAfsBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocAfterServiceTypeQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;

/**
 * 标题：类名称:UocAfterServiceTypeQryServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/2 11:26
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocAfterServiceTypeQryServiceImpl implements UocAfterServiceTypeQryService{
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocAfterServiceTypeQryServiceRspBo qryAfterServiceType(UocAfterServiceTypeQryServiceReqBo reqBo) {
        UocAfterServiceTypeQryServiceRspBo rspBo = UocRu.success(UocAfterServiceTypeQryServiceRspBo.class);
        rspBo.setServerTypes(new ArrayList<>());

        //参数校验
        validateArg(reqBo);
        //查询销售单明细信息
        List<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        List<Long> ordItemList = reqBo.getOrdItemList();
        for (Long saleOrderItemId : ordItemList) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setSaleOrderItemId(saleOrderItemId);
            List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
            if (CollectionUtil.isNotEmpty(saleOrderItemList)) {
                saleOrderItems.addAll(saleOrderItemList);
            }
        }
        if (CollectionUtil.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单明细对象属性为空");
        }
        Set<Integer> afTypeSet = new TreeSet<>();
        //计算售后类型
        for (UocSaleOrderItem saleOrderItem : saleOrderItems) {
            if (ObjectUtil.isNotEmpty(saleOrderItem.getRejectAllowDate())) {
                afTypeSet.add(UocConstant.AFTERORDER_SERVTYPE.RETURN);
            }
            if (ObjectUtil.isNotEmpty(saleOrderItem.getExchangeAllowDate())) {
                afTypeSet.add(UocConstant.AFTERORDER_SERVTYPE.CHANGE);
            }
            if (ObjectUtil.isNotEmpty(saleOrderItem.getMaintainAllowDate())) {
                afTypeSet.add(UocConstant.AFTERORDER_SERVTYPE.FIX);
            }
        }
        //字典查询封装数据
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocDicConstant.SERVICE_TYPE.P_CODE);
        Map<String, Map<String, String>> dicMap = iUocSysDictionaryModel.getDictionaryMap(pCodes);
        Map<String, String> serviceMaps = dicMap.get(UocDicConstant.SERVICE_TYPE.P_CODE);
        for (Integer integer : afTypeSet) {
            UocAfterServiceTypeQryServiceRspAfsBo uocAfterServiceTypeQryServiceRspAfsBo = new UocAfterServiceTypeQryServiceRspAfsBo();
            uocAfterServiceTypeQryServiceRspAfsBo.setServerType(integer);
            uocAfterServiceTypeQryServiceRspAfsBo.setServerName(serviceMaps.get(integer.toString()));
            uocAfterServiceTypeQryServiceRspAfsBo.setCanApply(Boolean.TRUE);
            rspBo.getServerTypes().add(uocAfterServiceTypeQryServiceRspAfsBo);
        }
        return rspBo;
    }

    private void validateArg(UocAfterServiceTypeQryServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocAfterServiceTypeQryServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrdItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单明细id列表]不能为空");
        }
    }
}
