/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.components.es.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.oc.components.es.IUocEsSync;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryReqBo;
import com.tydic.dyc.oc.components.es.IUocEsSyncQryRspBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderMapQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderMap;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class UocEsSyncSale
implements IUocEsSync {
    private static final Logger log = LoggerFactory.getLogger(UocEsSyncSale.class);
    public static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @Override
    public String indexName() {
        return this.uocIndexConfig.getSaleOrderIndex();
    }

    @Override
    public IUocEsSyncQryRspBo qryData(IUocEsSyncQryReqBo reqBo) {
        List<UocOrderAgreement> agreementOrderList;
        IUocEsSyncQryRspBo rspBo = new IUocEsSyncQryRspBo();
        rspBo.setObjId(reqBo.getObjId());
        UocSaleOrderDo saleOrderSubject = this.getSaleOrderSubject(reqBo);
        if (Objects.isNull(saleOrderSubject)) {
            return rspBo;
        }
        UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = this.getProcInst(reqBo, false, UocDicConstant.OBJ_TYPE.SALE);
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = this.getProcInst(reqBo, true, UocDicConstant.OBJ_TYPE.SALE);
        List<UocAuditOrderDo> auditOrderList = this.getAuditOrderList(reqBo);
        List<UocSaleOrderMap> saleOrderMapList = this.getSaleOrderMapList(reqBo);
        List<UocOrderAccessory> saleOrderAccessoryList = this.getSaleOrderAccessoryList(reqBo);
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.getSaleOrderPayConfList(reqBo);
        List<UocSaleOrderItem> saleOrderItemList = this.getSaleOrderItemList(reqBo);
        List<UocSaleItemMap> saleOrderItemMapList = this.getSaleOrderItemMapList(reqBo);
        List<UocOrderMap> orderMapList = this.getOrderMapList(reqBo.getOrderId());
        Map<Object, Object> saleItemMaps = new HashMap();
        if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
            saleItemMaps = saleOrderItemMapList.stream().collect(Collectors.groupingBy(UocSaleItemMap::getSaleOrderItemId));
        }
        saleOrderSubject.setSaleOrderPayConfList(saleOrderPayConfList);
        saleOrderSubject.setSaleOrderAccessoryList(saleOrderAccessoryList);
        JSONObject saleOrderObj = JSON.parseObject((String)JSON.toJSONString((Object)saleOrderSubject));
        if (null != saleOrderSubject.getOrderSource()) {
            saleOrderObj.put("orderSource", (Object)saleOrderSubject.getOrderSource().toString());
        }
        if (ObjectUtil.isNotEmpty(saleOrderMapList)) {
            saleOrderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        if (ObjectUtil.isNotEmpty((Object)saleOrderSubject.getStakeholder())) {
            saleOrderObj.putAll(BeanUtil.beanToMap((Object)saleOrderSubject.getStakeholder(), (boolean)false, (boolean)true));
        }
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            JSONArray saleOrdeItemArray = new JSONArray();
            ArrayList<String> skuIdList = new ArrayList<String>();
            ArrayList<String> skuNameList = new ArrayList<String>();
            ArrayList<String> commodityIdList = new ArrayList<String>();
            ArrayList<String> commodityNameList = new ArrayList<String>();
            for (UocSaleOrderItem item : saleOrderItemList) {
                List uocSaleItemMapList;
                JSONObject saleItemObj = JSON.parseObject((String)JSON.toJSONString((Object)item));
                if (ObjectUtil.isNotEmpty(saleItemMaps) && saleItemMaps.containsKey(item.getSaleOrderItemId()) && ObjectUtil.isNotEmpty((Object)(uocSaleItemMapList = (List)saleItemMaps.get(item.getSaleOrderItemId())))) {
                    uocSaleItemMapList.forEach(each -> saleItemObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
                }
                saleOrdeItemArray.add((Object)saleItemObj);
                if (ObjectUtil.isNotEmpty((Object)item.getSkuId())) {
                    skuIdList.add(item.getSkuId());
                }
                if (ObjectUtil.isNotEmpty((Object)item.getSkuName())) {
                    skuNameList.add(item.getSkuName());
                }
                if (ObjectUtil.isNotEmpty((Object)item.getCommodityId())) {
                    commodityIdList.add(item.getCommodityId());
                }
                if (!ObjectUtil.isNotEmpty((Object)item.getCommodityName())) continue;
                commodityNameList.add(item.getCommodityName());
            }
            saleOrderObj.put("saleOrderItems", (Object)saleOrdeItemArray);
            saleOrderObj.put("skuName", skuNameList);
            saleOrderObj.put("skuId", skuIdList);
            saleOrderObj.put("commodityId", commodityIdList);
            saleOrderObj.put("commodityName", commodityNameList);
            saleOrderObj.put("auditOrderBoList", auditOrderList);
            saleOrderObj.put("busiProcInstId", (Object)busiProcInst.getProcInstId());
            saleOrderObj.put("auditProcInstId", (Object)auditProcInst.getProcInstId());
            saleOrderObj.put("busiTaskList", (Object)busiProcInst.getTaskList());
            saleOrderObj.put("auditTaskList", (Object)auditProcInst.getTaskList());
        }
        if (ObjectUtil.isNotEmpty(orderMapList)) {
            orderMapList.forEach(each -> saleOrderObj.put(each.getFieldCode(), (Object)each.getFieldValue()));
        }
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderSubject.getOrderSource()) && ObjectUtil.isNotEmpty(agreementOrderList = this.getAgreementOrderList(saleOrderSubject))) {
            this.putAgreementInfo(agreementOrderList, saleOrderObj);
        }
        this.putShipInfo(saleOrderObj, reqBo);
        this.putInspInfo(saleOrderObj, reqBo);
        rspBo.setJsonObj(saleOrderObj);
        this.translateProperties(rspBo);
        log.info("\u9500\u552e\u5355es\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)rspBo));
        return rspBo;
    }

    private void putAgreementInfo(List<UocOrderAgreement> agreementOrderList, JSONObject saleOrderObj) {
        UocOrderAgreement agreement = agreementOrderList.get(0);
        saleOrderObj.put("agreementCode", (Object)agreement.getAgreementCode());
        saleOrderObj.put("plaAgreementCode", (Object)agreement.getPlaAgreementCode());
        saleOrderObj.put("agreementName", (Object)agreement.getAgreementName());
    }

    private List<UocOrderAgreement> getAgreementOrderList(UocSaleOrderDo saleOrderSubject) {
        UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
        uocOrderAgreementQryBo.setOrderId(saleOrderSubject.getOrderId());
        uocOrderAgreementQryBo.setId(saleOrderSubject.getAgrDataId());
        return this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
    }

    private static void initialize() {
        pCodeList.add("UOC_SALE_ORDER_STATE");
        pCodeList.add("UOC_SALE_ORDER_SOURCE");
        pCodeList.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodeList.add("UOC_SALE_ORDER_PAY_STATE");
        pCodeList.add("UOC_COMMON_FINISH_FLAG");
        pCodeList.add("UOC_COMMON_CANCEL_FLAG");
        pCodeList.add("UOC_COMMON_MODEL_SETTLE");
        pCodeList.add("UOC_COMMON_PURCHASE_TYPE");
        pCodeList.add("UOC_COMMON_PURCHASE_MODE");
        pCodeList.add("UOC_COMMON_ITEM_TYPE");
        pCodeList.add("UOC_ORD_AGREEMENT_MODE");
    }

    private void translateProperties(IUocEsSyncQryRspBo rspBo) {
        JSONObject jsonObj = rspBo.getJsonObj();
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            List<UocSaleOrderItem> saleOrderItems;
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"saleOrderState"))) {
                String saleOrdStateCode = jsonObj.getString("saleOrderState");
                jsonObj.put("saleOrderStateStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_STATE").get(saleOrdStateCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_SOURCE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"orderSource"))) {
                String ordSourceCode = jsonObj.getString("orderSource");
                jsonObj.put("orderSourceStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_SOURCE").get(ordSourceCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"payState"))) {
                String payStateCode = jsonObj.getString("payState");
                jsonObj.put("payStateStr", (Object)dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE").get(payStateCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_FINISH_FLAG")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"finishFlag"))) {
                String finishFlagCode = jsonObj.getString("finishFlag");
                jsonObj.put("finishFlagStr", (Object)dictionaryMap.get("UOC_COMMON_FINISH_FLAG").get(finishFlagCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_CANCEL_FLAG")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"cancelFlag"))) {
                String cancelFlagCode = jsonObj.getString("cancelFlag");
                jsonObj.put("cancelFlagStr", (Object)dictionaryMap.get("UOC_COMMON_CANCEL_FLAG").get(cancelFlagCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"modelSettle"))) {
                String modelSettleCode = jsonObj.getString("modelSettle");
                jsonObj.put("modelSettleStr", (Object)dictionaryMap.get("UOC_COMMON_MODEL_SETTLE").get(modelSettleCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"purchaseType"))) {
                String purchaseTypeCode = jsonObj.getString("purchaseType");
                jsonObj.put("purchaseTypeStr", (Object)dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE").get(purchaseTypeCode));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_MODE")) && ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"purchaseMode"))) {
                String purchaseModeCode = jsonObj.getString("purchaseMode");
                jsonObj.put("purchaseModeStr", (Object)dictionaryMap.get("UOC_COMMON_PURCHASE_MODE").get(purchaseModeCode));
            }
            List<Object> payConfList = new ArrayList();
            if (ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"saleOrderPayConfList")) && ObjectUtil.isNotEmpty(payConfList = UocRu.jsl(jsonObj.get((Object)"saleOrderPayConfList"), UocSaleOrderPayConf.class))) {
                payConfList.forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getPayType())) {
                        each.setPayTypeStr((String)((Map)dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE")).get(each.getPayType().toString()));
                    }
                });
            }
            jsonObj.put("saleOrderPayConfList", (Object)JSON.parseArray((String)JSON.toJSONString(payConfList)));
            if (ObjectUtil.isNotEmpty((Object)jsonObj.get((Object)"saleOrderItems")) && ObjectUtil.isNotEmpty(saleOrderItems = UocRu.jsl(jsonObj.get((Object)"saleOrderItems"), UocSaleOrderItem.class))) {
                saleOrderItems.forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getItemType())) {
                        each.setItemTypeStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_TYPE")).get(each.getItemType().toString()));
                    }
                });
                jsonObj.put("saleOrderItems", (Object)JSON.parseArray((String)JSON.toJSONString(saleOrderItems)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotNull((Object)jsonObj.get((Object)"isArrivalRegist"))) {
                boolean isArrivalRegist = jsonObj.getBooleanValue("isArrivalRegist");
                jsonObj.put("isArrivalRegistStr", (Object)(isArrivalRegist ? "\u662f" : "\u5426"));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_AGREEMENT_MODE")) && ObjectUtil.isNotNull((Object)jsonObj.get((Object)"agreementCode"))) {
                String agreementCode = jsonObj.getString("agreementCode");
                jsonObj.put("agreementCodeStr", (Object)dictionaryMap.get("UOC_ORD_AGREEMENT_MODE").get(agreementCode));
            }
        }
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(IUocEsSyncQryReqBo reqBo, Boolean isAudit, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        if (isAudit.booleanValue()) {
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
        } else {
            procInstQryBo.setObjId(reqBo.getObjId());
            procInstQryBo.setObjType(objType);
        }
        procInstQryBo.setOrderId(reqBo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            procInst = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class).get(0);
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setObjId(procInst.getObjId());
            taskInstQryBo.setObjType(procInst.getObjType());
            ArrayList<Integer> finishTagList = new ArrayList<Integer>();
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
            finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
            taskInstQryBo.setFinishTagList(finishTagList);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setProcState(uocOrderTaskInsts.get(0).getProcState());
                procInst.setTaskId(uocOrderTaskInsts.get(0).getTaskInstId());
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private void putInspInfo(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocInspOrderDo> inspOrderList = this.getInspOrderList(reqBo);
        ArrayList inspOrderIdList = new ArrayList();
        ArrayList inspOrderNoList = new ArrayList();
        inspOrderList.forEach(uocInspOrderDo -> {
            if (null != uocInspOrderDo.getInspOrderId()) {
                inspOrderIdList.add(uocInspOrderDo.getInspOrderId().toString());
            }
            inspOrderNoList.add(uocInspOrderDo.getInspOrderNo());
        });
        saleOrderObj.put("inspOrderId", inspOrderIdList);
        saleOrderObj.put("inspOrderNo", inspOrderNoList);
    }

    private void putShipInfo(JSONObject saleOrderObj, IUocEsSyncQryReqBo reqBo) {
        List<UocShipOrderItem> shipOrderItemList;
        List<UocShipOrderDo> shipOrderList = this.getShipOrderList(reqBo);
        if (!CollectionUtils.isEmpty(shipOrderList)) {
            ArrayList shipOrderIdList = new ArrayList();
            ArrayList shipOrderNoList = new ArrayList();
            ArrayList shipOrderStateList = new ArrayList();
            shipOrderList.forEach(uocShipOrderDo -> {
                if (null != uocShipOrderDo.getShipOrderId()) {
                    shipOrderIdList.add(uocShipOrderDo.getShipOrderId().toString());
                }
                shipOrderNoList.add(uocShipOrderDo.getShipOrderNo());
                shipOrderStateList.add(uocShipOrderDo.getShipOrderState());
            });
            boolean isArrivalRegist = false;
            for (UocShipOrderDo uocShipOrderDo2 : shipOrderList) {
                if (!"FH_FH_FH".equals(uocShipOrderDo2.getShipOrderState())) continue;
                isArrivalRegist = true;
                break;
            }
            saleOrderObj.put("shipOrderId", shipOrderIdList);
            saleOrderObj.put("shipOrderNo", shipOrderNoList);
            saleOrderObj.put("isArrivalRegist", (Object)isArrivalRegist);
            saleOrderObj.put("shipOrderState", shipOrderStateList);
            List<UocOrderTaskInst> taskInst = this.getTaskInst(reqBo.getOrderId(), shipOrderIdList.stream().mapToLong(Long::parseLong).boxed().collect(Collectors.toList()));
            List<Object> procStateList = new ArrayList();
            if (!CollectionUtils.isEmpty(taskInst)) {
                procStateList = taskInst.stream().map(UocOrderTaskInst::getProcState).collect(Collectors.toList());
            }
            saleOrderObj.put("shipOrderTacheCode", procStateList);
        }
        if (ObjectUtil.isNotEmpty(shipOrderItemList = this.getListShipOrderItem(reqBo))) {
            saleOrderObj.put("sendCount", (Object)shipOrderItemList.get(0).getSendCount());
            saleOrderObj.put("refuseCount", (Object)shipOrderItemList.get(0).getRefuseCount());
        }
    }

    private List<UocAuditOrderDo> getAuditOrderList(IUocEsSyncQryReqBo reqBo) {
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<UocAuditOrderDo>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocAuditOrder> uocAuditOrders = this.iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            uocAuditOrderDoList.forEach(each -> {
                UocApprovalObj obj = new UocApprovalObj();
                obj.setAuditOrderId(each.getAuditOrderId());
                obj.setOrderId(each.getOrderId());
                each.setApprovalObjs(this.iUocAuditOrderModel.qryApprovealObj(obj));
            });
        }
        return uocAuditOrderDoList;
    }

    private UocSaleOrderDo getSaleOrderSubject(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
        uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
    }

    private List<UocSaleOrderMap> getSaleOrderMapList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = new UocSaleOrderMapQryBo();
        uocSaleOrderMapQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderMapQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
    }

    private List<UocOrderAccessory> getSaleOrderAccessoryList(IUocEsSyncQryReqBo reqBo) {
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = UocRu.js(reqBo, UocOrderAccessoryQryBo.class);
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        return this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
    }

    private List<UocSaleOrderPayConf> getSaleOrderPayConfList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(IUocEsSyncQryReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getObjId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
    }

    private List<UocSaleItemMap> getSaleOrderItemMapList(IUocEsSyncQryReqBo reqBo) {
        UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
        uocSaleItemMapQryBo.setSaleOrderId(reqBo.getObjId());
        uocSaleItemMapQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
    }

    private List<UocShipOrderDo> getShipOrderList(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private List<UocShipOrderItem> getListShipOrderItem(IUocEsSyncQryReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getObjId());
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        return ObjectUtil.isNotNull((Object)uocShipOrderDo) ? uocShipOrderDo.getShipOrderItemBoList() : new ArrayList<UocShipOrderItem>();
    }

    private List<UocInspOrderDo> getInspOrderList(IUocEsSyncQryReqBo reqBo) {
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getObjId());
        return this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
    }

    private List<UocOrderTaskInst> getTaskInst(Long orderId, List<Long> objIdList) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjIdList(objIdList);
        taskInstQryBo.setOrderId(orderId);
        taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
        ArrayList<Integer> finishTagList = new ArrayList<Integer>();
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        finishTagList.add(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
        taskInstQryBo.setFinishTagList(finishTagList);
        return this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
    }

    private List<UocOrderMap> getOrderMapList(Long orderId) {
        UocOrderMapQryBo uocOrderMapQryBo = new UocOrderMapQryBo();
        uocOrderMapQryBo.setOrderId(orderId);
        return this.iUocOrderModel.qryOrderMapList(uocOrderMapQryBo);
    }

    static {
        UocEsSyncSale.initialize();
    }
}

