/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocAuditAdjustPriceOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditAdjustPriceOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocAuditAdjustPriceOrderRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocAuditAdjustPriceOrderService"})
public class UocAuditAdjustPriceOrderServiceImpl
implements UocAuditAdjustPriceOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @PostMapping(value={"dealAdjustPriceOrder"})
    public UocAuditAdjustPriceOrderRspBo dealAdjustPriceOrder(@RequestBody UocAuditAdjustPriceOrderReqBo reqBo) {
        this.validateArg(reqBo);
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderItemObjQryBo.setChngOrderId(reqBo.getChngOrderId());
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u660e\u7ec6\u5bf9\u8c61\u4e3a\u7a7a");
        }
        this.updateSaleOrderDomainSalePrice(reqBo, uocChngOrderItemObjList);
        this.updateOrderDomainSalePrice(reqBo, uocChngOrderItemObjList);
        UocAuditAdjustPriceOrderRspBo uocAdjustPriceOrderCreateRspBo = UocRu.success(UocAuditAdjustPriceOrderRspBo.class);
        return uocAdjustPriceOrderCreateRspBo;
    }

    private void updateOrderDomainSalePrice(UocAuditAdjustPriceOrderReqBo reqBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        ArrayList<UocOrderItem> orderItems = new ArrayList<UocOrderItem>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            UocOrderItem uocOrderItem = new UocOrderItem();
            uocOrderItem.setOrderId(reqBo.getOrderId());
            uocOrderItem.setOrderItemId(uocChngOrderItemObj.getOrderItemId());
            uocOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
            uocOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
            uocOrderItem.setUpdateTime(updateTime);
            orderItems.add(uocOrderItem);
            uocOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
            uocOrderDo.setUpdateTime(updateTime);
        });
        uocOrderDo.setOrderItems(orderItems);
        this.iUocOrderModel.modifySalePrice(uocOrderDo);
    }

    private void updateSaleOrderDomainSalePrice(UocAuditAdjustPriceOrderReqBo reqBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        ArrayList<UocSaleOrderItem> saleOrderItems = new ArrayList<UocSaleOrderItem>();
        Date updateTime = new Date();
        uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setOrderId(reqBo.getOrderId());
            uocSaleOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderItem.setSaleOrderItemId(uocChngOrderItemObj.getSaleOrderItemId());
            uocSaleOrderItem.setSalePrice(uocChngOrderItemObj.getChngFee());
            uocSaleOrderItem.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
            uocSaleOrderItem.setUpdateTime(updateTime);
            saleOrderItems.add(uocSaleOrderItem);
            uocSaleOrderDo.setUpdateOperId(uocChngOrderItemObj.getCreateOperId());
            uocSaleOrderDo.setUpdateTime(updateTime);
        });
        uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
        this.iUocSaleOrderModel.modifySalePrice(uocSaleOrderDo);
    }

    private void validateArg(UocAuditAdjustPriceOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (reqBo.getChngOrderId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u5355ID\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
    }
}

