package com.tydic.dyc.oc.model.aforder.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocObjNoConstants;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.utils.IdUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * 标题:UocAfOrderModelImpl
 * 说明:售后单
 * 时间:2022/3/8 18:10
 * 作者:罗有
 */

@Service
public class UocAfOrderModelImpl implements IUocAfOrderModel {
    @Autowired
    private UocAfOrderRepository uocAfOrderRepository;
    @Autowired
    private UocCommonRepository uocCommonRepository;
    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        if (ObjectUtil.isNull(uocAfOrderItemQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemList(uocAfOrderItemQryBo);
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderById(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        if (ObjectUtil.isNull(uocAfOrderQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderList(uocAfOrderQryBo);
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        if (ObjectUtil.isNull(uocAfOrderObjQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderObjList(uocAfOrderObjQryBo);
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        if (ObjectUtil.isNull(uocAfOrderMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderMapList(uocAfOrderMapQryBo);
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        if (ObjectUtil.isNull(uocAfOrderWaybillQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderWayBillList(uocAfOrderWaybillQryBo);
    }

    @Override
    public UocAfOrderDo dealPebTheZoneAfterApplication(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNull(afOrderDo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        afOrderDo.setAfOrderId(IdUtil.nextId());
        UocAfOrderDo afterOrderNo = getAfterOrderNo(new UocAfOrderDo());
        afOrderDo.setAfServCode(afterOrderNo.getAfServCode());
        List<UocAfOrderMap> extParallelBoList = afOrderDo.getExtParallelBoList();
        if (ObjectUtil.isNotEmpty(extParallelBoList)) {
            for (UocAfOrderMap uocAfOrderMap : extParallelBoList) {
                uocAfOrderMap.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderMap.setId(IdUtil.nextId());
            }
        }
        UocOrdLogisticsRela takeAddress = afOrderDo.getTakeAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            takeAddress.setContactId(IdUtil.nextId());
            takeAddress.setOrderId(afOrderDo.getOrderId());
            takeAddress.setCreateTime(new Date());
            afOrderDo.setContactId(takeAddress.getContactId());
        }
        UocOrdLogisticsRela returnAddress = afOrderDo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            returnAddress.setContactId(IdUtil.nextId());
            returnAddress.setOrderId(afOrderDo.getOrderId());
            returnAddress.setCreateTime(new Date());
            afOrderDo.setTpContactId(takeAddress.getContactId());
        }
        List<UocAfOrderObj> afOrderObjList = afOrderDo.getAfOrderObjList();
        if (ObjectUtil.isNotEmpty(afOrderObjList)) {
            for (UocAfOrderObj uocAfOrderObj : afOrderObjList) {
                uocAfOrderObj.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderObj.setId(IdUtil.nextId());
            }
        }
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        if (ObjectUtil.isNotEmpty(afOrderItemBoList)) {
            for (UocAfOrderItem uocAfOrderItem : afOrderItemBoList) {
                uocAfOrderItem.setAfOrderId(afOrderDo.getAfOrderId());
                uocAfOrderItem.setAfOrderItemId(IdUtil.nextId());
            }
        }
        List<UocOrderAccessory> orderAccessoryBoList = afOrderDo.getOrderAccessoryBoList();
        if (ObjectUtil.isNotEmpty(orderAccessoryBoList)) {
            for (UocOrderAccessory uocOrderAccessory : orderAccessoryBoList) {
                uocOrderAccessory.setOrderId(afOrderDo.getOrderId());
                uocOrderAccessory.setObjId(afOrderDo.getAfOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.AFTER);
                uocOrderAccessory.setCreateTime(new Date());
                uocOrderAccessory.setCreateOperId(afOrderDo.getCreateOperId());
                uocOrderAccessory.setId(IdUtil.nextId());
            }
        }
        return uocAfOrderRepository.saveAfterOder(afOrderDo);
    }

    @Override
    public UocAfOrderDo getAfterOrderNo(UocAfOrderDo afOrderDo) {
        if (null == afOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        String orderNo = uocCommonRepository.getOrderNoSingle(UocObjNoConstants.ORDER_AS_NO);
        afOrderDo.setAfServCode(orderNo);
        return afOrderDo;
    }

    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        if (ObjectUtil.isNull(uocAfItemMapQryBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        return uocAfOrderRepository.getAfOrderItemMapList(uocAfItemMapQryBo);
    }

    @Override
    public void updateBatchAfOrderMain(List<UocAfOrderDo> afOrderDos) {
        if (ObjectUtil.isNotEmpty(afOrderDos)) {
            uocAfOrderRepository.modifyBatchAfOrderRemark(afOrderDos);
        }
    }

    @Override
    public void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo) {
        if (ObjectUtil.isNotEmpty(afOrderDo)) {
            uocAfOrderRepository.modifyAfOrderExtOrderId(afOrderDo);
        }
    }

    @Override
    public void addWayBill(UocAfOrderWaybill uocAfOrderWaybill) {
        if (ObjectUtil.isNotEmpty(uocAfOrderWaybill)) {
            uocAfOrderWaybill.setId(IdUtil.nextId());
            uocAfOrderRepository.saveAfOrderWayBill(uocAfOrderWaybill);
        }
    }
}
