package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessor;
import com.tydic.dyc.oc.components.ordSourceProcessor.UocOrderSourceProcessorManager;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderStakeholderQryBo;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocCreateOrderServiceImpl
 * 说明:订单和销售单创建
 * 时间:2022/2/22 14:15
 * 作者:田桂银
 */
@HTServiceImpl
public class UocCreateOrderServiceImpl implements UocCreateOrderService {

    //订单领域方法对象
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private UocOrderSourceProcessorManager uocOrderSourceProcessorManager;


    @Override
    public UocCreateOrderServiceRspBo createOrder(UocCreateOrderServiceReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        UocCreateOrderServiceRspBo rspBo = UocRu.success(UocCreateOrderServiceRspBo.class);

        //bo转订单do
        UocOrderDo createDo = convertOrderDo(reqBo);

        //创建订单
        UocOrderDo createOrderRet = iUocOrderModel.createOrder(createDo);
        rspBo.setTotalSaleFee(createDo.getTotalSaleFee());
        rspBo.setTotalPurchaseFee(createDo.getTotalPurchaseFee());
        rspBo.setSaleOrderList(new ArrayList<>());

        //供应商签约信息
        JSONObject supSignInfo = reqBo.getJsonObj();

        //创建销售单
        if (reqBo.getCreateSaleOrder()) {
            //订单明细转销售单明细(根据销售单明细进行拆单)
            List<UocSaleOrderItem> uocSaleOrderItemList = orderDo2SaleDo(createOrderRet, reqBo);

            //拆单
            List<UocSaleOrderDo> splitSaleOrderList = splitSaleOrder(createOrderRet, reqBo, uocSaleOrderItemList, supSignInfo);

            for (UocSaleOrderDo saleOrderDo : splitSaleOrderList) {
                //创建销售单
                UocSaleOrderDo saleOrderRet = iUocSaleOrderModel.createSaleOrder(saleOrderDo);

                //设置出参
                UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
                BeanUtils.copyProperties(saleOrderRet, orderItemRspData);
                BeanUtils.copyProperties(saleOrderRet.getStakeholder(), orderItemRspData);
                orderItemRspData.setSaleOrderId(saleOrderRet.getSaleOrderId());
                List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrderRet.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
                orderItemRspData.setItemBoList(itemList);
                orderItemRspData.setSaleOrderNo(saleOrderRet.getSaleOrderNo());
                orderItemRspData.setOrderSource(saleOrderRet.getOrderSource());
                orderItemRspData.setAgrId(saleOrderRet.getAgreementId());
                rspBo.getSaleOrderList().add(orderItemRspData);
            }

            //拆单
            /*List<UocSaleOrderDo> saleOrderList = splitOrder(createOrderRet, reqBo);

            for (UocSaleOrderDo saleOrderDo : saleOrderList) {
                // 是否在下单的时候生成成交服务费
                JSONObject supSignInfoJSONObject = supSignInfo.getJSONObject(saleOrderDo.getStakeholder().getSupId());
                if ( UocConstant.CREATE_ORDER_CHARGE_SERVICE_FEE.equals(supSignInfoJSONObject.getString("monthReceiveNode"))) {
                    saleOrderDo.setIsCreateServiceFee(true);
                }
                //创建销售单
                UocSaleOrderDo saleOrderRet = iUocSaleOrderModel.createSaleOrder(saleOrderDo);

                //创建执行单
//                UocImplOrderDo uocImplOrderDo = UocRu.js(saleOrderRet, UocImplOrderDo.class);
//                uocImplOrderDo.setUocImplOrderItemList(UocRu.jsl(saleOrderRet.getSaleOrderItems(), UocImplOrderItem.class));
//                UocImplOrderDo implOrderRet = iUocImplOrderModel.createImplOrder(uocImplOrderDo);

                //设置出参
                UocCreateOrderServiceRspSaleOrderBo orderItemRspData = new UocCreateOrderServiceRspSaleOrderBo();
                BeanUtils.copyProperties(saleOrderRet, orderItemRspData);
                BeanUtils.copyProperties(saleOrderRet.getStakeholder(), orderItemRspData);
                orderItemRspData.setSaleOrderId(saleOrderRet.getSaleOrderId());
//                orderItemRspData.setImplOrderId(implOrderRet.getImplOrderId());
                List<UocCreateOrderServiceRspSaleOrderItemBo> itemList = UocRu.jsl(saleOrderRet.getSaleOrderItems(), UocCreateOrderServiceRspSaleOrderItemBo.class);
                orderItemRspData.setItemBoList(itemList);
                orderItemRspData.setSaleOrderNo(saleOrderRet.getSaleOrderNo());
                orderItemRspData.setOrderSource(saleOrderRet.getOrderSource());
                rspBo.getSaleOrderList().add(orderItemRspData);
            }*/
        }

        rspBo.setOrderId(createDo.getOrderId());
        return rspBo;
    }

    private List<UocSaleOrderDo> splitSaleOrder(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo, List<UocSaleOrderItem> uocSaleOrderItemList, JSONObject supSignInfo) {
        List<UocSaleOrderDo> splitSaleOrderList = new ArrayList<>();
        List<List<UocSaleOrderItem>> splitSaleOrderRet = new ArrayList<>();
        //先根据订单来源拆分数据，由不同订单来源实现类进行处理
        Map<Integer, List<UocSaleOrderItem>> saleItemMap = uocSaleOrderItemList.stream().collect(Collectors.groupingBy(UocSaleOrderItem::getSkuSource));
        for (Map.Entry<Integer, List<UocSaleOrderItem>> entry : saleItemMap.entrySet()) {
            UocOrderSourceProcessor instance = uocOrderSourceProcessorManager.getInstance(entry.getKey());
            //拆单结果
            splitSaleOrderRet.addAll(instance.splitSaleOrder(entry.getValue()));
        }

        UocOrderStakeholderQryBo qryStakeholderList = new UocOrderStakeholderQryBo();
        qryStakeholderList.setOrderId(createOrderRet.getOrderId());

        //根据订单id查询已入库的三方信息,并组成map，便于后续使用
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = iUocOrderModel.qryStakeholderList(qryStakeholderList);
        Map<String, List<UocOrderStakeholderQryBo>> supStakeMap = uocOrderStakeholderQryBos.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));

        //支付配置保存
        List<UocCreateOrderServiceReqPayConfSupBo> payConfigList = reqBo.getPayConfigList();
        Map<String, UocCreateOrderServiceReqPayConfSupBo> payConfMap = new HashMap<>();
        if(ObjectUtil.isNotEmpty(payConfigList)){
            payConfMap = payConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqPayConfSupBo::getSupId, item -> item));
        }

        List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList = reqBo.getAgrPayConfigList();
        Map<String, UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigMap = new HashMap<>();
        if(ObjectUtil.isNotEmpty(agrPayConfigMap)){
            agrPayConfigMap = agrPayConfigList.stream().collect(Collectors.toMap(UocCreateOrderServiceReqArgPayConfSupBo::getAgrId, item -> item));
        }

        //把保存的协议数据转换成map，方便后续取用
        List<UocOrderItem> orderItems = createOrderRet.getOrderItems();
        List<UocOrderAgreement> agrList = orderItems.stream().map(UocOrderItem::getAgrBo).collect(Collectors.toList());
        //是否有协议商品
        boolean hasAgrComm = false;
        for (UocOrderItem orderItem : orderItems) {
            if(ObjectUtil.isNotEmpty(orderItem.getAgrBo())){
                hasAgrComm = true;
            }
        }
        Map<String, UocOrderAgreement> agrMap = new HashMap<>();
        if(hasAgrComm){
            agrMap = agrList.stream().collect(Collectors.toMap(UocOrderAgreement::getAgreementId, item -> item));
        }

        //至此，拆单执行完毕，根据拆单结果（多个list），组装销售单do对象
        for (List<UocSaleOrderItem> uocSaleOrderItems : splitSaleOrderRet) {
            UocSaleOrderDo saleOrderDo = UocRu.js(createOrderRet, UocSaleOrderDo.class);
            splitSaleOrderList.add(saleOrderDo);
            String supplierId = uocSaleOrderItems.get(0).getSupplierId();
            saleOrderDo.setOrderSource(uocSaleOrderItems.get(0).getSkuSource());
            saleOrderDo.setOrderId(createOrderRet.getOrderId());
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());
            saleOrderDo.setStakeholderId(supStakeMap.get(supplierId).get(0).getStakeholderId());
            saleOrderDo.setStakeholder(UocRu.js(supStakeMap.get(supplierId).get(0), UocSaleStakeholder.class));
            saleOrderDo.setTotalSaleFee(getTotalSaleFeeWithSaleItem(uocSaleOrderItems));
            saleOrderDo.setTotalPurchaseFee(getTotalPurchaseFeeWithSaleItem(uocSaleOrderItems));
            saleOrderDo.setSendTime(createOrderRet.getSendTime());
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());
            //协议id
            String agreementId = uocSaleOrderItems.get(0).getAgreementId();


            // 供应商收取月度成交服务费节点
            String monthReceiveNode = supSignInfo.getJSONObject(supplierId).getString(UocConstant.MONTH_SERVICE_NODE_PARAM);
            // 如果是下单时收取 设置生成结算订单管理数据
            if ( UocConstant.MONTH_SERVICE_NODE.equals(monthReceiveNode) ) {
                saleOrderDo.setIsCreateServiceFee(true);
            }
            if (ObjectUtil.isNotEmpty(agreementId)) {
                //支付配置
                saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(agrPayConfigMap.get(agreementId).getConfBos(), UocSaleOrderPayConf.class));
                //如果一个供应商下只有一个配置，则是撮合模式，反之：贸易模式
                saleOrderDo.setModelSettle(agrPayConfigMap.get(agreementId).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
            } else {
                //支付配置
                saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(payConfMap.get(supplierId).getConfBos(), UocSaleOrderPayConf.class));
                //如果一个供应商下只有一个配置，则是撮合模式，反之：贸易模式
                saleOrderDo.setModelSettle(payConfMap.get(supplierId).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
            }


            //销售明细
            saleOrderDo.setSaleOrderItems(uocSaleOrderItems);

            //设置协议数据
            if (ObjectUtil.isNotEmpty(agreementId)) {
                saleOrderDo.setAgreementId(agreementId);
                saleOrderDo.setAgreementNo(uocSaleOrderItems.get(0).getAgreementNo());
                saleOrderDo.setAgrDataId(agrMap.get(agreementId).getId());
            }
        }

        return splitSaleOrderList;

    }

    private List<UocSaleOrderItem> orderDo2SaleDo(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo) {
        List<UocOrderItem> orderItems = createOrderRet.getOrderItems();

        List<UocSaleOrderItem> saleOrderItemList = new ArrayList<>();
        for (UocOrderItem orderItem : orderItems) {
            UocSaleOrderItem saleItemDo = UocRu.js(orderItem, UocSaleOrderItem.class);
            saleOrderItemList.add(saleItemDo);
        }

        return saleOrderItemList;
    }

    private List<UocSaleOrderDo> splitOrder(UocOrderDo createOrderRet, UocCreateOrderServiceReqBo reqBo) {
        List<UocSaleOrderDo> saleOrderDoList = new ArrayList<>();
        UocOrderStakeholderQryBo qryStakeholderList = new UocOrderStakeholderQryBo();
        qryStakeholderList.setOrderId(createOrderRet.getOrderId());

        //根据订单id查询已入库的三方信息,并组成map，便于后续使用
        List<UocOrderStakeholderQryBo> uocOrderStakeholderQryBos = iUocOrderModel.qryStakeholderList(qryStakeholderList);
        Map<String, List<UocOrderStakeholderQryBo>> supStakeMap = uocOrderStakeholderQryBos.stream().collect(Collectors.groupingBy(UocOrderStakeholderQryBo::getSupId));

        //根据skuSource分别处理，本次poc只处理无协议商品
        Map<Integer, List<UocOrderItem>> orderItemMap = createOrderRet.getOrderItems().stream().collect(Collectors.groupingBy(UocOrderItem::getSkuSource));
        List<UocOrderItem> uocOrderItems = orderItemMap.get(UocConstant.SkuSource.SELF);

        //拆单后数据，用于创建销售订单
        List<List<UocOrderItem>> splitOrderItemList = new ArrayList<>();

        //根据供应商拆单
        Map<String, List<UocOrderItem>> supMap = uocOrderItems.stream().collect(Collectors.groupingBy(UocOrderItem::getSupplierId));

        for (String supId : supMap.keySet()) {
            //根据是否计划商品，分成两组（计划和非计划，计划的再按计划编号拆一次），分别进行生成销售单，最终得到结果是，同一供应商下：非计划 + 各计划的List
            List<UocOrderItem> noPlanList = supMap.get(supId).stream().filter(item -> item.getPlanId() == null).collect(Collectors.toList());
            List<UocOrderItem> planList = supMap.get(supId).stream().filter(item -> item.getPlanId() != null).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(noPlanList)) {
                splitOrderItemList.add(noPlanList);
            }
            if (ObjectUtil.isNotEmpty(planList)) {
                splitOrderItemList.addAll(planList.stream().collect(Collectors.groupingBy(UocOrderItem::getPlanNo)).values());
            }
        }

        List<UocCreateOrderServiceReqPayConfSupBo> payConfigList = reqBo.getPayConfigList();
        Map<String, List<UocCreateOrderServiceReqPayConfSupBo>> payConfMap = payConfigList.stream().collect(Collectors.groupingBy(UocCreateOrderServiceReqPayConfSupBo::getSupId));


        for (List<UocOrderItem> orderItem : splitOrderItemList) {
            String supplierId = orderItem.get(0).getSupplierId();
            UocSaleOrderDo saleOrderDo = UocRu.js(createOrderRet, UocSaleOrderDo.class);
            saleOrderDo.setOrderSource(orderItem.get(0).getSkuSource());
            saleOrderDoList.add(saleOrderDo);
            saleOrderDo.setOrderId(createOrderRet.getOrderId());
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());
            saleOrderDo.setStakeholderId(supStakeMap.get(supplierId).get(0).getStakeholderId());
            saleOrderDo.setStakeholder(UocRu.js(supStakeMap.get(supplierId).get(0), UocSaleStakeholder.class));
            saleOrderDo.setOrderSource(orderItem.get(0).getSkuSource());
            saleOrderDo.setTotalSaleFee(getTotalSaleFee(orderItem));
            saleOrderDo.setTotalPurchaseFee(getTotalPurchaseFee(orderItem));
            saleOrderDo.setSendTime(createOrderRet.getSendTime());
            //如果一个供应商下只有一个配置，则是撮合模式，反之：贸易模式
            saleOrderDo.setModelSettle(payConfMap.get(supplierId).get(0).getConfBos().size() == 1 ? UocConstant.ModelSettle.CH : UocConstant.ModelSettle.MY);
            saleOrderDo.setCreateOperId(createOrderRet.getCreateOperId());

            //支付配置
            saleOrderDo.setSaleOrderPayConfList(UocRu.jsl(payConfMap.get(supplierId).get(0).getConfBos(), UocSaleOrderPayConf.class));

            //销售明细
            saleOrderDo.setSaleOrderItems(UocRu.jsl(orderItem, UocSaleOrderItem.class));
        }

        return saleOrderDoList;
    }

    private BigDecimal getTotalPurchaseFee(List<UocOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal getTotalSaleFee(List<UocOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getSalePrice()));
        }
        return saleFee;
    }

    private BigDecimal getTotalPurchaseFeeWithSaleItem(List<UocSaleOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getPurchasePrice()));
        }
        return saleFee;
    }

    private BigDecimal getTotalSaleFeeWithSaleItem(List<UocSaleOrderItem> orderItem) {
        BigDecimal saleFee = new BigDecimal(0);
        for (UocSaleOrderItem uocOrderItem : orderItem) {
            saleFee = saleFee.add(uocOrderItem.getPurchaseCount().multiply(uocOrderItem.getSalePrice()));
        }
        return saleFee;
    }

    /**
     * 描述:bo转订单do
     *
     * @param reqBo 入参
     * @return com.tydic.dyc.oc.model.order.UocOrderDo
     * @author tgy
     * @date 2022/2/24 21:07
     */
    private UocOrderDo convertOrderDo(UocCreateOrderServiceReqBo reqBo) {
        //订单数据
        UocOrderDo orderDo = UocRu.js(reqBo, UocOrderDo.class);
        orderDo.setCreateOperId(reqBo.getUserId().toString());
        orderDo.setCreateOperName(reqBo.getName());

        //订单纵向扩展
        if (ObjectUtil.isNotEmpty(reqBo.getOrderParallelExtList())) {
            orderDo.setOrderExt(UocRu.jsl(reqBo.getOrderParallelExtList(), UocOrderMap.class));
        }

        //订单发票信息
        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceBO())) {
            orderDo.setUocOrdInvoice(UocRu.js(reqBo.getInvoiceBO(), UocOrdInvoice.class));
        }

        //收货人地址信息
        if (ObjectUtil.isNotEmpty(reqBo.getAddressBo())) {
            orderDo.setReceiverAddress(UocRu.js(reqBo.getAddressBo(), UocOrdLogisticsRela.class));
        }

        //发票邮寄信息
        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceAddressBo())) {
            orderDo.setInvoiceAddress(UocRu.js(reqBo.getInvoiceAddressBo(), UocOrdLogisticsRela.class));
        }

        //订单附件信息
        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryList())) {
            orderDo.setAccessoryList(UocRu.jsl(reqBo.getAccessoryList(), UocOrderAccessory.class));
        }

        //运营机构
        orderDo.setOperating(UocRu.js(reqBo.getProfessionalBo(), UocOrderOperating.class));

        //订单明细信息
        setOrderItems(reqBo, orderDo);

        return orderDo;
    }


    private void setOrderItems(UocCreateOrderServiceReqBo reqBo, UocOrderDo orderDo) {
        List<UocCreateOrderServiceReqCommodityBo> commodityBos = reqBo.getCommodityBos();
        orderDo.setOrderItems(new ArrayList<>(commodityBos.size()));
        for (UocCreateOrderServiceReqCommodityBo commodityBo : commodityBos) {
            UocOrderItem orderItem = UocRu.js(commodityBo, UocOrderItem.class);
            orderItem.setSupplierId(commodityBo.getSupId());
            orderItem.setSupplierName(commodityBo.getSupName());
            orderItem.setItemType(UocDicConstant.ORDER_ITEM_TYPE.SKU);
            orderDo.getOrderItems().add(orderItem);
        }

    }

    private void validateArg(UocCreateOrderServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getUserId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户id]不能为空");
        }
        BigDecimal totalSaleFee = reqBo.getTotalSaleFee();
        BigDecimal totalPurchaseFee = reqBo.getTotalPurchaseFee();
        if (ObjectUtil.isEmpty(totalSaleFee)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售总金额]不能为空");
        }
        if (ObjectUtil.isEmpty(totalPurchaseFee)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[采购总金额]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPurAccount())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[采购方账套id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPurAccountName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[采购方账套名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCommodityBos())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品信息]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getProfessionalBo())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运营方信息]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAddressBo())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址信息]不能为空");
        }

        BigDecimal realTotalSaleFee = new BigDecimal(0);
        BigDecimal realTotalPurchaseFee = new BigDecimal(0);
        for (UocCreateOrderServiceReqCommodityBo commodityBo : reqBo.getCommodityBos()) {
            validateCommodityBo(commodityBo);
            BigDecimal singleSalePrice = commodityBo.getSalePrice().multiply(commodityBo.getPurchaseCount());
            BigDecimal singlePurchasePrice = commodityBo.getPurchasePrice().multiply(commodityBo.getPurchaseCount());
            realTotalSaleFee = realTotalSaleFee.add(singleSalePrice);
            realTotalPurchaseFee = realTotalPurchaseFee.add(singlePurchasePrice);
        }

        if (totalSaleFee.compareTo(realTotalSaleFee) != 0) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售总价格(" + totalSaleFee + ")不等于所有商品总价格(" + realTotalSaleFee + ")");
        }
        if (totalPurchaseFee.compareTo(realTotalPurchaseFee) != 0) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "采购总价格(" + totalPurchaseFee + ")不等于所有商品总价格(" + realTotalPurchaseFee + ")");
        }

        //包含协议商品
        boolean hasAgrComm = false;
        for (UocCreateOrderServiceReqCommodityBo commodityBo : reqBo.getCommodityBos()) {
            if (ObjectUtil.isNotEmpty(commodityBo.getAgreementId())) {
                hasAgrComm = true;
                break;
            }
        }

        //当包含协议商品时，要校验协议支付配置是否传入了
        if (hasAgrComm) {
            if (ObjectUtil.isEmpty(reqBo.getAgrPayConfigList())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "当有协议商品时，协议支付配置不能为空");
            }
        }


        //校验无协议支付配置
        validateNoArgPayConf(reqBo.getPayConfigList());

        //校验协议支付配置
        validateArgPayConf(reqBo.getAgrPayConfigList());

        validateUocCreateOrderServiceReqProfessionalBo(reqBo.getProfessionalBo());

        validateUocCreateOrderServiceReqAddressBo(reqBo.getAddressBo());

        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceAddressBo())) {
            validateUocCreateOrderServiceReqAddressBo(reqBo.getInvoiceAddressBo());
        }

        if (ObjectUtil.isNotEmpty(reqBo.getInvoiceBO())) {
            validateUocCreateOrderServiceReqInvoiceBo(reqBo.getInvoiceBO());
        }

        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryList())) {
            for (UocCreateOrderServiceReqAccessoryBo uocCreateOrderServiceReqAccessoryBo : reqBo.getAccessoryList()) {
                validateUocCreateOrderServiceReqAccessoryBo(uocCreateOrderServiceReqAccessoryBo);
            }
        }

        if (ObjectUtil.isNotEmpty(reqBo.getOrderParallelExtList())) {
            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getOrderParallelExtList()) {
                validateUocBaseExtParallelBo(uocBaseExtParallelBo);
            }
        }

    }

    private void validateArgPayConf(List<UocCreateOrderServiceReqArgPayConfSupBo> agrPayConfigList) {
        if(ObjectUtil.isNotEmpty(agrPayConfigList)){
            for (UocCreateOrderServiceReqArgPayConfSupBo uocCreateOrderServiceReqPayConfSupBo : agrPayConfigList) {
                validateAgrPayConfBo(uocCreateOrderServiceReqPayConfSupBo);
            }
        }
    }

    private void validateAgrPayConfBo(UocCreateOrderServiceReqArgPayConfSupBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqArgPayConfSupBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgrId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getConfBos())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商配置]不能为空");
        }
        for (UocCreateOrderServiceReqPayConfBo confBo : reqBo.getConfBos()) {
            validatePayConfBo(confBo);
        }
    }

    private void validateNoArgPayConf(List<UocCreateOrderServiceReqPayConfSupBo> reqBo) {
        if(ObjectUtil.isNotEmpty(reqBo)){
            for (UocCreateOrderServiceReqPayConfSupBo uocCreateOrderServiceReqPayConfSupBo : reqBo) {
                validateNoAgrPayConfBo(uocCreateOrderServiceReqPayConfSupBo);
            }
        }
    }

    private void validateNoAgrPayConfBo(UocCreateOrderServiceReqPayConfSupBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqPayConfSupBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSupId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getConfBos())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商配置]不能为空");
        }
        for (UocCreateOrderServiceReqPayConfBo confBo : reqBo.getConfBos()) {
            validatePayConfBo(confBo);
        }
    }

    private void validatePayConfBo(UocCreateOrderServiceReqPayConfBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqPayConfBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getModelSettle())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[结算模式]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPayType())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[付款方式]不能为空");
        }

    }

    private void validateUocCreateOrderServiceReqAccessoryBo(UocCreateOrderServiceReqAccessoryBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqAccessoryBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAccessoryName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[附件名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAccessoryUrl())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[附件url]不能为空");
        }
    }

    private void validateUocCreateOrderServiceReqInvoiceBo(UocCreateOrderServiceReqInvoiceBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqInvoiceBo]不能为空");
        }

    }

    private void validateUocCreateOrderServiceReqAddressBo(UocCreateOrderServiceReqAddressBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqAddressBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactProvinceId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份编号]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactProvinceName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人省份名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactCityId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市编号]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactCityName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人地市名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactCountyId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县编号]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactCountyName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人区县名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactAddress())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[收货人地址]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactEmail())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人邮件]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getContactMobile())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[联系人手机]不能为空");
        }
    }

    private void validateUocCreateOrderServiceReqProfessionalBo(UocCreateOrderServiceReqProfessionalBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqProfessionalBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getProId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运营单位机构id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getProName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运营机构名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getProOrgPath())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[运营机构机构树路径]不能为空");
        }
    }

    private void validateCommodityBo(UocCreateOrderServiceReqCommodityBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqCommodityBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSkuId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[单品ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSkuName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[单品名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCommodityId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getCommodityName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSupId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSupName())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[供应商名称]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSupplierShopId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[店铺ID]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPurchasePrice())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[采购单价]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSalePrice())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单价]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getPurchaseCount())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[采购数量]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSkuSource())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[商品来源]不能为空");
        }
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(reqBo.getSkuSource())) {
            if (ObjectUtil.isEmpty(reqBo.getAgreementId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "协议商品(skuId:" + reqBo.getSkuId() + ")，协议id不能为空");
            }
        }
        if (!ObjectUtil.isEmpty(reqBo.getAgreementId())) {
            if (ObjectUtil.isEmpty(reqBo.getAgrBo())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议对象]不能为空");
            }
            validateAgrBo(reqBo.getAgrBo());
            reqBo.setAgreementCode(reqBo.getAgrBo().getAgreementCode().toString());
        }
        if (ObjectUtil.isNotEmpty(reqBo.getSaleItemParallelExtList())) {
            for (UocBaseExtParallelBo uocBaseExtParallelBo : reqBo.getSaleItemParallelExtList()) {
                validateUocBaseExtParallelBo(uocBaseExtParallelBo);
            }
        }
    }

    private void validateAgrBo(UocCreateOrderServiceReqAgrBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCreateOrderServiceReqAgrBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgreementId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议Id]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getAgreementCode())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议模式不能为空");
        }
        /*if (ObjectUtil.isEmpty(reqBo.getAgreementVersion())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[协议版本号]不能为空");
        }*/
        if (ObjectUtil.isEmpty(reqBo.getAdjustPrice())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[0：无，1：事前调价，2：事中调价 默认值：0]不能为空");
        }

    }

    private void validateUocBaseExtParallelBo(UocBaseExtParallelBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocBaseExtParallelBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getFieldCode())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[字段编码]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getFieldValue())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[字段值]不能为空");
        }
    }

}