package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocStateChngOrderCreateServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/4/11 17:41
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocStateChngOrderCreateServiceImpl implements UocStateChngOrderCreateService{

    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @Autowired
    private IUocShipOrderModel shipOrderModel;

    @Override
    public UocStateChngOrderCreateRspBo createStateChng(UocStateChngOrderCreateReqBo reqBo) {
        val(reqBo);
        UocStateChngOrderCreateRspBo rspBo = new UocStateChngOrderCreateRspBo();
        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        UocSaleOrderDo uocSaleOrderDo = getUocSaleOrderDo(reqBo);
        List<UocShipOrderItem> shipOrderItemList = getShipOrderItemList(reqBo);
        List<UocSaleOrderItem> uocSaleOrderItem = getUocSaleOrderItem(shipOrderItemList);
        Map<Long, UocSaleOrderItem> itemMap = uocSaleOrderItem.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, List<UocShipOrderItem>> shipOrderItemMap = shipOrderItemList.stream().collect(Collectors.groupingBy(UocShipOrderItem::getShipOrderId));
        //检验是否支持状态变更
        checkEnableStateChngOrder(shipOrderItemMap,reqBo,itemMap);
        UocChngOrderDo uocChngOrderDo = convertChngOrderDo(reqBo, new Date(), uocSaleOrderDo,shipOrderItemMap,itemMap);
        iUocChngOrderModel.createChngOrder(uocChngOrderDo);

        //批量修改发货单发货数量，退货数量
        Date now = new Date();
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        uocChngOrderDo.getUocChngOrderObjList().forEach(x->{
            modifyShipAndOrderItemChngCount(reqBo, x, now,uocShipOrderItemMap);
        });

        rspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        rspBo.setShipOrderIdList(reqBo.getChngList().stream().map(UocStateChngOrderCreateReqShipBo::getShipOrderId).collect(Collectors.toList()));
        return rspBo;
    }
    /**
     * 修改发货明细销售明细的异常在途数量
     */
    private void modifyShipAndOrderItemChngCount(UocStateChngOrderCreateReqBo reqBo, UocChngOrderObj uocChngOrderObj, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setShipOrderId(uocChngOrderObj.getShipOrderId());
        uocShipOrderDo.setUpdateOperId(String.valueOf(reqBo.getUserId()));
        uocShipOrderDo.setUpdateTime(now);
        List<UocShipOrderItem> uocShipOrderItemList = new ArrayList<>();
        List<UocSaleOrderItem> uocSaleOrderItems = new ArrayList<>();
        String chngState = uocChngOrderObj.getChngState();
        if (UocDicConstant.STATE_CHNG.JUSHOU.equals(chngState)) {
            uocChngOrderObj.getUocChngOrderItemObjList().forEach(x -> {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(x.getShipOrderItemId());
                UocShipOrderItem uocShipOrderItem1 = uocShipOrderItemMap.get(x.getShipOrderItemId());
                uocShipOrderItem.setChngingCount(uocShipOrderItem1.getArriveCount());
                uocShipOrderItemList.add(uocShipOrderItem);
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setChngingCount(uocShipOrderItem1.getArriveCount());
                uocSaleOrderItem.setOrderItemId(uocShipOrderItem1.getSaleOrderItemId());
                uocSaleOrderItems.add(uocSaleOrderItem);

            });
        } else {
            uocChngOrderObj.getUocChngOrderItemObjList().forEach(x -> {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(x.getShipOrderItemId());
                UocShipOrderItem uocShipOrderItem1 = uocShipOrderItemMap.get(x.getShipOrderItemId());
                uocShipOrderItem.setChngingCount(uocShipOrderItem1.getRefuseCount());
                uocShipOrderItemList.add(uocShipOrderItem);
                UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setChngingCount(uocShipOrderItem1.getRefuseCount());
                uocSaleOrderItem.setOrderItemId(uocShipOrderItem1.getSaleOrderItemId());
                uocSaleOrderItems.add(uocSaleOrderItem);
            });
        }


        uocShipOrderDo.setShipOrderItemBoList(uocShipOrderItemList);
        uocSaleOrderDo.setSaleOrderItems(uocSaleOrderItems);

        shipOrderModel.modifyShipOrderItemChngingCount(uocShipOrderDo);
        iUocSaleOrderModel.modifyBatchItemChngingCount(uocSaleOrderDo);
    }
    private List<UocSaleOrderItem> getUocSaleOrderItem(List<UocShipOrderItem> shipOrderItemList) {
        List<Long> itemIdList = shipOrderItemList.stream().map(UocShipOrderItem::getSaleOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(itemIdList);
        return iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);

    }


    private void checkEnableStateChngOrder(Map<Long, List<UocShipOrderItem>> shipOrderItemList, UocStateChngOrderCreateReqBo reqBo, Map<Long, UocSaleOrderItem> itemMap) {
        for (UocStateChngOrderCreateReqShipBo uocStateChngOrderCreateReqShipBo : reqBo.getChngList()) {
            List<UocShipOrderItem> shipOrderItems = shipOrderItemList.get(uocStateChngOrderCreateReqShipBo.getShipOrderId());
            for (UocShipOrderItem shipOrderItem : shipOrderItems) {
                BigDecimal arriveCount = shipOrderItem.getArriveCount();
                BigDecimal refuseCount = shipOrderItem.getRefuseCount();
                UocSaleOrderItem uocSaleOrderItem = itemMap.get(shipOrderItem.getSaleOrderItemId());
                BigDecimal chngingCount = shipOrderItem.getChngingCount();
                if (chngingCount.compareTo(BigDecimal.ZERO) > 0) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "发货单存在未完结的异常变更");

                }
                if (!(arriveCount.compareTo(BigDecimal.ZERO) > 0 || refuseCount.compareTo(BigDecimal.ZERO) > 0 || uocSaleOrderItem.getAfterServingCount().compareTo(BigDecimal.ZERO) == 0)) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR,"发货单状态不为'妥投'、'拒收'或者发货单售后数量不为0时,不允许发起状态变更");
                }
            }
        }

    }

    private UocSaleOrderDo getUocSaleOrderDo(UocStateChngOrderCreateReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_QURYSALEORDER_ERROR, "查询销售单为空");
        }
        return uocSaleOrderDo;
    }

    /**
     * 获取发货单明细数据
     */
    private List<UocShipOrderItem> getShipOrderItemList(UocStateChngOrderCreateReqBo reqBo) {
        List<UocShipOrderItem> shipOrderItems = new ArrayList<>();
        for (UocStateChngOrderCreateReqShipBo uocStateChngOrderCreateReqShipBo : reqBo.getChngList()) {
            UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
            uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocShipOrderItemQryBo.setShipOrderId(uocStateChngOrderCreateReqShipBo.getShipOrderId());
            UocShipOrderDo uocShipOrderDo = shipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询发货单明细列表为空");
            }
            shipOrderItems.addAll(uocShipOrderDo.getShipOrderItemBoList());
        }

        return shipOrderItems;
    }
    private UocChngOrderDo convertChngOrderDo(UocStateChngOrderCreateReqBo reqBo, Date now, UocSaleOrderDo uocSaleOrderDo, Map<Long, List<UocShipOrderItem>> shipOrderItemMap, Map<Long, UocSaleOrderItem> itemMap) {

        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderNo(getChngOrderNo(uocSaleOrderDo));
        uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QRZ);
        uocChngOrderDo.setCancelTime(now);
        uocChngOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.STATE);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setRemark(reqBo.getRemark());
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        reqBo.getChngList().forEach(x->{
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setOrderId(reqBo.getOrderId());
            uocOrderTaskInst.setObjId(x.getShipOrderId());
            uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
            uocOrderTaskInst.setFinishTag(0);
            List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
            String procState = uocOrderTaskInsts.get(0).getProcState();

            UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
            uocChngOrderObj.setOrderId(reqBo.getOrderId());
            uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
            uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.STATE);
            uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
            uocChngOrderObj.setCreateTime(now);
            uocChngOrderObj.setCreateOperId(reqBo.getUserId().toString());
            uocChngOrderObj.setChngState(procState);
            uocChngOrderObj.setOtherChngValue(x.getChngState());
            uocChngOrderObj.setChngFee(BigDecimal.ZERO);

            List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
            List<UocShipOrderItem> shipOrderItems = shipOrderItemMap.get(x.getShipOrderId());
            for (UocShipOrderItem shipOrderItem : shipOrderItems) {
                UocSaleOrderItem uocSaleOrderItem = itemMap.get(shipOrderItem.getSaleOrderItemId());
                BigDecimal shipItemMoney = uocSaleOrderItem.getSalePrice().multiply(shipOrderItem.getSendCount());
                if (UocDicConstant.STATE_CHNG.JUSHOU.equals(x.getChngState())) {
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().add(shipItemMoney));

                } else {
                    uocChngOrderObj.setChngFee(uocChngOrderObj.getChngFee().subtract(shipItemMoney));
                }
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setSaleOrderItemId(shipOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setShipOrderItemId(shipOrderItem.getShipOrderItemId());
                uocChngOrderItemObj.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setCreateTime(now);
                uocChngOrderItemObj.setCreateOperId(reqBo.getUserId().toString());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.STATE);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
            }
            uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
            uocChngOrderObjList.add(uocChngOrderObj);
        });
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> orderAccessoryBoList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            orderAccessoryBoList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setCreateTime(now);
            });
            uocChngOrderDo.setOrderAccessoryBoList(orderAccessoryBoList);
        }
        return uocChngOrderDo;
    }
    private String getChngOrderNo(UocSaleOrderDo uocSaleOrderDo) {
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.STATE);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }
    private void val(UocStateChngOrderCreateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象订单id不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象销售单id不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getChngList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象变更列表不能为空");
        }
        for (UocStateChngOrderCreateReqShipBo uocStateChngOrderCreateReqShipBo : reqBo.getChngList()) {
            if (ObjectUtil.isEmpty(uocStateChngOrderCreateReqShipBo.getShipOrderId())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象发货单id不能为空");
            }
            if (ObjectUtil.isEmpty(uocStateChngOrderCreateReqShipBo.getChngState())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象变更状态不能为空");
            }
        }
    }
}
