package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocPaymentCallbackRspBO;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

/**
 * 标题：UocPaymentCallbackServiceImpl
 * 说明：付款回调
 * 时间：2022/4/8 17:35
 * 作者： 周中贤
 */
@Slf4j
@HTServiceImpl
public class UocPaymentCallbackServiceImpl implements UocPaymentCallbackService{

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;


    /**
     * 付款回调
     */
    @Override
    public UocPaymentCallbackRspBO dealCallback(UocPaymentCallbackReqBO reqBO) {
        val(reqBO);
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            if(!uocPaymentCallbackBO.getPayResult()){
                //支付未成功，不做任何操作
                log.info("结算回调支付状态为false，订单侧不做任何操作");
                return UocRu.success(UocPaymentCallbackRspBO.class);
            }
            //1.查询并修改应付单(支付状态和已付金额)
            UocOrderShouldPay uocOrderShouldPay = new UocOrderShouldPay();
            uocOrderShouldPay.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
            UocOrderShouldPay orderShouldPay = iUocPayOrderModel.getOrderShouldPay(uocOrderShouldPay);
            if(orderShouldPay == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "结算应付id查询应付单为空");
            }
            UocOrderShouldPay set = new UocOrderShouldPay();
            set.setIsPayCompleted(UocDicConstant.SHOULD_PAY_ORDER_PAY_STATE.PAY_COMPLETED);
            UocOrderShouldPay where = new UocOrderShouldPay();
            where.setFscShouldPayId(uocPaymentCallbackBO.getFscShouldPayId());
            where.setPaidAmount(uocPaymentCallbackBO.getShouldPayMoney());
            iUocPayOrderModel.modifyOrderShouldPayMain(set,where);
            //单据id
            Long objectId = orderShouldPay.getObjectId();
            //单据类型
            Integer objectType = orderShouldPay.getObjectType();
            //2.找到销售单ID
            Long saleOrderID = qrySaleOrderID(uocPaymentCallbackBO, objectId, objectType);
            if(saleOrderID == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询销售单ID为空");
            }
            //3.修改销售单（实付金额）
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocSaleOrderDo.setSaleOrderId(saleOrderID);
            uocSaleOrderDo.setUsedFee(uocPaymentCallbackBO.getShouldPayMoney());
            iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        }
        return UocRu.success(UocPaymentCallbackRspBO.class);
    }

    /**
     * 查询销售单Id
     */
    private Long qrySaleOrderID(UocPaymentCallbackBO uocPaymentCallbackBO, Long objectId, Integer objectType) {
        Long saleOrderId = null;
        if(UocDicConstant.OBJ_TYPE.SALE.equals(objectType)){
            //销售单类型
            saleOrderId = objectId;
        }else if(UocDicConstant.OBJ_TYPE.SHIP.equals(objectType)){
            //发货单类型 发货单找到销售单id
            UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
            uocShipOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocShipOrderQryBo.setShipOrderId(objectId);
            UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
            if(uocShipOrderDo == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询发货单为空");
            }
            saleOrderId = uocShipOrderDo.getSaleOrderId();
        }else if(UocDicConstant.OBJ_TYPE.INSPECTION.equals(objectType)){
            //验收单类型 验收单找到销售单Id
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setOrderId(uocPaymentCallbackBO.getOrderId());
            uocInspOrderQryBo.setInspOrderId(objectId);
            UocInspOrderDo inspOrderMain = iUocInspOrderModel.getInspOrderMain(uocInspOrderQryBo);
            if(inspOrderMain == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "查询验收单为空");
            }
            saleOrderId = inspOrderMain.getSaleOrderId();
        }else{
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "暂仅支持销售单、发货单、验收单单据类型");
        }
        return saleOrderId;
    }

    private void val(UocPaymentCallbackReqBO reqBO) {
        if(reqBO == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if(CollectionUtils.isEmpty(reqBO.getUocPaymentCallbackBOS())){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[回调信息集合]为空");
        }
        for (UocPaymentCallbackBO uocPaymentCallbackBO : reqBO.getUocPaymentCallbackBOS()) {
            if(uocPaymentCallbackBO == null){
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[支付是否成功]为空");
            }
            if(uocPaymentCallbackBO.getPayResult()){
                if(uocPaymentCallbackBO.getFscShouldPayId() == null){
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[结算应付ID]为空");
                }
                if(uocPaymentCallbackBO.getOrderId() == null){
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[订单ID]为空");
                }
                if(uocPaymentCallbackBO.getShouldPayMoney() == null){
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参[应付金额]为空");
                }
            }
        }

    }
}
