package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateDomainReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocProcInsTerminateDomainRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocProcInsTerminateDomainServiceImpl
 * 说明:TODO
 * 时间:2022/4/7 12:22
 * 作者:罗有
 */

@HTServiceImpl
public class UocProcInsTerminateDomainServiceImpl implements UocProcInsTerminateDomainService {
	@Autowired
	private IUocSaleOrderModel iUocSaleOrderModel;

	@Override
	public UocProcInsTerminateDomainRspBo dealProcInsTerminate(UocProcInsTerminateDomainReqBo reqBo) {
		val(reqBo);
		//终止流程
		updateProcInst(reqBo);
		//查询代办
		List<UocOrderTaskInst> uocOrderTaskInsts = getUocOrderTaskInsts(reqBo);
		//至为已办
		updateTaskFinish(reqBo);
		//生成结束代办
		saveTaskInst(reqBo, uocOrderTaskInsts);

		return UocRu.success(UocProcInsTerminateDomainRspBo.class);
	}

	/**
	 * 任务更新已办
	 *
	 * @param reqBo
	 */
	private void updateTaskFinish(UocProcInsTerminateDomainReqBo reqBo) {
		UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
		uocOrderTaskInst.setObjId(reqBo.getObjId());
		uocOrderTaskInst.setObjType(reqBo.getObjType());
		uocOrderTaskInst.setOrderId(reqBo.getOrderId());
		uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
		iUocSaleOrderModel.updateTaskInst(uocOrderTaskInst);
	}

	/**
	 * 创建结束代办
	 *
	 * @param reqBo
	 * @param uocOrderTaskInsts
	 */
	private void saveTaskInst(UocProcInsTerminateDomainReqBo reqBo, List<UocOrderTaskInst> uocOrderTaskInsts) {
		List<UocOrderTaskInst> saveList = new ArrayList<>();
		UocOrderTaskInst taskBo = new UocOrderTaskInst();
		taskBo.setId(IdUtil.nextId());
		taskBo.setOrderId(reqBo.getOrderId());
		taskBo.setTaskInstId(String.valueOf(IdUtil.nextId()));
		taskBo.setObjId(reqBo.getObjId());
		taskBo.setObjType(reqBo.getObjType());
		taskBo.setProcState(uocOrderTaskInsts.get(0).getProcState() + UocConstant.FINISH_OTHER_TAG.FINISH);
		taskBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
		saveList.add(taskBo);
		iUocSaleOrderModel.saveProcTaskInst(saveList);
	}

	/**
	 * 查询代办任务
	 *
	 * @param reqBo
	 * @return
	 */
	private List<UocOrderTaskInst> getUocOrderTaskInsts(UocProcInsTerminateDomainReqBo reqBo) {
		UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
		uocOrderTaskInst.setOrderId(reqBo.getOrderId());
		uocOrderTaskInst.setObjType(reqBo.getObjType());
		uocOrderTaskInst.setObjId(reqBo.getObjId());
		uocOrderTaskInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
		List<UocOrderTaskInst> uocOrderTaskInsts = iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
		if (CollectionUtils.isEmpty(uocOrderTaskInsts)) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_PROC_INST_TERMINATE_ERROR, "查询代办任务为空");
		}
		return uocOrderTaskInsts;
	}

	/**
	 * 更新流程结束
	 *
	 * @param reqBo
	 */
	private void updateProcInst(UocProcInsTerminateDomainReqBo reqBo) {
		UocOrderProcInst uocOrderProcInst = new UocOrderProcInst();
		uocOrderProcInst.setOrderId(reqBo.getOrderId());
		uocOrderProcInst.setObjType(reqBo.getObjType());
		uocOrderProcInst.setObjId(reqBo.getObjId());
		uocOrderProcInst.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.END_TASK);
		iUocSaleOrderModel.updateProcInst(uocOrderProcInst);
	}

	private void val(UocProcInsTerminateDomainReqBo reqBo) {
		if (null == reqBo) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
		}
		if (null == reqBo.getOrderId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
		}
		if (null == reqBo.getObjId()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参单据ID不能为空");
		}
		if (null == reqBo.getObjType()) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参单据类型不能为空");
		}
	}
}
