package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsRspInfoBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryChngOrderDetailsRspInfoItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

/**
 * 标题:UocQryChngOrderDetailsServiceImpl
 * 说明:变更单详情查询
 * 时间:2022/3/14 21:40
 * 作者:罗有
 */

@HTServiceImpl
public class UocQryChngOrderDetailsServiceImpl implements UocQryChngOrderDetailsService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Override
    public UocQryChngOrderDetailsRspBo getChngOrderDetails(UocQryChngOrderDetailsReqBo reqBo) {
        val(reqBo);
        UocQryChngOrderDetailsRspBo uocQryChngOrderDetailsRspBo = UocRu.success(UocQryChngOrderDetailsRspBo.class);
        UocChngOrderQryBo uocChngOrderQryBo = UocRu.js(reqBo, UocChngOrderQryBo.class);
        UocChngOrderDo chngOrder = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
        if (null != chngOrder) {
            UocQryChngOrderDetailsRspInfoBo chngOrderInfo = UocRu.js(chngOrder, UocQryChngOrderDetailsRspInfoBo.class);
            Map<String, Map<String, String>> dicMap = getDic();
            Map<String, String> chngStateMap = dicMap.get(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
            chngOrderInfo.setChngOrderStateStr(chngStateMap.get(chngOrderInfo.getChngOrderState()));
            UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
            uocOrderAccessoryQryBo.setOrderId(reqBo.getOrderId());
            uocOrderAccessoryQryBo.setObjId(reqBo.getChngOrderId());
            uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
            List<UocOrderAccessory> orderAccessoryList = iUocOrderModel.getOrderAccessoryList(uocOrderAccessoryQryBo);
            if (ObjectUtil.isNotEmpty(orderAccessoryList)) {
                List<UocBaseOrderAccessoryTypeDetailBo> orderAccessoryTypeDetailBos = new ArrayList<>();
                ConcurrentMap<Integer, List<UocOrderAccessory>> orderAccessoryMap = orderAccessoryList.stream().collect(Collectors.groupingByConcurrent(UocOrderAccessory::getAttachmentType));
                orderAccessoryMap.keySet().forEach(each -> {
                    UocBaseOrderAccessoryTypeDetailBo typeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                    typeDetailBo.setAttachmentType(each);
                    if (ObjectUtil.isNotNull(each)) {
                        typeDetailBo.setAttachmentTypeStr(getDic().get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(each.toString()));
                    }
                    typeDetailBo.setAttchList(UocRu.jsl(orderAccessoryMap.get(each), UocBaseOrderAccessoryDetailBo.class));
                    orderAccessoryTypeDetailBos.add(typeDetailBo);
                });
                chngOrderInfo.setChngOrderAccessoryList(orderAccessoryTypeDetailBos);
            }

            UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
            uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
            uocChngOrderObjQryBo.setChngOrderId(reqBo.getChngOrderId());
            List<UocChngOrderObj> uocChngOrderObjList = iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
            if (!CollectionUtils.isEmpty(uocChngOrderObjList)) {
                UocChngOrderObj uocChngOrderObj = uocChngOrderObjList.get(0);
                chngOrderInfo.setChngType(uocChngOrderObj.getChngType());
                chngOrderInfo.setChngTypeStr(uocChngOrderObj.getChngTypeStr());
                UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
                uocShipOrderQryBo.setShipOrderId(uocChngOrderObj.getShipOrderId());
                UocShipOrderDo shipOrderOrderDo = iUocShipOrderModel.getShipOrderById(uocShipOrderQryBo);
                if (ObjectUtil.isNotNull(shipOrderOrderDo)) {
                    chngOrderInfo.setShipOrderNo(shipOrderOrderDo.getShipOrderNo());
                }
                UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
                uocSaleOrderQryBo.setSaleOrderId(uocChngOrderObj.getSaleOrderId());
                uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
                UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
                if (null != uocSaleOrderDo) {
                    chngOrderInfo.setSaleOrderNo(uocSaleOrderDo.getSaleOrderNo());
                    chngOrderInfo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                    UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
                    uocSaleOrderItemQryBo.setSaleOrderId(uocSaleOrderDo.getSaleOrderId());
                    uocSaleOrderItemQryBo.setOrderId(uocSaleOrderDo.getOrderId());
                    List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
                    if (!CollectionUtils.isEmpty(saleOrderItemList)) {
                        chngOrderInfo.setChngOrderItemList(UocRu.jsl(saleOrderItemList, UocQryChngOrderDetailsRspInfoItemBo.class));
                        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                        uocShipOrderItemQryBo.setOrderId(uocChngOrderObj.getOrderId());
                        uocShipOrderItemQryBo.setShipOrderId(uocChngOrderObj.getShipOrderId());
                        UocShipOrderDo listShipOrderItem = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                        if (ObjectUtil.isNotNull(listShipOrderItem) && ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                            UocShipOrderItem uocShipOrderItem = listShipOrderItem.getShipOrderItemBoList().get(0);
                            chngOrderInfo.getChngOrderItemList().forEach(each -> {
                                each.setInspCount(uocShipOrderItem.getInspCount());
                                each.setPreReturnCount(uocShipOrderItem.getReturnCount());
                                each.setCurReturnCount(uocShipOrderItem.getReturnCount());
                                each.setChngNum(uocChngOrderObj.getChngNum());
                                each.setChngFee(uocChngOrderObj.getChngFee());
                            });
                        }
                    }
                }
            }
            uocQryChngOrderDetailsRspBo.setChngOrderInfo(chngOrderInfo);
        }
        return uocQryChngOrderDetailsRspBo;

    }

    private void val(UocQryChngOrderDetailsReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getChngOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
    }


    private Map<String, Map<String, String>> getDic() {
        List<String> pCodes = new ArrayList<>();
        pCodes.add(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.P_CODE);
        pCodes.add(UocDicConstant.ATTACHMENT_TYPE.P_CODE);
        return iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }


}
