package com.tydic.dyc.oc.model.saleorder.qrybo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderItemQryBo
 * 说明:销售订单明细
 * 时间:2022-02-21 19:11
 * 作者:罗有
 **/
@EqualsAndHashCode(callSuper = true)
@Data
public class UocSaleOrderItemQryBo extends BasePageReqBo {
	private static final long serialVersionUID =  -2942628359818493335L;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "销售明细id")
	private Long saleOrderItemId;

	@DocField(value = "销售单id")
	private Long saleOrderId;

	@DocField(value = "订单明细id")
	private Long orderItemId;

	@DocField(value = "明细类型             1 商品sku             2 物资             3 项目")
	private Integer itemType;

	@DocField(value = "明细状态")
	private String saleItemState;

	@DocField(value = "单品ID")
	private String skuId;

	@DocField(value = "供应商ID")
	private String supplierId;

	@DocField(value = "店铺ID")
	private String supplierShopId;

	@DocField(value = "采购金额")
	private BigDecimal purchasePrice;

	@DocField(value = "采购金额")
	private BigDecimal salePrice;

	@DocField(value = "采购数量")
	private BigDecimal purchaseCount;

	@DocField(value = "运费")
	private BigDecimal transFee;

	@DocField(value = "采购金额")
	private BigDecimal purchaseFee;

	@DocField(value = "应付金额")
	private BigDecimal payFee;

	@DocField(value = "积分优惠金额")
	private BigDecimal integralDisFee;

	@DocField(value = "活动优惠金额")
	private BigDecimal actDisFee;

	@DocField(value = "其它优惠金额")
	private BigDecimal otherDisFee;

	@DocField(value = "实付金额")
	private BigDecimal usedFee;

	@DocField(value = "实付积分")
	private BigDecimal usedIntegral;

	@DocField(value = "币种")
	private String currencyType;

	@DocField(value = "税金")
	private String taxPrice;

	@DocField(value = "税率")
	private String tax;

	@DocField(value = "税务编码")
	private String taxId;

	@DocField(value = "预计发货时间")
	private Date preSendTime;

	@DocField(value = "预计发货时间 开始")
	private Date preSendTimeStart;

	@DocField(value = "预计发货时间 结束")
	private Date preSendTimeEnd;

	@DocField(value = "预计交货时间")
	private Date preOfferTime;

	@DocField(value = "预计交货时间 开始")
	private Date preOfferTimeStart;

	@DocField(value = "预计交货时间 结束")
	private Date preOfferTimeEnd;

	@DocField(value = "计量单位")
	private String unitName;

	@DocField(value = "结算计量单位")
	private String settleUnit;

	@DocField(value = "售后在途数量")
	private BigDecimal afterServingCount;

	@DocField(value = "外部电商主订单id")
	private String lmOrderId;

	@DocField(value = "外部电商子订单id")
	private String lmSubOrderId;

	@DocField(value = "到货周期")
	private String arrivalTime;

	@DocField(value = "加价率")
	private Double markUpRate;

	@DocField(value = "商品服务费 ")
	private String serPrice;

	@DocField(value = "计划id")
	private String planId;

	@DocField(value = "计划明细id ")
	private String planItemId;

	@DocField(value = "计划明细编号")
	private String planItemNo;

	@DocField(value = "创建时间")
	private Date createTime;

	@DocField(value = "创建时间 开始")
	private Date createTimeStart;

	@DocField(value = "创建时间 结束")
	private Date createTimeEnd;

	@DocField(value = "创建工号")
	private String createOperId;

	@DocField(value = "更新时间")
	private Date updateTime;

	@DocField(value = "更新时间 开始")
	private Date updateTimeStart;

	@DocField(value = "更新时间 结束")
	private Date updateTimeEnd;

	@DocField(value = "更新工号")
	private String updateOperId;

	@DocField(value = "备注")
	private String remark;

	@DocField(value = "删除标志1已删除")
	private Integer delTag;

	@DocField(value = "超验百分比，下单时保存（协议、无协议）")
	private Integer inspectionExcessPercent;

	@DocField(value = "是否存在超验 0否 1是")
	private Integer inspSuper;

	@DocField(value = "扩展字段")
	private String extField1;

	@DocField(value = "扩展字段")
	private String extField2;

	@DocField(value = "扩展字段")
	private String extField3;

    @DocField(value = "扩展字段")
    private String extField4;

    @DocField(value = "扩展字段")
    private String extField5;

    @DocField(value = "排序")
    private String orderBy;

    @DocField(value = "销售明细id List")
    private List<Long> saleOrderItemIdList;

}
