package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEcArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocEcArrvalAcceptanceServiceImpl
 * 说明:TODO
 * 时间:2022/4/7 15:16
 * 作者:代愿愿
 */
@HTServiceImpl
public class UocEcArrvalAcceptanceServiceImpl implements UocEcArrvalAcceptanceService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    /**
     * 全部验收完成
     */
    private static final String OP_FLAG_YES = "1";

    @Override
    public UocEcArrvalAcceptanceRspBo dealEcArrvalAcceptance(UocEcArrvalAcceptanceReqBo reqBo) {
        // 入参校验
        validateArg(reqBo);
        // 校验销售单明细的采购数量=到货数量+拒收数量才能验收
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if(uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getArriveCount().add(uocSaleOrderItem.getRefuseCount()))!=0){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARRIVA_ACCEPTANCE_ERROR, "存在不能验收的数据");
        }
        Date nowDate = new Date();
        //创建验收单相关信息
        UocInspOrderDo uocInspOrderDo = convertInspOrderDo(reqBo,nowDate);
        iUocInspOrderModel.createInspOrder(uocInspOrderDo);
        // 更新发货单验收信息
        updateShipOrderInspInfo(reqBo,nowDate);
        // 更新发货单明细验收信息
        updateShipOrderItemInspInfo(reqBo,nowDate);
        // 更新销售单明细验收信息
        updateSaleOrderItemInspInfo(reqBo,nowDate);
        // 更新销售单超验标识
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        iUocSaleOrderModel.modifyInspSuper(uocSaleOrderDo1);
        // 设置出参
        UocEcArrvalAcceptanceRspBo uocEcArrvalAcceptanceRspBo = UocRu.success(UocEcArrvalAcceptanceRspBo.class);
        uocEcArrvalAcceptanceRspBo.setFinish(true);
        uocEcArrvalAcceptanceRspBo.setOpFlag(OP_FLAG_YES);
        uocEcArrvalAcceptanceRspBo.setInspOrderId(uocInspOrderDo.getInspOrderId());
        return uocEcArrvalAcceptanceRspBo;
    }
    /**
     * 更新销售单明细验收信息
     */
    private void updateSaleOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo,Date nowDate){
        UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
        uocSaleOrderDo1.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo1.setUpdateTime(nowDate);
        uocSaleOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        iUocSaleOrderModel.modifySaleOrderItemInspCountEqualArrivalCount(uocSaleOrderDo1);
    }
    /**
     * 更新发货单明细验收信息
     */
    private void updateShipOrderItemInspInfo(UocEcArrvalAcceptanceReqBo reqBo,Date nowDate){
        UocShipOrderDo uocShipOrderDo1 = new  UocShipOrderDo();
        uocShipOrderDo1.setOrderId(reqBo.getOrderId());
        uocShipOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo1.setUpdateTime(nowDate);
        iUocShipOrderModel.modifyShipOrderItemInspCountEqualArrivalCount(uocShipOrderDo1);
    }
    /**
     * 更新发货单验收信息
     */
    private void updateShipOrderInspInfo(UocEcArrvalAcceptanceReqBo reqBo,Date nowDate){
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setUpdateTime(nowDate);
        uocShipOrderDo.setInspOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setInspOperName(reqBo.getName());
        uocShipOrderDo.setInspTime(nowDate);
        uocShipOrderDo.setInspOperPhone(reqBo.getCellphone());
        iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
    }
    /**
     * 转换验收单领域参数
     */
    private UocInspOrderDo convertInspOrderDo(UocEcArrvalAcceptanceReqBo reqBo,Date nowDate) {
        // 查询销售单主体信息
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if(null == uocSaleOrderDo){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "查询验收单为空");
        }
        // 查询发货单
        UocShipOrderQryBo uocShipOrderQryBo =  new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> uocShipOrderDoList = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        // 查询发货单明细
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocShipOrderDo uocShipOrderDo = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        // 拼装验收单信息
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(IdUtil.nextId());
        uocInspOrderDo.setInspOrderNo(getInspOrderNo(uocSaleOrderDo));
        uocInspOrderDo.setInspOrderState(UocStateConstants.InspOrder.YS_YS_YS);
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocInspOrderDo.setCreateTime(nowDate);
        uocInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        uocInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        uocInspOrderDo.setTenantId(reqBo.getTenantId());
        uocInspOrderDo.setTotalPurchaseFee(uocSaleOrderDo.getTotalPurchaseFee());
        uocInspOrderDo.setTotalSaleFee(uocSaleOrderDo.getTotalSaleFee());
        // 拼装发货验收关系
        List<UocShipInspRel> uocShipInspRelList = new ArrayList<>();
        uocShipOrderDoList.forEach(uocShipOrderDo1 -> {
            UocShipInspRel uocShipInspRel = UocRu.js(uocInspOrderDo, UocShipInspRel.class);
            uocShipInspRel.setId(IdUtil.nextId());
            uocShipInspRel.setShipOrderId(uocShipOrderDo1.getShipOrderId());
            uocShipInspRel.setRemark(null);
            uocShipInspRelList.add(uocShipInspRel);
        });
        // 拼装验收单明细
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocInspOrderItem uocInspOrderItem = UocRu.js(uocInspOrderDo, UocInspOrderItem.class);
            uocInspOrderItem.setInspOrderItemId(IdUtil.nextId());
            uocInspOrderItem.setInspCount(uocShipOrderItem.getArriveCount());
            uocInspOrderItem.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
            uocInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
            uocInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
            uocInspOrderItem.setRemark(null);
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        return uocInspOrderDo;
    }
    /**
     * 获取验收单编号
     */
    private String getInspOrderNo(UocSaleOrderDo uocSaleOrderDo){
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        return iUocInspOrderModel.getInspOrderNo(uocInspOrderDo).getInspOrderNo();
    }

    /**
     * 入参校验
     */
    private void validateArg(UocEcArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
    }
}
