package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocEvaluate;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocEvaluateDealServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题:UocEvaluateDealService
 * 说明:
 * 时间:2022/4/11 16:29
 *
 * @author 童垣杰
 */
@Slf4j
@HTServiceImpl
public class UocEvaluateDealServiceImpl implements UocEvaluateDealService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Override
    public UocEvaluateDealServiceRspBo dealEvaluate(UocEvaluateDealServiceReqBo reqBo) {
        //入参校验
        val(reqBo);

        //同步数据，创建时间会自动同步
        UocEvaluate uocEvaluate = new UocEvaluate();
        uocEvaluate.setEvaluateState(reqBo.getEvaluateState());
        uocEvaluate.setObjId(reqBo.getSaleOrderId());
        uocEvaluate.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocEvaluate.setCreateOperId(reqBo.getUserId().toString());
        iUocOrderModel.insertOrderEvaluate(uocEvaluate);

        return UocRu.success(UocEvaluateDealServiceRspBo.class);
    }

    private void val(UocEvaluateDealServiceReqBo reqBo){
        if (ObjectUtil.isNull(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getEvaluateState() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "评价状态不能为空");
        }
    }
}
